/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.cut;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.parser.record.AbstractRowOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.ExtendedBufferedReader;
import com.oceanbase.tools.loaddump.parser.record.cut.BufferReaderDelegate;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutRecordParserV2
extends AbstractRowOrientedParser {
    private static final Logger log = LoggerFactory.getLogger(CutRecordParserV2.class);
    private static final String DEFAULT_LINE_SEPARATOR = System.lineSeparator();
    private final AtomicInteger fieldCount = new AtomicInteger(0);
    private final BufferReaderDelegate reader;
    private final String nullReplacer;
    private final String emptyReplacer;
    private final String columnSplitter;
    private final boolean trailDelimiter;
    private final boolean withTrim;
    private final String lineSeparator;
    private final Character escapeCharacter;
    private final boolean skipHeader;
    private final StringBuilder sb;
    private final TokenIndexMatcher tokenIndexCounter;

    public CutRecordParserV2(Reader reader, String nullString, String emptyString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader) {
        this.reader = new BufferReaderDelegate(new ExtendedBufferedReader(reader), trailDelimiter, columnSplitter, lineSeparator, escapeChar);
        this.nullReplacer = nullString;
        this.emptyReplacer = emptyString;
        this.columnSplitter = columnSplitter;
        this.trailDelimiter = trailDelimiter;
        this.escapeCharacter = escapeChar;
        this.withTrim = withTrim;
        this.lineSeparator = lineSeparator;
        this.skipHeader = skipHeader;
        this.sb = new StringBuilder(4096);
        this.tokenIndexCounter = new TokenIndexMatcher(this.nullReplacer, this.emptyReplacer);
        this.skipRecordHeader();
    }

    public static CutRecordParserV2 parse(String string, String nullString, String emptyString, String columnSplitter, boolean trailDelimiter, Character escapeChar) throws IOException {
        return CutRecordParserV2.parse(string, nullString, emptyString, columnSplitter, trailDelimiter, escapeChar, false, DEFAULT_LINE_SEPARATOR);
    }

    public static CutRecordParserV2 parse(String string, String nullString, String columnSplitter, String emptyString, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator) throws IOException {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Input string is null");
        return CutRecordParserV2.parse(new StringReader(string), nullString, emptyString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, false);
    }

    public static CutRecordParserV2 parse(File file, String charset, String nullString, String emptyString, String columnSplitter, boolean trailDelimiter, Character escapeChar) throws IOException {
        return CutRecordParserV2.parse(file, charset, nullString, emptyString, columnSplitter, trailDelimiter, escapeChar, false, DEFAULT_LINE_SEPARATOR, false);
    }

    public static CutRecordParserV2 parse(File file, String charset, String nullString, String emptyString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"Input file is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return CutRecordParserV2.parse(Files.newInputStream(file.toPath(), new OpenOption[0]), charset, nullString, emptyString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, skipHeader);
    }

    public static CutRecordParserV2 parse(InputStream is, String charset, String nullString, String emptyString, String columnSplitter, boolean trailDelimiter, Character escapeChar) throws IOException {
        return CutRecordParserV2.parse(is, charset, nullString, emptyString, columnSplitter, trailDelimiter, escapeChar, false, DEFAULT_LINE_SEPARATOR, false);
    }

    public static CutRecordParserV2 parse(InputStream is, String charset, String nullString, String emptyString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader) throws IOException {
        Preconditions.checkArgument((is != null ? 1 : 0) != 0, (Object)"Input stream is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((columnSplitter != null ? 1 : 0) != 0, (Object)"Column splitter is null");
        return CutRecordParserV2.parse(new InputStreamReader(is, charset), nullString, emptyString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, skipHeader);
    }

    public static CutRecordParserV2 parse(Path path, String charset, String nullString, String emptyString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator) throws IOException {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Input path is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return CutRecordParserV2.parse(Files.newInputStream(path, new OpenOption[0]), charset, nullString, emptyString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, false);
    }

    public static CutRecordParserV2 parse(Reader reader, String nullString, String emptyString, String columnSplitter, boolean trailDelimiter, Character escapeChar) throws IOException {
        return CutRecordParserV2.parse(reader, nullString, emptyString, columnSplitter, trailDelimiter, escapeChar, false, DEFAULT_LINE_SEPARATOR, false);
    }

    public static CutRecordParserV2 parse(Reader reader, String nullString, String emptyString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader) throws IOException {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"Input reader is null");
        Preconditions.checkArgument((columnSplitter != null ? 1 : 0) != 0, (Object)"Input column splitter is null");
        return new CutRecordParserV2(reader, nullString, emptyString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, skipHeader);
    }

    public static CutRecordParserV2 parse(URL url, String charset, String nullString, String emptyString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader) throws IOException {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Input url is null");
        return CutRecordParserV2.parse(url.openStream(), charset, nullString, emptyString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, skipHeader);
    }

    private void skipRecordHeader() {
        if (this.skipHeader) {
            try {
                Record record = this.nextRecord();
                this.fieldCount.set(0);
                log.info("Skip header: {} finish", record == null ? "<No Header>" : record.getValues());
            }
            catch (IOException e) {
                log.warn("Skip header failed. Error: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record nextRecord() throws IOException {
        ArrayList<String> values = new ArrayList<String>(this.fieldCount.get());
        try {
            int dt;
            while ((dt = this.reader.read()) != -1) {
                char nextChar2;
                int i;
                int limit;
                char ch = (char)dt;
                if (ch == this.lineSeparator.charAt(0)) {
                    limit = this.lineSeparator.length() - 1;
                    if (limit > 0) {
                        this.reader.mark(limit);
                        for (i = 0; i < limit; ++i) {
                            nextChar2 = (char)this.reader.read();
                            if (nextChar2 == this.lineSeparator.charAt(i + 1)) continue;
                            this.reader.reset();
                            break;
                        }
                    }
                    if (i == limit) {
                        if (this.sb.length() == 0 && values.isEmpty()) {
                            Record nextChar2 = null;
                            return nextChar2;
                        }
                        if (this.fieldCount.get() == 0 || values.size() == this.fieldCount.get() - 1) {
                            this.addValue(values, this.sb.toString());
                            this.fieldCount.compareAndSet(0, values.size());
                            break;
                        }
                        if (this.fieldCount.get() > 0 && values.size() >= this.fieldCount.get()) {
                            this.addValue(values, this.sb.toString());
                            Record nextChar2 = new Record(String.join((CharSequence)this.columnSplitter, values), values, "Column count unmatched");
                            return nextChar2;
                        }
                        if (this.fieldCount.get() <= 0 || values.size() >= this.fieldCount.get() - 1) continue;
                        this.tokenIndexCounter.updateMatchIndex(ch);
                        this.sb.append(ch);
                        continue;
                    }
                }
                if (ch == this.columnSplitter.charAt(0)) {
                    limit = this.columnSplitter.length() - 1;
                    if (limit > 0) {
                        this.reader.mark(limit);
                        for (i = 0; i < limit; ++i) {
                            nextChar2 = (char)this.reader.read();
                            if (nextChar2 == this.columnSplitter.charAt(i + 1)) continue;
                            this.reader.reset();
                            break;
                        }
                    }
                    if (i == limit) {
                        this.addValue(values, this.sb.toString());
                        continue;
                    }
                    this.tokenIndexCounter.updateMatchIndex(ch);
                    this.sb.append(ch);
                    continue;
                }
                this.tokenIndexCounter.updateMatchIndex(ch);
                if (this.escapeCharacter != null && ch == this.escapeCharacter.charValue()) {
                    char unescaped = this.readEscape();
                    this.tokenIndexCounter.updateMatchIndex(unescaped);
                    this.sb.append(unescaped);
                    continue;
                }
                this.sb.append(ch);
            }
            if (!(dt != -1 || values.isEmpty() && this.sb.length() <= 0 || this.fieldCount.get() != 0 && values.size() > this.fieldCount.get())) {
                if (this.sb.length() > 0 && this.sb.toString().endsWith(this.lineSeparator)) {
                    this.sb.delete(this.sb.length() - this.lineSeparator.length(), this.sb.length());
                }
                this.addValue(values, this.sb.toString());
                int tmpFieldCount = this.fieldCount.get();
                this.fieldCount.set(0);
                if (values.size() < tmpFieldCount) {
                    Record record = new Record(String.join((CharSequence)this.columnSplitter, values), values, "Column count unmatched");
                    return record;
                }
            }
            Record record = values.isEmpty() ? null : new Record(values, 0L);
            return record;
        }
        catch (Exception e) {
            Record record = new Record(Lists.newArrayList(), -1L);
            return record;
        }
        finally {
            if (this.sb.length() > 0) {
                this.sb.setLength(0);
            }
        }
    }

    private void addValue(List<String> values, String toString) {
        if (this.tokenIndexCounter.isNullStrMatched()) {
            values.add(null);
        } else if (this.tokenIndexCounter.isEmptyStrMatched()) {
            values.add("");
        } else {
            values.add(this.withTrim ? toString.trim() : toString);
        }
        this.tokenIndexCounter.reset();
        if (this.sb.length() > 0) {
            this.sb.setLength(0);
        }
    }

    char readEscape() throws IOException {
        int ch = this.reader.read();
        switch (ch) {
            case 114: {
                return '\r';
            }
            case 110: {
                return '\n';
            }
            case 116: {
                return '\t';
            }
            case 98: {
                return '\b';
            }
            case 102: {
                return '\f';
            }
            case -1: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                throw new IOException("EOF whilst processing escape sequence");
            }
        }
        return (char)ch;
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        if (this.reader != null) {
            this.reader.close();
        }
        this.sb.setLength(0);
        super.close();
    }

    public String getNullReplacer() {
        return this.nullReplacer;
    }

    public String getEmptyReplacer() {
        return this.emptyReplacer;
    }

    public String getColumnSplitter() {
        return this.columnSplitter;
    }

    public boolean isTrailDelimiter() {
        return this.trailDelimiter;
    }

    public boolean isWithTrim() {
        return this.withTrim;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public boolean isSkipHeader() {
        return this.skipHeader;
    }

    static class TokenIndexMatcher {
        int tokenIdx = 0;
        int nullStrMatchIdx = 0;
        int emptyStrMatchIdx = 0;
        final String nullReplacer;
        final String emptyReplacer;

        private TokenIndexMatcher(String nullReplacer, String emptyReplacer) {
            this.nullReplacer = nullReplacer;
            this.emptyReplacer = emptyReplacer;
        }

        private void updateMatchIndex(int ch) {
            ++this.tokenIdx;
            this.nullStrMatchIdx = this.incrementMatchIndex(this.nullReplacer, this.nullStrMatchIdx, ch);
            this.emptyStrMatchIdx = this.incrementMatchIndex(this.emptyReplacer, this.emptyStrMatchIdx, ch);
        }

        private int incrementMatchIndex(String replacer, int matchIndex, int ch) {
            if (replacer != null && matchIndex < replacer.length() && replacer.charAt(matchIndex) == ch) {
                return matchIndex + 1;
            }
            return 0;
        }

        private void reset() {
            this.nullStrMatchIdx = 0;
            this.emptyStrMatchIdx = 0;
            this.tokenIdx = 0;
        }

        private boolean isNullStrMatched() {
            return this.nullReplacer != null && this.nullStrMatchIdx == this.nullReplacer.length() && this.nullStrMatchIdx == this.tokenIdx;
        }

        private boolean isEmptyStrMatched() {
            return this.emptyReplacer != null && this.emptyStrMatchIdx == this.emptyReplacer.length() && this.emptyStrMatchIdx == this.tokenIdx;
        }
    }
}

