/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.orc;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.parser.record.AbstractColumnOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.orc.OrcToJsonConverter;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DateColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;

public class OrcRecordParserV2
extends AbstractColumnOrientedParser {
    private final Reader reader;
    private RecordReader currentRecordReader;
    private final VectorizedRowBatch batch;
    private int currentStripIndex = 0;
    private final List<StripeInformation> stripes;
    private final TypeDescription schema;
    private ColumnValueGetter[] columnValueGetters;
    private final ColumnStatistics[] columnStatistics;
    private int rowIndex = 0;

    private OrcRecordParserV2(Reader reader, List<StripeInformation> stripes) {
        this.reader = reader;
        this.columnStatistics = reader.getStatistics();
        this.stripes = stripes;
        this.schema = reader.getSchema();
        this.initColumnHandlerMap(this.schema);
        this.batch = this.schema.createRowBatch(TypeDescription.RowBatchVersion.USE_DECIMAL64, 64);
        this.fieldNameList = new ArrayList(this.schema.getFieldNames());
    }

    public static OrcRecordParserV2 parse(URI uri, Configuration conf, List<StripeInformation> stripes) throws Exception {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"Input uri is null");
        return new Builder().withUri(uri).withConf(conf).withStripes(stripes).build();
    }

    public static OrcRecordParserV2 parse(String path, Configuration conf, List<StripeInformation> stripes) throws Exception {
        return OrcRecordParserV2.parse(new URI(path), conf, stripes);
    }

    public static OrcRecordParserV2 parse(String path, Configuration conf, boolean autoColumnMapping, List<String> extraColumnNames, List<String> extraColumnsValues, boolean isExtraColumnPartition, List<String> tableColumnNameList, List<StripeInformation> stripes) throws Exception {
        OrcRecordParserV2 parser = OrcRecordParserV2.parse(path, conf, stripes);
        parser.initFieldIndexMapAndExtraColumnsNameAndValue(autoColumnMapping, extraColumnNames, extraColumnsValues, isExtraColumnPartition, tableColumnNameList);
        return parser;
    }

    @Override
    public Record extractRecord() throws IOException {
        if (!this.fetchNextBatch()) {
            return null;
        }
        int curIdx = this.rowIndex++;
        int colNum = this.columnValueGetters.length;
        int extraColNum = CollectionUtils.isEmpty((Collection)this.extraColumnNames) ? 0 : this.extraColumnNames.size();
        String[] values = new String[colNum + extraColNum];
        Stream.iterate(0, i -> i + 1).limit(colNum).forEach(i -> {
            values[i.intValue()] = this.columnValueGetters[i].getValue(this.batch.cols[i], curIdx);
        });
        Stream.iterate(0, i -> i + 1).limit(extraColNum).forEach(i -> {
            values[colNum + i.intValue()] = (String)this.extraColumnsValues.get((int)i);
        });
        return new Record(values);
    }

    private boolean fetchNextBatch() throws IOException {
        if (this.batch.size != 0 && this.rowIndex < this.batch.size) {
            return true;
        }
        if (CollectionUtils.isEmpty(this.stripes)) {
            if (this.currentRecordReader == null) {
                this.currentRecordReader = this.reader.rows(this.reader.options().schema(this.schema));
            }
            this.rowIndex = 0;
            this.batch.reset();
            return this.currentRecordReader.nextBatch(this.batch);
        }
        if (this.currentStripIndex > this.stripes.size()) {
            return false;
        }
        if (this.currentRecordReader == null) {
            this.currentRecordReader = this.rolloverStripe();
        }
        this.rowIndex = 0;
        this.batch.reset();
        if (this.currentRecordReader.nextBatch(this.batch)) {
            return true;
        }
        if (this.currentStripIndex < this.stripes.size()) {
            this.currentRecordReader = this.rolloverStripe();
            this.rowIndex = 0;
            this.batch.reset();
            return this.currentRecordReader.nextBatch(this.batch);
        }
        return false;
    }

    private RecordReader rolloverStripe() throws IOException {
        StripeInformation stripe = this.stripes.get(this.currentStripIndex++);
        return this.reader.rows(this.reader.options().schema(this.reader.getSchema()).range(stripe.getOffset(), stripe.getLength()));
    }

    private void initColumnHandlerMap(TypeDescription schema) {
        int colNum = schema.getChildren().size();
        this.columnValueGetters = new ColumnValueGetter[colNum];
        block8: for (int i = 0; i < colNum; ++i) {
            TypeDescription type = (TypeDescription)schema.getChildren().get(i);
            boolean hasNull = this.columnStatistics[i + 1].hasNull();
            switch (type.getCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    if (hasNull) {
                        this.columnValueGetters[i] = (vec, rowIdx) -> vec.isNull[rowIdx] ? null : String.valueOf(((LongColumnVector)vec).vector[rowIdx]);
                        continue block8;
                    }
                    this.columnValueGetters[i] = (vec, rowIdx) -> String.valueOf(((LongColumnVector)vec).vector[rowIdx]);
                    continue block8;
                }
                case FLOAT: 
                case DOUBLE: {
                    if (hasNull) {
                        this.columnValueGetters[i] = (vec, rowIdx) -> vec.isNull[rowIdx] ? null : String.valueOf(((DoubleColumnVector)vec).vector[rowIdx]);
                        continue block8;
                    }
                    this.columnValueGetters[i] = (vec, rowIdx) -> String.valueOf(((DoubleColumnVector)vec).vector[rowIdx]);
                    continue block8;
                }
                case DECIMAL: {
                    if (hasNull) {
                        this.columnValueGetters[i] = (vec, rowIdx) -> {
                            if (vec.isNull[rowIdx]) {
                                return null;
                            }
                            if (vec.type == ColumnVector.Type.DECIMAL) {
                                return String.valueOf(((DecimalColumnVector)vec).vector[rowIdx]);
                            }
                            return String.valueOf(((Decimal64ColumnVector)vec).vector[rowIdx]);
                        };
                        continue block8;
                    }
                    this.columnValueGetters[i] = (vec, rowIdx) -> {
                        if (vec.type == ColumnVector.Type.DECIMAL) {
                            return String.valueOf(((DecimalColumnVector)vec).vector[rowIdx]);
                        }
                        return String.valueOf(((Decimal64ColumnVector)vec).vector[rowIdx]);
                    };
                    continue block8;
                }
                case DATE: {
                    int finalI = i;
                    if (hasNull) {
                        this.columnValueGetters[i] = (vec, rowIdx) -> vec.isNull[rowIdx] ? null : ((DateColumnVector)vec).formatDate(finalI);
                        continue block8;
                    }
                    this.columnValueGetters[i] = (vec, rowIdx) -> ((DateColumnVector)vec).formatDate(finalI);
                    continue block8;
                }
                case TIMESTAMP: {
                    if (hasNull) {
                        this.columnValueGetters[i] = (vec, rowIdx) -> {
                            if (vec.isNull[rowIdx]) {
                                return null;
                            }
                            long time = ((TimestampColumnVector)vec).getTime(rowIdx) / 1000L;
                            int nanos = ((TimestampColumnVector)vec).getNanos(rowIdx);
                            return LocalDateTime.ofEpochSecond(time, nanos, ZoneOffset.UTC).toString();
                        };
                        continue block8;
                    }
                    this.columnValueGetters[i] = (vec, rowIdx) -> {
                        if (vec.isNull[rowIdx]) {
                            return null;
                        }
                        long time = ((TimestampColumnVector)vec).getTime(rowIdx) / 1000L;
                        int nanos = ((TimestampColumnVector)vec).getNanos(rowIdx);
                        return LocalDateTime.ofEpochSecond(time, nanos, ZoneOffset.UTC).toString();
                    };
                    continue block8;
                }
                case MAP: 
                case LIST: 
                case STRUCT: 
                case UNION: {
                    this.columnValueGetters[i] = (vec, rowIdx) -> {
                        if (hasNull && vec.isNull[rowIdx]) {
                            return null;
                        }
                        return OrcToJsonConverter.serializeToJsonString(vec, type, rowIdx);
                    };
                    continue block8;
                }
                default: {
                    this.columnValueGetters[i] = hasNull ? (vec, rowIdx) -> vec.isNull[rowIdx] ? null : String.valueOf(((BytesColumnVector)vec).toString(rowIdx)) : (vec, rowIdx) -> String.valueOf(((BytesColumnVector)vec).toString(rowIdx));
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.batch != null) {
            this.batch.reset();
        }
        if (this.currentRecordReader != null) {
            this.currentRecordReader.close();
            this.closed = true;
        }
        if (this.reader != null) {
            this.reader.close();
        }
        super.close();
    }

    public static class Builder {
        private URI uri;
        private Configuration conf = new Configuration();
        private List<StripeInformation> stripes;

        public Builder withUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder withStripes(List<StripeInformation> stripes) {
            this.stripes = stripes;
            return this;
        }

        public OrcRecordParserV2 build() throws IOException {
            Preconditions.checkArgument((this.uri != null ? 1 : 0) != 0, (Object)"Input uri is null");
            this.conf.setBoolean(OrcConf.SKIP_CORRUPT_DATA.getAttribute(), false);
            OrcFile.ReaderOptions options = new OrcFile.ReaderOptions(this.conf);
            return new OrcRecordParserV2(OrcFile.createReader((Path)new Path(this.uri), (OrcFile.ReaderOptions)options), this.stripes);
        }
    }

    static interface ColumnValueGetter {
        public String getValue(ColumnVector var1, int var2);
    }
}

