/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.orc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.orc.TypeDescription;

public class OrcToJsonConverter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String serializeToJsonString(ColumnVector vec, TypeDescription schema, int row) {
        StringWriter stringWriter = new StringWriter(1024);
        JsonFactory factory = new JsonFactory();
        try (JsonGenerator writer = factory.createGenerator((Writer)stringWriter);){
            OrcToJsonConverter.printValue(writer, vec, schema, row);
            writer.flush();
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printMap(JsonGenerator writer, MapColumnVector vector, TypeDescription schema, int row) throws IOException {
        writer.writeStartObject();
        TypeDescription keyType = (TypeDescription)schema.getChildren().get(0);
        TypeDescription valueType = (TypeDescription)schema.getChildren().get(1);
        int offset = (int)vector.offsets[row];
        int i = 0;
        while ((long)i < vector.lengths[row]) {
            OrcToJsonConverter.printField(writer, vector.keys, keyType, offset + i);
            OrcToJsonConverter.printValue(writer, vector.values, valueType, offset + i);
            ++i;
        }
        writer.writeEndObject();
    }

    public static void printList(JsonGenerator writer, ListColumnVector vector, TypeDescription schema, int row) throws IOException {
        writer.writeStartArray();
        int offset = (int)vector.offsets[row];
        TypeDescription childType = (TypeDescription)schema.getChildren().get(0);
        int i = 0;
        while ((long)i < vector.lengths[row]) {
            OrcToJsonConverter.printValue(writer, vector.child, childType, offset + i);
            ++i;
        }
        writer.writeEndArray();
    }

    public static void printUnion(JsonGenerator writer, UnionColumnVector vector, TypeDescription schema, int row) throws IOException {
        int tag = vector.tags[row];
        OrcToJsonConverter.printValue(writer, vector.fields[tag], (TypeDescription)schema.getChildren().get(tag), row);
    }

    public static void printStruct(JsonGenerator writer, StructColumnVector batch, TypeDescription schema, int row) throws IOException {
        writer.writeStartObject();
        List fieldNames = schema.getFieldNames();
        List fieldTypes = schema.getChildren();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            writer.writeFieldName((String)fieldNames.get(i));
            OrcToJsonConverter.printValue(writer, batch.fields[i], (TypeDescription)fieldTypes.get(i), row);
        }
        writer.writeEndObject();
    }

    public static void printBinary(JsonGenerator writer, BytesColumnVector vector, int row) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int offset = vector.start[row];
        for (int i = 0; i < vector.length[row]; ++i) {
            int value = 0xFF & vector.vector[row][offset + i];
            buffer.append(String.format("%02x", value));
        }
        writer.writeString(buffer.toString());
    }

    public static void printValue(JsonGenerator writer, ColumnVector vector, TypeDescription schema, int row) throws IOException {
        block16: {
            block15: {
                if (vector.isRepeating) {
                    row = 0;
                }
                if (!vector.noNulls && vector.isNull[row]) break block15;
                switch (schema.getCategory()) {
                    case BOOLEAN: {
                        writer.writeBoolean(((LongColumnVector)vector).vector[row] != 0L);
                        break block16;
                    }
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        writer.writeNumber(((LongColumnVector)vector).vector[row]);
                        break block16;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        writer.writeNumber(((DoubleColumnVector)vector).vector[row]);
                        break block16;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        String str = ((BytesColumnVector)vector).toString(row);
                        writer.writeString(str);
                        break block16;
                    }
                    case BINARY: {
                        OrcToJsonConverter.printBinary(writer, (BytesColumnVector)vector, row);
                        break block16;
                    }
                    case DECIMAL: {
                        writer.writeString(((DecimalColumnVector)vector).vector[row].toString());
                        break block16;
                    }
                    case DATE: {
                        writer.writeString(new DateWritable((int)((LongColumnVector)vector).vector[row]).toString());
                        break block16;
                    }
                    case TIMESTAMP: {
                        writer.writeString(((TimestampColumnVector)vector).asScratchTimestamp(row).toString());
                        break block16;
                    }
                    case LIST: {
                        OrcToJsonConverter.printList(writer, (ListColumnVector)vector, schema, row);
                        break block16;
                    }
                    case MAP: {
                        OrcToJsonConverter.printMap(writer, (MapColumnVector)vector, schema, row);
                        break block16;
                    }
                    case STRUCT: {
                        OrcToJsonConverter.printStruct(writer, (StructColumnVector)vector, schema, row);
                        break block16;
                    }
                    case UNION: {
                        OrcToJsonConverter.printUnion(writer, (UnionColumnVector)vector, schema, row);
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + schema.toString());
                    }
                }
            }
            writer.writeNull();
        }
    }

    public static void printField(JsonGenerator writer, ColumnVector vector, TypeDescription schema, int row) throws IOException {
        block16: {
            block15: {
                if (vector.isRepeating) {
                    row = 0;
                }
                if (!vector.noNulls && vector.isNull[row]) break block15;
                switch (schema.getCategory()) {
                    case BOOLEAN: {
                        writer.writeFieldName((((LongColumnVector)vector).vector[row] != 0L) + "");
                        break block16;
                    }
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        writer.writeFieldName(((LongColumnVector)vector).vector[row] + "");
                        break block16;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        writer.writeFieldName(((DoubleColumnVector)vector).vector[row] + "");
                        break block16;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        writer.writeFieldName(((BytesColumnVector)vector).toString(row));
                        break block16;
                    }
                    case BINARY: {
                        OrcToJsonConverter.printBinary(writer, (BytesColumnVector)vector, row);
                        break block16;
                    }
                    case DECIMAL: {
                        writer.writeFieldName(((DecimalColumnVector)vector).vector[row].toString());
                        break block16;
                    }
                    case DATE: {
                        writer.writeFieldName(new DateWritable((int)((LongColumnVector)vector).vector[row]).toString());
                        break block16;
                    }
                    case TIMESTAMP: {
                        writer.writeFieldName(((TimestampColumnVector)vector).asScratchTimestamp(row).toString());
                        break block16;
                    }
                    case LIST: {
                        OrcToJsonConverter.printList(writer, (ListColumnVector)vector, schema, row);
                        break block16;
                    }
                    case MAP: {
                        OrcToJsonConverter.printMap(writer, (MapColumnVector)vector, schema, row);
                        break block16;
                    }
                    case STRUCT: {
                        OrcToJsonConverter.printStruct(writer, (StructColumnVector)vector, schema, row);
                        break block16;
                    }
                    case UNION: {
                        OrcToJsonConverter.printUnion(writer, (UnionColumnVector)vector, schema, row);
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + schema.toString());
                    }
                }
            }
            writer.writeNull();
        }
    }

    public static void printRow(JsonGenerator writer, VectorizedRowBatch batch, TypeDescription schema, int row) throws IOException {
        if (schema.getCategory() == TypeDescription.Category.STRUCT) {
            List fieldTypes = schema.getChildren();
            List fieldNames = schema.getFieldNames();
            writer.writeStartObject();
            for (int c = 0; c < batch.cols.length; ++c) {
                writer.writeFieldName((String)fieldNames.get(c));
                OrcToJsonConverter.printValue(writer, batch.cols[c], (TypeDescription)fieldTypes.get(c), row);
            }
            writer.writeEndObject();
        } else {
            OrcToJsonConverter.printValue(writer, batch.cols[0], schema, row);
        }
    }
}

