/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.par;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.parser.record.par.ColumnHandler;
import org.apache.parquet.example.data.Group;

public class LogicalIntColumnHandler
implements ColumnHandler {
    private final int bitWidth;
    private final boolean isSigned;

    public LogicalIntColumnHandler(int bitWidth, boolean isSigned) {
        Preconditions.checkArgument((bitWidth < 0 || bitWidth > 64 ? 1 : 0) != 0, (Object)"bitWidth must be between 0 and 64");
        this.bitWidth = bitWidth;
        this.isSigned = isSigned;
    }

    @Override
    public String getValue(Group group, int colIdx) {
        if (group.getFieldRepetitionCount(colIdx) == 0) {
            return null;
        }
        if (this.bitWidth <= 32) {
            return this.isSigned ? Integer.toString(group.getInteger(colIdx, 0)) : Integer.toUnsignedString(group.getInteger(colIdx, 0));
        }
        long value = group.getLong(colIdx, 0);
        return this.isSigned ? Long.toString(value) : Long.toUnsignedString(value);
    }
}

