/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.par;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.Type;

public class ParquetToJsonConverter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String serializeToJsonString(Group group, int colIdx) {
        StringWriter stringWriter = new StringWriter(1024);
        JsonFactory factory = new JsonFactory();
        try (JsonGenerator writer = factory.createGenerator((Writer)stringWriter);){
            ParquetToJsonConverter.printValue(writer, group, colIdx, 0);
            writer.flush();
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printStruct(JsonGenerator writer, Group group) throws IOException {
        int fieldRepetitionCount = group.getFieldRepetitionCount(0);
        if (fieldRepetitionCount == 0 && Type.Repetition.OPTIONAL == group.getType().getRepetition()) {
            writer.writeNull();
            return;
        }
        List fields = group.getType().getFields();
        writer.writeStartObject();
        for (int i = 0; i < fields.size(); ++i) {
            writer.writeFieldName(((Type)fields.get(i)).getName());
            ParquetToJsonConverter.printValue(writer, group, i, 0);
        }
        writer.writeEndObject();
    }

    public static void printList(JsonGenerator writer, Group group) throws IOException {
        int fieldRepetitionCount = group.getFieldRepetitionCount(0);
        if (fieldRepetitionCount == 0 && Type.Repetition.OPTIONAL == group.getType().getRepetition()) {
            writer.writeNull();
            return;
        }
        writer.writeStartArray();
        for (int i = 0; i < fieldRepetitionCount; ++i) {
            ParquetToJsonConverter.printValue(writer, group, 0, i);
        }
        writer.writeEndArray();
    }

    public static void printMap(JsonGenerator writer, Group group) throws IOException {
        int fieldRepetitionCount = group.getFieldRepetitionCount(0);
        if (fieldRepetitionCount == 0 && Type.Repetition.OPTIONAL == group.getType().getRepetition()) {
            writer.writeNull();
            return;
        }
        writer.writeStartObject();
        for (int i = 0; i < fieldRepetitionCount; ++i) {
            Group innerGroup = group.getGroup(0, i);
            writer.writeFieldName(innerGroup.getString(0, 0));
            ParquetToJsonConverter.printValue(writer, innerGroup, 1, 0);
        }
        writer.writeEndObject();
    }

    public static void printValue(JsonGenerator writer, Group group, int colIdx, int arrIdx) throws IOException {
        int repetitionCount = group.getFieldRepetitionCount(colIdx);
        if (repetitionCount == 0) {
            writer.writeNull();
            return;
        }
        Type type = (Type)group.getType().getFields().get(colIdx);
        LogicalTypeAnnotation logicalType = type.getLogicalTypeAnnotation();
        if (logicalType != null) {
            if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
                BigDecimal decimal = new BigDecimal(new BigInteger(group.getBinary(colIdx, arrIdx).getBytes()), scale);
                writer.writeNumber(decimal);
            } else if (logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                String num;
                int bitWidth = ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType).getBitWidth();
                boolean isSigned = ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType).isSigned();
                if (bitWidth <= 32) {
                    num = isSigned ? Integer.toString(group.getInteger(colIdx, arrIdx)) : Integer.toUnsignedString(group.getInteger(colIdx, arrIdx));
                } else {
                    long value = group.getLong(colIdx, arrIdx);
                    num = isSigned ? Long.toString(value) : Long.toUnsignedString(value);
                }
                writer.writeString(num);
            } else if (logicalType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                String date = new Date((long)group.getInteger(colIdx, arrIdx) * 24L * 60L * 60L * 1000L).toString();
                writer.writeString(date);
            } else if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                LogicalTypeAnnotation.TimeUnit timeUnit = ((LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalType).getUnit();
                String time = null;
                long value = group.getLong(colIdx, arrIdx);
                switch (timeUnit) {
                    case MILLIS: {
                        time = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(value)).toString();
                        break;
                    }
                    case MICROS: {
                        time = LocalTime.ofNanoOfDay(TimeUnit.MICROSECONDS.toNanos(value)).toString();
                        break;
                    }
                    case NANOS: {
                        time = LocalTime.ofNanoOfDay(value).toString();
                    }
                }
                writer.writeString(time);
            } else if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                LogicalTypeAnnotation.TimeUnit timeUnit = ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType).getUnit();
                String time = null;
                long value = group.getLong(colIdx, arrIdx);
                switch (timeUnit) {
                    case MILLIS: {
                        time = LocalDateTime.ofEpochSecond(value / 1000L, (int)(value % 1000L) * 1000000, ZoneOffset.UTC).toString();
                        break;
                    }
                    case MICROS: {
                        time = LocalDateTime.ofEpochSecond(value / 1000000L, (int)(value % 1000000L * 1000L), ZoneOffset.UTC).toString();
                        break;
                    }
                    case NANOS: {
                        time = LocalDateTime.ofEpochSecond(value / 1000000000L, (int)(value % 1000000000L), ZoneOffset.UTC).toString();
                    }
                }
                writer.writeString(time);
            } else if (logicalType instanceof LogicalTypeAnnotation.BsonLogicalTypeAnnotation) {
                String hex = Hex.encodeHexString((byte[])group.getBinary(colIdx, arrIdx).getBytes());
                writer.writeString(hex);
            } else if (logicalType instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation) {
                ParquetToJsonConverter.printMap(writer, group.getGroup(colIdx, arrIdx));
            } else if (logicalType instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                ParquetToJsonConverter.printList(writer, group.getGroup(colIdx, arrIdx));
            } else if (logicalType instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation) {
                ParquetToJsonConverter.printStruct(writer, group.getGroup(colIdx, arrIdx));
            } else {
                String s = String.valueOf(group.getString(colIdx, arrIdx));
                writer.writeString(s);
            }
            return;
        }
        if (type instanceof GroupType) {
            ParquetToJsonConverter.printStruct(writer, group.getGroup(colIdx, arrIdx));
            return;
        }
        if (type.isPrimitive()) {
            switch (type.asPrimitiveType().getPrimitiveTypeName()) {
                case INT32: {
                    int v1 = group.getInteger(colIdx, arrIdx);
                    writer.writeNumber(v1);
                    break;
                }
                case INT64: {
                    long v2 = group.getLong(colIdx, arrIdx);
                    writer.writeNumber(v2);
                    break;
                }
                case INT96: {
                    byte[] bytes = group.getBinary(colIdx, arrIdx).getBytes();
                    String tsNanos = Hex.encodeHexString((byte[])bytes);
                    writer.writeString(tsNanos);
                    break;
                }
                case BOOLEAN: {
                    boolean v4 = group.getBoolean(colIdx, arrIdx);
                    writer.writeBoolean(v4);
                    break;
                }
                case FLOAT: {
                    float v5 = group.getFloat(colIdx, arrIdx);
                    writer.writeNumber(v5);
                    break;
                }
                case DOUBLE: {
                    double v6 = group.getDouble(colIdx, arrIdx);
                    writer.writeNumber(v6);
                    break;
                }
                default: {
                    String hex = Hex.encodeHexString((byte[])group.getBinary(colIdx, arrIdx).getBytes());
                    writer.writeString(hex);
                }
            }
        }
    }
}

