/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.sql;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.parser.record.AbstractRowOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.ExtendedBufferedReader;
import com.oceanbase.tools.loaddump.parser.record.Token;
import com.oceanbase.tools.loaddump.parser.record.sql.SqlLexer;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class SqlRecordParser
extends AbstractRowOrientedParser {
    private final SqlLexer lexer;
    private final long characterOffset;
    private SqlType sqlType = SqlType.SQL;
    private final Token reusableToken = new Token();

    private SqlRecordParser(Reader reader, ServerMode serverMode) throws IOException {
        this(reader, 0L, serverMode);
    }

    private SqlRecordParser(Reader reader, long characterOffset, ServerMode serverMode) throws IOException {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"Input reader is null");
        this.characterOffset = characterOffset;
        this.lexer = new SqlLexer(new ExtendedBufferedReader(reader), serverMode);
    }

    public static SqlRecordParser parse(File file, String charset, ServerMode serverMode) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"Input file is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return new SqlRecordParser(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset), serverMode);
    }

    public static SqlRecordParser parse(InputStream stream, String charset, ServerMode serverMode) throws IOException {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"Input stream is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return SqlRecordParser.parse(new InputStreamReader(stream, charset), serverMode);
    }

    public static SqlRecordParser parse(Path path, String charset, ServerMode serverMode) throws IOException {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Input path is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return SqlRecordParser.parse(Files.newInputStream(path, new OpenOption[0]), charset, serverMode);
    }

    public static SqlRecordParser parse(Reader reader, ServerMode serverMode) throws IOException {
        return new SqlRecordParser(reader, serverMode);
    }

    public static SqlRecordParser parse(String string, ServerMode serverMode) throws IOException {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Input string is null");
        return new SqlRecordParser(new StringReader(string), serverMode);
    }

    public static SqlRecordParser parse(URL url, String charset, ServerMode serverMode) throws IOException {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Input url is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return new SqlRecordParser(new InputStreamReader(url.openStream(), charset), serverMode);
    }

    @Override
    public void close() throws Exception {
        if (this.lexer != null) {
            this.lexer.close();
        }
        super.close();
    }

    public long getCurrentLineNumber() {
        return this.lexer.getCurrentLineNumber();
    }

    public String getFirstEndOfLine() {
        return this.lexer.getFirstEol();
    }

    @Override
    public boolean isClosed() {
        return this.lexer.isClosed();
    }

    public void setSqlType(SqlType sqlType) {
        Preconditions.checkArgument((sqlType != null ? 1 : 0) != 0, (Object)"The SqlType is null");
        this.sqlType = sqlType;
    }

    public void setDelimiter(String delimiter) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(delimiter), (Object)"The elimiter is null");
        this.lexer.setDelimiter(delimiter);
    }

    @Override
    public Record nextRecord() throws IOException {
        long startCharPosition = this.lexer.getCharacterPosition() + this.characterOffset;
        block7: do {
            this.reusableToken.reset();
            this.lexer.nextToken(this.reusableToken);
            switch (this.reusableToken.type) {
                case TOKEN: {
                    break;
                }
                case EOS: {
                    return new Record(this.toSql(), startCharPosition);
                }
                case EOF: {
                    if (!this.reusableToken.isReady) continue block7;
                    return new Record(this.toSql(), startCharPosition);
                }
                case INVALID: {
                    throw new IOException("Invalid Token. Position: [" + this.getCurrentLineNumber() + ", " + this.lexer.getCharacterPosition() + "]");
                }
                case COMMENT: {
                    this.reusableToken.type = Token.Type.TOKEN;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected Token type: " + (Object)((Object)this.reusableToken.type));
                }
            }
        } while (this.reusableToken.type == Token.Type.TOKEN);
        return null;
    }

    private String toSql() {
        try {
            StringBuilder sb = new StringBuilder();
            if (SqlType.PL.equals((Object)this.getSqlType())) {
                sb.append("DELIMITER ").append(this.lexer.getDelimiter()).append("\n");
            }
            String string = sb.append(this.reusableToken.trimToString()).toString();
            return string;
        }
        finally {
            this.reusableToken.reset();
        }
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public static enum SqlType {
        PL,
        SQL;

    }
}

