/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.SourceType;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.resource.FileWithParentDirInfo;
import com.oceanbase.tools.loaddump.resource.ResourceV2;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFinderV2 {
    private static final Logger log = LoggerFactory.getLogger(ResourceFinderV2.class);
    private final LoadParameter parameter;
    private final StorageConfig storageConfig;
    private final String filePath;
    private final FileStatus inputFile;
    private final List<String> fileSuffixes;
    private final List<String> tableNames;
    private final Map<String, String> sourceTargetTableMap;
    private Pattern fileNameRegularExprPattern;

    public ResourceFinderV2(LoadParameter parameter) {
        this.parameter = parameter;
        this.filePath = parameter.getFilePath();
        this.storageConfig = parameter.getStorageConfig();
        this.inputFile = parameter.getInputFile();
        String fileNameRegularExpr = parameter.getFileNameRegExp();
        if (StringUtils.isNotBlank(fileNameRegularExpr)) {
            this.fileNameRegularExprPattern = Pattern.compile(fileNameRegularExpr);
        }
        this.fileSuffixes = parameter.getFileSuffixes();
        this.tableNames = parameter.getDatabase().getTableNames();
        this.sourceTargetTableMap = parameter.getSourceTargetTableMap();
    }

    public List<ResourceV2> listSchemaResources() throws Exception {
        if (this.inputFile != null) {
            return Lists.newArrayList((Object[])new ResourceV2[]{new ResourceV2(this.storageConfig, ObjectType.FILE.getName(), this.inputFile.getPath().getName(), this.inputFile.getPath(), this.inputFile.getLen())});
        }
        log.info("List all matched data files in dest path...");
        Stopwatch stopwatch = Stopwatch.createStarted();
        DataFormat dataFormat = this.parameter.getDataFormat();
        List<String> suffix = dataFormat == DataFormat.MIX || dataFormat == DataFormat.DDL ? this.fileSuffixes : DataFormat.DDL.getFileSuffixes();
        List<FileStatus> fileStatuses = this.listFileStatus(suffix, true);
        List<ResourceV2> resources = this.filterMatchedSchemaResources(fileStatuses);
        log.info("Find {} data files in \"{}\" success. Elapsed: {}", new Object[]{resources.size(), new Path(this.storageConfig.getUri()), stopwatch});
        return resources;
    }

    private List<ResourceV2> filterMatchedSchemaResources(List<FileStatus> fileStatuses) {
        Map<ObjectType, Set<String>> whiteListMap = this.parameter.getWhiteListMap();
        Map<ObjectType, Set<String>> blackListMap = this.parameter.getBlackListMap();
        boolean compatibleWith3rd = this.parameter.getDataFormat() == DataFormat.MIX;
        ArrayList<ResourceV2> resources = new ArrayList<ResourceV2>(fileStatuses.size());
        HashSet<ObjectType> objectTypes = new HashSet<ObjectType>();
        for (FileStatus fileStatus : fileStatuses) {
            Path filePath = fileStatus.getPath();
            String fileName = filePath.getName();
            String parentPath = filePath.getParent().toString();
            String objectTypeName = ObjectType.FILE.getName();
            if (!compatibleWith3rd && this.parameter.isIncludeDdl()) {
                objectTypeName = new Path(parentPath).getName();
            }
            ObjectType objectType = ObjectType.valueOfName(objectTypeName);
            objectTypes.add(objectType);
            if (compatibleWith3rd && objectType == ObjectType.FILE) {
                resources.add(new ResourceV2(this.storageConfig, objectType.getName(), fileName, filePath, fileStatus.getLen()));
                continue;
            }
            if (!whiteListMap.containsKey((Object)objectType) && objectType != ObjectType.FILE) continue;
            int index = fileName.lastIndexOf("-schema.sql");
            String objectName = index > 0 ? fileName.substring(0, index) : fileName;
            Set whiteSet = whiteListMap.getOrDefault((Object)objectType, new HashSet());
            Set blackSet = blackListMap.getOrDefault((Object)objectType, new HashSet());
            if (DBUtils.matches(blackSet, objectName) || !CollectionUtils.isEmpty((Collection)whiteSet) && !DBUtils.matches(whiteSet, objectName)) continue;
            resources.add(new ResourceV2(this.storageConfig, objectType.getName(), objectName, filePath, fileStatus.getLen()));
        }
        Set whiteList = whiteListMap.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream()).collect(Collectors.toSet());
        Set blackList = blackListMap.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream()).collect(Collectors.toSet());
        if (!(!objectTypes.contains((Object)ObjectType.FILE) || whiteList.isEmpty() && blackList.isEmpty())) {
            log.warn("Due to the directory structure mismatch, files ending in -schema.sql will be imported unfiltered.");
        }
        return resources;
    }

    public List<ResourceV2> listRecordResources(boolean ignoreEmptyFile) throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String sourceType = this.parameter.getSourceType();
        if (SourceType.supportsDirNameAsPartitionValue(sourceType)) {
            List<ResourceV2> resources = this.listRecordResourcesWithSourceType();
            log.info("Find {} data files in: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), new Path(this.storageConfig.getUri()), stopwatch});
            return resources;
        }
        if (this.inputFile != null) {
            return Lists.newArrayList((Object[])new ResourceV2[]{new ResourceV2(this.storageConfig, ObjectType.TABLE.getName(), this.tableNames.get(0), this.inputFile.getPath(), this.inputFile.getLen())});
        }
        log.info("Listing all matched data files in dest path...");
        List<FileStatus> fileStatuses = this.listFileStatus(this.fileSuffixes, ignoreEmptyFile);
        List<ResourceV2> resources = this.filterMatchedRecordResources(fileStatuses);
        log.info("Find {} data files in: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), new Path(this.storageConfig.getUri()), stopwatch});
        return resources;
    }

    private List<ResourceV2> filterMatchedRecordResources(List<FileStatus> fileStatuses) {
        boolean isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        ArrayList<ResourceV2> resources = new ArrayList<ResourceV2>(fileStatuses.size());
        for (FileStatus fileStatus : fileStatuses) {
            String tableName;
            Path filePath = fileStatus.getPath();
            String string = tableName = isNotUseRegularExpr ? this.bindingFileToTableByDefaultRule(this.tableNames, filePath) : ResourceFinderV2.bindingFileToTableByRegex(this.parameter.getDatabaseName(), this.tableNames, filePath, this.fileNameRegularExprPattern);
            if (tableName == null) {
                log.info("Cannot find a binding for \"{}\", ignore it", (Object)filePath);
                continue;
            }
            String objectTypeName = ObjectType.FILE.getName();
            if (this.parameter.isIncludeDdl()) {
                String parentPath = filePath.getParent().toString();
                objectTypeName = parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
            }
            ObjectType objectType = ObjectType.valueOfName(objectTypeName);
            resources.add(new ResourceV2(this.storageConfig, objectType.getName(), tableName, filePath, fileStatus.getLen()));
            log.info("Binding table: \"{}\" to file: \"{}\" finished", (Object)tableName, (Object)filePath);
        }
        return resources;
    }

    private List<FileStatus> listFileStatus(List<String> suffixes, boolean ignoreEmptyFile) throws Exception {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        boolean isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        FileSystem fs = this.storageConfig.getFileSystem();
        Iterator<FileStatus> fIter = FileUtils.listFiles(fs, new Path(this.storageConfig.getUri()), true);
        HashSet<String> foundPaths = new HashSet<String>();
        while (fIter.hasNext()) {
            FileStatus status = fIter.next();
            String path = status.getPath().toUri().getPath();
            if (foundPaths.contains(path)) continue;
            foundPaths.add(path);
            if (isNotUseRegularExpr && suffixes.stream().noneMatch(s -> StringUtils.endsWith((CharSequence)path, (CharSequence)s)) || !status.isFile()) continue;
            if (status.getLen() == 0L && ignoreEmptyFile) {
                log.info("File: \"{}\" is empty and ignore setting is true, ignore it", (Object)path);
                continue;
            }
            if (isNotUseRegularExpr && suffixes.stream().noneMatch(s -> StringUtils.endsWith((CharSequence)path, (CharSequence)s))) continue;
            result.add(status);
        }
        return result;
    }

    private List<FileStatus> listFileStatusWithPartitionDirs() throws Exception {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        FileSystem fs = this.storageConfig.getFileSystem();
        Iterator<FileStatus> fIter = FileUtils.listFiles(fs, new Path(this.storageConfig.getUri()), true);
        HashSet<String> foundPaths = new HashSet<String>();
        while (fIter.hasNext()) {
            FileStatus status = fIter.next();
            String path = status.getPath().toUri().getPath();
            if (status.getLen() == 0L) {
                log.info("File: \"{}\" is empty, ignore it", (Object)path);
                continue;
            }
            if (foundPaths.contains(path)) continue;
            foundPaths.add(path);
            result.add(status);
        }
        return result;
    }

    public List<ResourceV2> listRecordResourcesWithSourceType() throws Exception {
        if (StorageType.LOCAL_DISK.equals((Object)this.storageConfig.getStorageType())) {
            return this.listLocalRecordResourcesWithSourceType();
        }
        return this.listRemoteRecordResourcesWithSourceType();
    }

    public List<ResourceV2> listLocalRecordResourcesWithSourceType() {
        String[] resourceUriSplit = this.filePath.split(File.separator);
        ArrayList<String> resourceUriPartitionDirs = new ArrayList<String>();
        for (String dirName : resourceUriSplit) {
            if (!dirName.contains("=")) continue;
            resourceUriPartitionDirs.add(dirName);
        }
        ArrayList<FileWithParentDirInfo> targetFileList = new ArrayList<FileWithParentDirInfo>();
        this.recursivelyFindTargetFiles(new File(this.storageConfig.getPath()), this.tableNames, resourceUriPartitionDirs, targetFileList);
        ArrayList<ResourceV2> resources = new ArrayList<ResourceV2>(targetFileList.size());
        for (FileWithParentDirInfo f : targetFileList) {
            String tableName;
            List<String> parentDirNames = f.getParentDirNames();
            if (CollectionUtils.isEmpty(this.tableNames)) {
                tableName = parentDirNames.get(0);
                if (CollectionUtils.isEmpty(parentDirNames) || !this.tableNames.contains(tableName)) {
                    log.info("Cannot find a binding for folder: \"{}\", path: \"{}\", ignore it", (Object)tableName, (Object)f.getPath());
                    continue;
                }
                resources.add(new ResourceV2(this.storageConfig, ObjectType.TABLE.getName(), tableName, new Path(f.getPath()), f.getFileLength(), f.getParentDirNames()));
                continue;
            }
            if (this.tableNames.size() == 1) {
                tableName = this.tableNames.get(0);
                resources.add(new ResourceV2(this.storageConfig, ObjectType.TABLE.getName(), tableName, new Path(f.getPath()), f.getFileLength(), f.getParentDirNames()));
                continue;
            }
            if (CollectionUtils.isEmpty(parentDirNames)) {
                log.info("Cannot find a binding for file: \"{}\", ignore it", (Object)f.getPath());
                continue;
            }
            String dirName = parentDirNames.get(0);
            if (this.tableNames.contains(dirName)) {
                resources.add(new ResourceV2(this.storageConfig, ObjectType.TABLE.getName(), dirName, new Path(f.getPath()), f.getFileLength(), f.getParentDirNames()));
                continue;
            }
            log.info("Cannot find a binding for folder: \"{}\", path: \"{}\", ignore it", (Object)dirName, (Object)f.getPath());
        }
        return resources;
    }

    private List<ResourceV2> listRemoteRecordResourcesWithSourceType() throws Exception {
        ArrayList<ResourceV2> resources = new ArrayList<ResourceV2>();
        List<FileStatus> fileStatuses = this.listFileStatusWithPartitionDirs();
        String[] resourceUriSplit = this.filePath.split(File.separator);
        ArrayList<String> resourceUriPartitionDirs = new ArrayList<String>();
        for (String dirName : resourceUriSplit) {
            if (!dirName.contains("=")) continue;
            resourceUriPartitionDirs.add(dirName);
        }
        for (FileStatus fileStatus : fileStatuses) {
            String fullPath = fileStatus.getPath().toUri().getPath();
            String[] split = (fullPath = fullPath.substring(this.filePath.length())).split(File.separator);
            String fileName = split[split.length - 1];
            if (fileName.startsWith(".")) {
                log.info("Path: \"{}\" is not a valid data file, ignore it", (Object)fileStatus.getPath());
                continue;
            }
            if (this.fileNameRegularExprPattern != null && !this.fileNameRegularExprPattern.matcher(fileName).matches()) {
                log.info("Path: \"{}\" does not match --file-regular-expression, ignore it", (Object)fileStatus.getPath());
                continue;
            }
            boolean pathInvalid = false;
            ArrayList<String> parentDirNames = new ArrayList<String>(resourceUriPartitionDirs);
            for (int i = 0; i < split.length - 1; ++i) {
                String dirName = split[i];
                if (StringUtils.isBlank(dirName)) continue;
                if (dirName.startsWith(".")) {
                    pathInvalid = true;
                    break;
                }
                parentDirNames.add(dirName);
            }
            if (pathInvalid) {
                log.info("Path: \"{}\" is not in a valid directory, ignore it", (Object)fileStatus.getPath());
                continue;
            }
            if (parentDirNames.isEmpty()) {
                if (CollectionUtils.isEmpty(this.tableNames) || this.tableNames.size() > 1) {
                    log.info("Cannot find a binding for path: \"{}\", ignore it", (Object)fileStatus.getPath());
                    continue;
                }
                resources.add(new ResourceV2(this.storageConfig, ObjectType.TABLE.getName(), this.tableNames.get(0), fileStatus.getPath(), fileStatus.getLen(), parentDirNames));
                continue;
            }
            if (((String)parentDirNames.get(0)).contains("=")) {
                if (CollectionUtils.isEmpty(this.tableNames) || this.tableNames.size() > 1) {
                    log.info("Cannot find a binding for folder: \"{}\", path: \"{}\", ignore it", parentDirNames.get(0), (Object)fileStatus.getPath());
                    continue;
                }
                resources.add(new ResourceV2(this.storageConfig, ObjectType.TABLE.getName(), this.tableNames.get(0), fileStatus.getPath(), fileStatus.getLen(), parentDirNames));
                continue;
            }
            String dirName = (String)parentDirNames.get(0);
            if (CollectionUtils.isEmpty(this.tableNames) || this.tableNames.contains(dirName) || this.tableNames.size() == 1) {
                resources.add(new ResourceV2(this.storageConfig, ObjectType.TABLE.getName(), dirName, fileStatus.getPath(), fileStatus.getLen(), parentDirNames));
                continue;
            }
            log.info("Cannot find a binding for folder: \"{}\", path: \"{}\", ignore it", (Object)dirName, (Object)fileStatus.getPath());
        }
        return resources;
    }

    private void recursivelyFindTargetFiles(File f, List<String> includeDirNames, List<String> path, List<FileWithParentDirInfo> targetFileList) {
        if (f.isFile()) {
            targetFileList.add(new FileWithParentDirInfo(f.getAbsolutePath(), path, f.length()));
            return;
        }
        boolean found = false;
        File[] files = f.listFiles(File::isFile);
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.getName().startsWith(".")) {
                    log.info("Skip hidden file: " + file.getAbsolutePath());
                    continue;
                }
                if (this.fileNameRegularExprPattern != null && !this.fileNameRegularExprPattern.matcher(file.getName()).matches()) {
                    log.info("Path: \"{}\" does not match --file-regular-expression, ignore it", (Object)file.getAbsolutePath());
                    continue;
                }
                found = true;
                targetFileList.add(new FileWithParentDirInfo(file.getAbsolutePath(), path, file.length()));
            }
        }
        if (found) {
            return;
        }
        File[] dirs = f.listFiles(File::isDirectory);
        if (dirs != null && dirs.length > 0) {
            for (File dir : dirs) {
                String dirName = dir.getName();
                if (dirName.startsWith(".")) {
                    log.info("Skip hidden dir: " + dir.getAbsolutePath());
                    continue;
                }
                if ("logs".equals(dirName)) {
                    log.info("Skip log dir: " + dir.getAbsolutePath());
                    continue;
                }
                ArrayList<String> pathCopy = new ArrayList<String>(path);
                pathCopy.add(dirName);
                this.recursivelyFindTargetFiles(dir, includeDirNames, pathCopy, targetFileList);
            }
        }
    }

    protected String bindingFileToTableByDefaultRule(Collection<String> tableNames, Path path) {
        String name = path.getName();
        String compressSuffix = this.parameter.getCompressAlgo().getSuffix();
        if (StringUtils.isNotBlank(name) && name.startsWith(".")) {
            return null;
        }
        if (StringUtils.isNotEmpty(compressSuffix) && name.indexOf(compressSuffix) > 0) {
            name = name.substring(0, name.indexOf(compressSuffix));
        }
        String tableName = DBUtils.extractObjectName(FileUtils.getTableName(name), null);
        if (JavaOpts.isBackupRestoreMode && MapUtils.isNotEmpty(this.sourceTargetTableMap)) {
            String targetTable = this.sourceTargetTableMap.get(tableName);
            return targetTable != null && tableNames.contains(targetTable) ? targetTable : null;
        }
        return tableNames.contains(tableName) ? tableName : null;
    }

    public static String bindingFileToTableByRegex(String database, Collection<String> tableNames, Path path, Pattern fileNameRegex) {
        Matcher matcher = fileNameRegex.matcher(DBUtils.extractObjectName(path.getName(), null));
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.groupCount() == 0) {
            Preconditions.checkArgument((tableNames.size() == 1 ? 1 : 0) != 0, (String)"Specified table count=(%s) is unexpected. As --file-regular-expression is specified.", (int)tableNames.size());
        }
        String schemaName = null;
        try {
            schemaName = matcher.group("schema");
            log.debug("Extracted database name '{}' from file '{}'", (Object)schemaName, (Object)path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (schemaName != null && !database.equals(schemaName)) {
            return null;
        }
        String tableName = null;
        try {
            tableName = matcher.group("table");
            log.debug("Extracted table name '{}' from file '{}'", (Object)tableName, (Object)path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tableName != null) {
            return tableNames.contains(tableName) ? tableName : null;
        }
        if (tableNames.size() == 1) {
            return tableNames.iterator().next();
        }
        return null;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public Map<String, String> getSourceTargetTableMap() {
        return this.sourceTargetTableMap;
    }
}

