/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource;

import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ResourceV2
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = -5187170496286780628L;
    protected String objectType;
    protected long totalSize;
    protected String objectName;
    private String path;
    private transient FileSystem fs;
    private transient StorageConfig storageConfig;
    private boolean closed;
    private transient List<String> parentDirNames;

    public ResourceV2(StorageConfig storageConfig, String objectType, String objectName, Path path, long totalSize) {
        this.objectType = objectType;
        this.totalSize = totalSize;
        this.objectName = objectName;
        this.storageConfig = storageConfig;
        this.path = storageConfig.isLocalFileSystem() ? StringUtils.removeStart((String)path.toString(), (String)"file:") : path.toString();
    }

    public ResourceV2(StorageConfig storageConfig, String objectType, String objectName, Path path, long totalSize, List<String> parentDirNames) {
        this(storageConfig, objectType, objectName, path, totalSize);
        this.parentDirNames = parentDirNames;
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public InputStream openInputStream(String fileEncoding) throws Exception {
        return this.openBoundedInputStream(fileEncoding, 0L, this.totalSize, false);
    }

    public InputStream openBoundedInputStream(String fileEncoding, long start, long end, boolean decompress) throws Exception {
        if (this.fs == null) {
            this.fs = this.storageConfig.getFileSystem();
        }
        FSDataInputStream fsis = this.fs.open(new Path(this.path));
        fsis.seek(start);
        BoundedInputStream bis = new BoundedInputStream((InputStream)fsis, end);
        bis.setPropagateClose(false);
        Object is = bis;
        if (decompress) {
            is = this.storageConfig.getCompressor().decompress((InputStream)bis);
        }
        if (fileEncoding != null && fileEncoding.toLowerCase(Locale.ENGLISH).startsWith("utf")) {
            is = new BOMInputStream((InputStream)is);
        }
        return is;
    }

    public ResourceV2() {
    }

    public String getObjectType() {
        return this.objectType;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getPath() {
        return this.path;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public StorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    public void setStorageConfig(StorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public List<String> getParentDirNames() {
        return this.parentDirNames;
    }

    public void setParentDirNames(List<String> parentDirNames) {
        this.parentDirNames = parentDirNames;
    }
}

