/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.oceanbase.tools.loaddump.schema.AbstractOwnership;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.base.IDefiner;
import com.oceanbase.tools.loaddump.schema.base.KeyColumn;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractIndex
extends AbstractOwnership
implements IDefiner {
    private final Map<String, String> collationMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 3188302206792580519L;
        {
            this.put("A", " ASC");
            this.put("D", " DESC");
            this.put("ASC", " ASC");
            this.put("DESC", " DESC");
            this.put("R", " RANDOM");
        }
    };
    private final Map<String, String> uniqueRuleMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 3188302206792580519L;
        {
            this.put("U", " UNIQUE");
            this.put("UNIQUE", " UNIQUE");
            this.put("V", " UNIQUE WHERE NOT NULL");
            this.put("E", " ENCODED VECTOR");
        }
    };
    private final Map<String, String> indexTypeMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = -1637246424096953846L;
        {
            this.put("HASH", " USING HASH");
            this.put("BTREE", " USING BTREE");
            this.put("NORMAL", " USING HASH");
            this.put("FUNCTION-BASED NORMAL", " USING HASH");
            this.put("BITMAP", " USING HASH");
        }
    };
    private final Collection<KeyColumn> indexColumns = new ArrayList<KeyColumn>();
    private String indexSchema;
    private String indexName;
    private String indexType;

    public AbstractIndex(AbstractSchema schema) {
        super(schema);
    }

    public String getWrappedIndexName() {
        return this.wrap(this.getIndexName());
    }

    public String getSchemaIndexName() {
        StringBuilder sb = new StringBuilder();
        if (super.getGlobal().withSchema()) {
            sb.append(this.wrap(this.getSchemaName())).append(".");
        }
        return sb.append(this.getWrappedIndexName()).toString();
    }

    public String getSimpleIndexName() {
        if (super.getGlobal().withSchema()) {
            return this.getIndexName();
        }
        return this.getSchemaName() + "." + this.getIndexName();
    }

    public StringBuilder joinIndexColumns() {
        return this.enclose(this.getIndexColumns().stream().map(e -> {
            String columnOrder;
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            String subPart = e.getSubPart();
            if (!"SPATIAL".equals(this.getIndexType()) && StringUtils.isNotBlank(subPart)) {
                columnName = columnName + "(" + subPart + ")";
            }
            if (StringUtils.isNotBlank(columnOrder = this.getCollationMapping().get(e.getColumnOrder()))) {
                columnName = columnName + columnOrder;
            }
            return columnName;
        }).collect(Collectors.joining(", ")));
    }

    public String toString() {
        return "AbstractIndex(collationMapping=" + this.getCollationMapping() + ", uniqueRuleMapping=" + this.getUniqueRuleMapping() + ", indexTypeMapping=" + this.getIndexTypeMapping() + ", indexColumns=" + this.getIndexColumns() + ", indexSchema=" + this.getIndexSchema() + ", indexName=" + this.getIndexName() + ", indexType=" + this.getIndexType() + ")";
    }

    public AbstractIndex() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractIndex)) {
            return false;
        }
        AbstractIndex other = (AbstractIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$collationMapping = this.getCollationMapping();
        Map<String, String> other$collationMapping = other.getCollationMapping();
        if (this$collationMapping == null ? other$collationMapping != null : !((Object)this$collationMapping).equals(other$collationMapping)) {
            return false;
        }
        Map<String, String> this$uniqueRuleMapping = this.getUniqueRuleMapping();
        Map<String, String> other$uniqueRuleMapping = other.getUniqueRuleMapping();
        if (this$uniqueRuleMapping == null ? other$uniqueRuleMapping != null : !((Object)this$uniqueRuleMapping).equals(other$uniqueRuleMapping)) {
            return false;
        }
        Map<String, String> this$indexTypeMapping = this.getIndexTypeMapping();
        Map<String, String> other$indexTypeMapping = other.getIndexTypeMapping();
        if (this$indexTypeMapping == null ? other$indexTypeMapping != null : !((Object)this$indexTypeMapping).equals(other$indexTypeMapping)) {
            return false;
        }
        Collection<KeyColumn> this$indexColumns = this.getIndexColumns();
        Collection<KeyColumn> other$indexColumns = other.getIndexColumns();
        if (this$indexColumns == null ? other$indexColumns != null : !((Object)this$indexColumns).equals(other$indexColumns)) {
            return false;
        }
        String this$indexSchema = this.getIndexSchema();
        String other$indexSchema = other.getIndexSchema();
        if (this$indexSchema == null ? other$indexSchema != null : !this$indexSchema.equals(other$indexSchema)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$indexType = this.getIndexType();
        String other$indexType = other.getIndexType();
        return !(this$indexType == null ? other$indexType != null : !this$indexType.equals(other$indexType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractIndex;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $collationMapping = this.getCollationMapping();
        result = result * 59 + ($collationMapping == null ? 43 : ((Object)$collationMapping).hashCode());
        Map<String, String> $uniqueRuleMapping = this.getUniqueRuleMapping();
        result = result * 59 + ($uniqueRuleMapping == null ? 43 : ((Object)$uniqueRuleMapping).hashCode());
        Map<String, String> $indexTypeMapping = this.getIndexTypeMapping();
        result = result * 59 + ($indexTypeMapping == null ? 43 : ((Object)$indexTypeMapping).hashCode());
        Collection<KeyColumn> $indexColumns = this.getIndexColumns();
        result = result * 59 + ($indexColumns == null ? 43 : ((Object)$indexColumns).hashCode());
        String $indexSchema = this.getIndexSchema();
        result = result * 59 + ($indexSchema == null ? 43 : $indexSchema.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : $indexType.hashCode());
        return result;
    }

    public Map<String, String> getCollationMapping() {
        return this.collationMapping;
    }

    public Map<String, String> getUniqueRuleMapping() {
        return this.uniqueRuleMapping;
    }

    public Map<String, String> getIndexTypeMapping() {
        return this.indexTypeMapping;
    }

    public Collection<KeyColumn> getIndexColumns() {
        return this.indexColumns;
    }

    public String getIndexSchema() {
        return this.indexSchema;
    }

    public void setIndexSchema(String indexSchema) {
        this.indexSchema = indexSchema;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }
}

