/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.configure.Global;
import com.oceanbase.tools.loaddump.schema.base.IGrammar;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ObMySqlSchema.class, name="ObMySqlSchema"), @JsonSubTypes.Type(value=ObOracleSchema.class, name="ObOracleSchema")})
public abstract class AbstractSchema
implements IGrammar {
    private Global global;
    private DbType dbType;
    private String catalogName;
    private String schemaName;
    private DbType originDbType;
    private String originSchemaName;

    public AbstractSchema(Global global, DbType dbType, String schemaName) {
        this(global, dbType, null, schemaName);
    }

    public AbstractSchema(Global global, DbType dbType, String catalogName, String schemaName) {
        this.global = global;
        this.dbType = dbType;
        this.originDbType = dbType;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.originSchemaName = schemaName;
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractSchema)) {
            return false;
        }
        AbstractSchema other = (AbstractSchema)obj;
        return Objects.equals(this.catalogName, other.catalogName) && Objects.equals(this.schemaName, other.schemaName);
    }

    public AbstractSchema() {
    }

    public Global getGlobal() {
        return this.global;
    }

    public void setGlobal(Global global) {
        this.global = global;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public DbType getOriginDbType() {
        return this.originDbType;
    }

    public void setOriginDbType(DbType originDbType) {
        this.originDbType = originDbType;
    }

    public String getOriginSchemaName() {
        return this.originSchemaName;
    }

    public void setOriginSchemaName(String originSchemaName) {
        this.originSchemaName = originSchemaName;
    }
}

