/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.AbstractTablePartition;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleTablePartition;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TableGroupSubPartition
extends AbstractTablePartition {
    private String subPartitionType;
    private int subPartitionColumnNum;
    private int subPartitionCount;
    private final Collection<ObOracleTablePartition.OracleTablePartitionTemplate> subPartitionTemplates = new LinkedHashSet<ObOracleTablePartition.OracleTablePartitionTemplate>();
    private final Map<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>> subPartitionItemMapping = new LinkedHashMap<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>>();

    public TableGroupSubPartition(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        if (this.isDefinedByTemplate()) {
            String subPartFormat = this.getSubPartFormat();
            StringBuilder sb = new StringBuilder(512);
            sb.append("\nSUBPARTITION TEMPLATE (");
            Iterator<ObOracleTablePartition.OracleTablePartitionTemplate> iter = this.getSubPartitionTemplates().iterator();
            while (iter.hasNext()) {
                ObOracleTablePartition.OracleTablePartitionTemplate subPartTemplate = iter.next();
                String subPartName = this.wrap(subPartTemplate.getSubPartitionName());
                sb.append("\n\t");
                sb.append(String.format(subPartFormat, subPartName, subPartTemplate.getHighBound()));
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            return sb.append("\n)");
        }
        return new StringBuilder(0);
    }

    @Override
    public String getQuotaCharacter() {
        DbType dbType = super.getDbType();
        if (dbType != null && dbType.isMySqlType()) {
            return "`";
        }
        return super.getQuotaCharacter();
    }

    public boolean isDefinedByTemplate() {
        return CollectionUtils.isNotEmpty(this.getSubPartitionTemplates());
    }

    public boolean isValid() {
        return this.getSubPartitionColumnNum() > 0;
    }

    public String getJdbcFieldName() {
        if ("LIST".equals(this.getSubPartitionType()) || "LIST COLUMNS".equals(this.getSubPartitionType())) {
            return "sub_part_list_val";
        }
        return "sub_part_high_bound_val";
    }

    public String getSubPartFormat() {
        if (DbType.OBORACLE_21.getType().equals(this.getDbType().getType()) && "LIST COLUMNS".equals(this.getSubPartitionType())) {
            return super.getTableSubPartTemplateMapping().get("LIST");
        }
        String type = this.getSubPartitionType();
        String subPartitionTemplate = super.getTableSubPartTemplateMapping().get(type);
        if (StringUtils.isEmpty((CharSequence)subPartitionTemplate)) {
            throw new IllegalStateException("SubPartition template is not found by type: " + type);
        }
        return subPartitionTemplate;
    }

    public String getSubPartitionType() {
        return this.subPartitionType;
    }

    public int getSubPartitionColumnNum() {
        return this.subPartitionColumnNum;
    }

    public int getSubPartitionCount() {
        return this.subPartitionCount;
    }

    public Collection<ObOracleTablePartition.OracleTablePartitionTemplate> getSubPartitionTemplates() {
        return this.subPartitionTemplates;
    }

    public Map<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>> getSubPartitionItemMapping() {
        return this.subPartitionItemMapping;
    }

    public TableGroupSubPartition() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableGroupSubPartition)) {
            return false;
        }
        TableGroupSubPartition other = (TableGroupSubPartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSubPartitionColumnNum() != other.getSubPartitionColumnNum()) {
            return false;
        }
        if (this.getSubPartitionCount() != other.getSubPartitionCount()) {
            return false;
        }
        String this$subPartitionType = this.getSubPartitionType();
        String other$subPartitionType = other.getSubPartitionType();
        if (this$subPartitionType == null ? other$subPartitionType != null : !this$subPartitionType.equals(other$subPartitionType)) {
            return false;
        }
        Collection<ObOracleTablePartition.OracleTablePartitionTemplate> this$subPartitionTemplates = this.getSubPartitionTemplates();
        Collection<ObOracleTablePartition.OracleTablePartitionTemplate> other$subPartitionTemplates = other.getSubPartitionTemplates();
        if (this$subPartitionTemplates == null ? other$subPartitionTemplates != null : !((Object)this$subPartitionTemplates).equals(other$subPartitionTemplates)) {
            return false;
        }
        Map<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>> this$subPartitionItemMapping = this.getSubPartitionItemMapping();
        Map<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>> other$subPartitionItemMapping = other.getSubPartitionItemMapping();
        return !(this$subPartitionItemMapping == null ? other$subPartitionItemMapping != null : !((Object)this$subPartitionItemMapping).equals(other$subPartitionItemMapping));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableGroupSubPartition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getSubPartitionColumnNum();
        result = result * 59 + this.getSubPartitionCount();
        String $subPartitionType = this.getSubPartitionType();
        result = result * 59 + ($subPartitionType == null ? 43 : $subPartitionType.hashCode());
        Collection<ObOracleTablePartition.OracleTablePartitionTemplate> $subPartitionTemplates = this.getSubPartitionTemplates();
        result = result * 59 + ($subPartitionTemplates == null ? 43 : ((Object)$subPartitionTemplates).hashCode());
        Map<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>> $subPartitionItemMapping = this.getSubPartitionItemMapping();
        result = result * 59 + ($subPartitionItemMapping == null ? 43 : ((Object)$subPartitionItemMapping).hashCode());
        return result;
    }

    public void setSubPartitionType(String subPartitionType) {
        this.subPartitionType = subPartitionType;
    }

    public void setSubPartitionColumnNum(int subPartitionColumnNum) {
        this.subPartitionColumnNum = subPartitionColumnNum;
    }

    public void setSubPartitionCount(int subPartitionCount) {
        this.subPartitionCount = subPartitionCount;
    }
}

