/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.accessor;

import com.oceanbase.tools.loaddump.common.SessionManager;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.CyclicReferenceException;
import com.oceanbase.tools.loaddump.common.exception.IncompleteMetadataException;
import com.oceanbase.tools.loaddump.configure.Configure;
import com.oceanbase.tools.loaddump.configure.Global;
import com.oceanbase.tools.loaddump.jdbc.JdbcTemplate;
import com.oceanbase.tools.loaddump.schema.AbstractColumn;
import com.oceanbase.tools.loaddump.schema.AbstractConstraint;
import com.oceanbase.tools.loaddump.schema.AbstractDatabase;
import com.oceanbase.tools.loaddump.schema.AbstractDatabaseLink;
import com.oceanbase.tools.loaddump.schema.AbstractDependency;
import com.oceanbase.tools.loaddump.schema.AbstractEvent;
import com.oceanbase.tools.loaddump.schema.AbstractFunction;
import com.oceanbase.tools.loaddump.schema.AbstractIndex;
import com.oceanbase.tools.loaddump.schema.AbstractObjUser;
import com.oceanbase.tools.loaddump.schema.AbstractPackage;
import com.oceanbase.tools.loaddump.schema.AbstractPackageBody;
import com.oceanbase.tools.loaddump.schema.AbstractProcedure;
import com.oceanbase.tools.loaddump.schema.AbstractRole;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.AbstractSequence;
import com.oceanbase.tools.loaddump.schema.AbstractSynonym;
import com.oceanbase.tools.loaddump.schema.AbstractTable;
import com.oceanbase.tools.loaddump.schema.AbstractTableGroup;
import com.oceanbase.tools.loaddump.schema.AbstractTablePartition;
import com.oceanbase.tools.loaddump.schema.AbstractTablespace;
import com.oceanbase.tools.loaddump.schema.AbstractTrigger;
import com.oceanbase.tools.loaddump.schema.AbstractType;
import com.oceanbase.tools.loaddump.schema.AbstractTypeBody;
import com.oceanbase.tools.loaddump.schema.AbstractView;
import com.oceanbase.tools.loaddump.schema.ObjectRelationGraph;
import com.oceanbase.tools.loaddump.schema.accessor.MetadataAccessor;
import com.oceanbase.tools.loaddump.schema.xml.SqlMapper;
import com.oceanbase.tools.loaddump.schema.xml.XmlParser;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetadataAccessor
implements MetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractMetadataAccessor.class);
    private static final String FILTER_STRING = "#filter#";
    protected final Global global;
    protected final DbType dbType;
    protected final String schemaName;
    protected final Configure configure;
    protected final SessionManager sessionManager;
    protected final JdbcTemplate jdbcTemplate;
    private final Set<String> includeObjectTypes;
    private final boolean ignoreCycleReference;
    private final boolean ignoreCheckReference;
    protected SqlMapper sqlMapper;

    public AbstractMetadataAccessor(Configure configure) {
        this.configure = configure;
        this.global = configure.getGlobal();
        this.dbType = configure.getDbType();
        this.schemaName = configure.getSchemaName();
        this.includeObjectTypes = configure.getIncludeObjectTypes();
        this.ignoreCycleReference = configure.isIgnoreCycleReference();
        this.ignoreCheckReference = configure.isIgnoreCheckReference();
        this.sessionManager = configure.getSessionManager();
        this.jdbcTemplate = new JdbcTemplate(configure.getSessionManager());
    }

    public AbstractSchema querySchema() throws Exception {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractTablespace> queryTablespaceMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractTableGroup> queryTableGroupMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Collection<? extends AbstractDependency> queryDependencies(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractTable> queryTableMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractColumn> queryColumnMapping(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public AbstractTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public AbstractConstraint queryPrimaryKey(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractConstraint> queryForeignMapping(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractConstraint> queryUniqueMapping(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractFunction> queryFunctionMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractProcedure> queryProcedureMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractTrigger> queryTriggerMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractView> queryViewMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractSequence> querySequenceMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractSynonym> querySynonymMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractDatabaseLink> queryDbLinkMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractEvent> queryEventMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractType> queryTypeMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractTypeBody> queryTypeBodyMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractPackage> queryPackageMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractObjUser> queryObjUserMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractRole> queryRoleMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractPackageBody> queryPackageBodyMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public MetadataAccessor init() {
        CharSequence[] xmlFiles = this.listXmlFiles();
        String message = String.join((CharSequence)", ", xmlFiles);
        try {
            this.sqlMapper = new XmlParser((String[])xmlFiles).parse();
            log.debug("Load {} successed", (Object)message);
        }
        catch (Exception e) {
            throw new IllegalStateException("Load " + message + " failed", e);
        }
        return this;
    }

    private String[] listXmlFiles() {
        String[] res = new String[]{};
        DbType dbType = this.getDbType();
        if (dbType == null) {
            throw new IllegalArgumentException("Invoke listXmlFiles failed. DbType is null");
        }
        if (DbType.OBMYSQL_14.getType().equals(dbType.getType())) {
            if (!dbType.isPrior(DbType.OBMYSQL_4100)) {
                if (log.isDebugEnabled()) {
                    log.debug("ObMySql({}) is older than 4.1.0.0 ? false", (Object)dbType.getRealVersion());
                }
                return new String[]{"meta/obmysql/obmysql14x.xml", "meta/obmysql/obmysql22x.xml", "meta/obmysql/obmysql2271.xml", "meta/obmysql/obmysql3230.xml", "meta/obmysql/obmysql40x.xml", "meta/obmysql/obmysql41x.xml"};
            }
            if (!dbType.isPrior(DbType.OBMYSQL_40)) {
                if (log.isDebugEnabled()) {
                    log.debug("ObMySql({}) is older than 4.0.0.0 ? false", (Object)dbType.getRealVersion());
                }
                return new String[]{"meta/obmysql/obmysql14x.xml", "meta/obmysql/obmysql22x.xml", "meta/obmysql/obmysql2271.xml", "meta/obmysql/obmysql3230.xml", "meta/obmysql/obmysql40x.xml"};
            }
            if (!dbType.isPrior(DbType.OBMYSQL_323)) {
                if (log.isDebugEnabled()) {
                    log.debug("ObMySql({}) is older than 3.2.3 ? false", (Object)dbType.getRealVersion());
                }
                return new String[]{"meta/obmysql/obmysql14x.xml", "meta/obmysql/obmysql22x.xml", "meta/obmysql/obmysql2271.xml", "meta/obmysql/obmysql3230.xml"};
            }
            if (!dbType.isPrior(DbType.OBMYSQL_2271)) {
                if (log.isDebugEnabled()) {
                    log.debug("ObMySql({}) is older than 2.2.71 ? false", (Object)dbType.getRealVersion());
                }
                return new String[]{"meta/obmysql/obmysql14x.xml", "meta/obmysql/obmysql22x.xml", "meta/obmysql/obmysql2271.xml"};
            }
            if (!dbType.isPrior(DbType.OBMYSQL_22)) {
                if (log.isDebugEnabled()) {
                    log.debug("ObMySql({}) is older than 2.2.x ? false", (Object)dbType.getRealVersion());
                }
                return new String[]{"meta/obmysql/obmysql14x.xml", "meta/obmysql/obmysql22x.xml"};
            }
            if (!dbType.isPrior(DbType.OBMYSQL_21)) {
                if (log.isDebugEnabled()) {
                    log.debug("ObMySql({}) is older than 2.1.x ? false", (Object)dbType.getRealVersion());
                }
                return new String[]{"meta/obmysql/obmysql14x.xml", "meta/obmysql/obmysql21x.xml"};
            }
            if (log.isDebugEnabled()) {
                log.debug("ObMySql({}) is older than 2.1.x ? true", (Object)dbType.getRealVersion());
            }
            return new String[]{"meta/obmysql/obmysql14x.xml"};
        }
        if (DbType.OBORACLE_22.getType().equals(dbType.getType())) {
            if (DbType.OBORACLE_22.isSubsequent(dbType)) {
                if (log.isDebugEnabled()) {
                    log.debug("ObOracle({}) is older than 2.2.0 ? true", (Object)dbType.getRealVersion());
                }
                return new String[]{"meta/oboracle/oboracle21x.xml"};
            }
            if (DbType.OBORACLE_2230.isSubsequent(dbType)) {
                if (log.isDebugEnabled()) {
                    log.debug("ObOracle({}) is older than 2.2.30 ? true", (Object)dbType.getRealVersion());
                }
                return new String[]{"meta/oboracle/oboracle22x.xml", "meta/oboracle/oboracle2220.xml"};
            }
            if (DbType.OBORACLE_2250.isSubsequentFrom(dbType)) {
                if (log.isDebugEnabled()) {
                    log.debug("ObOracle({}) is older than 2.2.50 ? true", (Object)dbType.getRealVersion());
                }
                return new String[]{"meta/oboracle/oboracle22x.xml", "meta/oboracle/oboracle2220.xml", "meta/oboracle/oboracle2230.xml"};
            }
            if (DbType.OBORACLE_40.isSubsequent(dbType)) {
                if (log.isDebugEnabled()) {
                    log.debug("ObOracle({}) is older than 4.0 ? true", (Object)dbType.getRealVersion());
                }
                return new String[]{"meta/oboracle/oboracle22x.xml"};
            }
            if (log.isDebugEnabled()) {
                log.debug("ObOracle({}) is older than 4.0.0.0 ? false", (Object)dbType.getRealVersion());
            }
            return new String[]{"meta/oboracle/oboracle22x.xml", "meta/oboracle/oboracle40x.xml"};
        }
        return res;
    }

    protected String bindings(ObjectType objectType, String sql) {
        if (sql.contains(FILTER_STRING)) {
            return sql.replace(FILTER_STRING, this.getConfigure().getFilterString(objectType));
        }
        return sql;
    }

    protected boolean isChecked(ObjectType objectType) {
        return objectType != null && this.getIncludeObjectTypes().contains(objectType.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkReference(AbstractDatabase database) {
        block6: {
            List<? extends AbstractDependency> dependencies = database.acquireDependencies();
            ObjectRelationGraph graph = new ObjectRelationGraph(dependencies.size());
            try {
                for (AbstractDependency abstractDependency : dependencies) {
                    String refObjType;
                    graph.add(abstractDependency.buildPredecessor(), abstractDependency.buildSuccessor());
                    String objType = abstractDependency.getObjType();
                    if (!this.isChecked(ObjectType.valueOfName(objType)) || this.isChecked(ObjectType.valueOfName(refObjType = abstractDependency.getRefObjType()))) continue;
                    String message = "The [" + refObjType + "] " + abstractDependency.getRefObjOwner() + "." + abstractDependency.getRefObjName() + " is referenced by the [" + objType + "] " + this.getSchemaName() + "." + abstractDependency.getObjName() + ", but the reference object type: " + refObjType + " is not included.";
                    if (this.isIgnoreCheckReference()) {
                        log.warn(message);
                        continue;
                    }
                    throw new IncompleteMetadataException(message);
                }
                if (!graph.hasCycle()) break block6;
                String message = "Found cycle reference: " + graph.findCyclePath();
                if (this.isIgnoreCycleReference()) {
                    log.warn(message);
                    break block6;
                }
                throw new CyclicReferenceException(message);
            }
            finally {
                graph = null;
            }
        }
    }

    public Global getGlobal() {
        return this.global;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Configure getConfigure() {
        return this.configure;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Set<String> getIncludeObjectTypes() {
        return this.includeObjectTypes;
    }

    public boolean isIgnoreCycleReference() {
        return this.ignoreCycleReference;
    }

    public boolean isIgnoreCheckReference() {
        return this.ignoreCheckReference;
    }

    public SqlMapper getSqlMapper() {
        return this.sqlMapper;
    }
}

