/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.accessor;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedProductException;
import com.oceanbase.tools.loaddump.configure.Configure;
import com.oceanbase.tools.loaddump.configure.Global;
import com.oceanbase.tools.loaddump.schema.AbstractDatabase;
import com.oceanbase.tools.loaddump.schema.accessor.MetadataAccessor;
import com.oceanbase.tools.loaddump.schema.accessor.ObMySqlMetadataAccessor;
import com.oceanbase.tools.loaddump.schema.accessor.ObOracleMetadataAccessor;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlDatabase;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleDatabase;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;

public final class MetadataAccessorFactory {
    public static MetadataAccessor get(Configure configure) {
        Preconditions.checkArgument((configure != null ? 1 : 0) != 0, (Object)"The configure is null");
        DbType dbType = configure.getDbType();
        if (DbType.OBMYSQL_14.getType().equalsIgnoreCase(dbType.getType())) {
            return new ObMySqlMetadataAccessor(configure).init();
        }
        if (DbType.OBORACLE_22.getType().equalsIgnoreCase(dbType.getType())) {
            return new ObOracleMetadataAccessor(configure).init();
        }
        throw new UnsupportedProductException("Invoke MetadataAccessorFactory.get(Configure configure) failed. The product: " + dbType + " is unsupported");
    }

    public static AbstractDatabase emptyDatabase(Configure configure) {
        Preconditions.checkArgument((configure != null ? 1 : 0) != 0, (Object)"The configure is null");
        Global global = configure.getGlobal();
        DbType dbType = configure.getDbType();
        String schemaName = configure.getSchemaName();
        Preconditions.checkArgument((dbType != null ? 1 : 0) != 0, (Object)"The DbType is null");
        if (DbType.OBMYSQL_14.getType().equals(dbType.getType())) {
            return new ObMySqlDatabase(new ObMySqlSchema(global, dbType, schemaName));
        }
        if (DbType.OBORACLE_22.getType().equals(dbType.getType())) {
            return new ObOracleDatabase(new ObOracleSchema(global, dbType, schemaName));
        }
        throw new UnsupportedProductException("Invoke MetadataAccessorFactory.emptyDatabase failed. The product: " + dbType + " is unsupported");
    }
}

