/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.converter;

import com.google.common.base.Preconditions;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.converter.AntlrDDLConverter;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.AntlrGrammarException;
import com.oceanbase.obtools.dbdiff.exception.ConvertFailException;
import java.util.List;

public class MysqlObjectConverter {
    private final AntlrDDLConverter converter;

    public MysqlObjectConverter(DbType src, DbType dest) {
        Configure srcConfigure = new Configure(Global.newInstance(), src, "srcSchema");
        Configure dstConfigure = new Configure(Global.newInstance(), dest, "dstSchema");
        this.converter = new AntlrDDLConverter(srcConfigure, dstConfigure);
    }

    public String convert(String ddl, ObjectType objectType) throws AntlrGrammarException, ConvertFailException {
        List objectDefines = this.converter.convert(ddl, objectType);
        Preconditions.checkState((objectDefines != null && objectDefines.size() == 1 ? 1 : 0) != 0, (Object)"Get null or empty result from ddl converter.");
        return ((ObjectDefine)objectDefines.get(0)).getObjectGrammar();
    }
}

