/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.model;

import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ObjectDefine {
    private final String objectType;
    private final String objectName;
    private final String objectGrammar;
    private final List<ObjectDefine> subObjectDefines = new ArrayList<ObjectDefine>();
    private String groupId = UUID.randomUUID().toString();
    private int sequenceId = 0;
    private boolean success = true;

    protected ObjectDefine(ObjectType objectType, String objectName, String objectGrammar) {
        this(objectType, objectName, objectGrammar, new ArrayList<ObjectDefine>(), true);
    }

    protected ObjectDefine(ObjectType objectType, String objectName, String objectGrammar, boolean success) {
        this(objectType, objectName, objectGrammar, new ArrayList<ObjectDefine>(), success);
    }

    protected ObjectDefine(ObjectType objectType, String objectName, String objectGrammar, List<ObjectDefine> subObjectDefines, boolean success) {
        this.objectType = objectType.getName();
        this.objectName = objectName;
        this.objectGrammar = objectGrammar;
        this.success = success;
        CollectionUtils.addAllIgnoreNull(this.getSubObjectDefines(), subObjectDefines);
    }

    public String getCoordinate() {
        return "[" + this.getObjectType() + "]" + this.getObjectName();
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectGrammar() {
        return this.objectGrammar;
    }

    public List<ObjectDefine> getSubObjectDefines() {
        return this.subObjectDefines;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}

