/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractConstraint;
import com.oceanbase.tools.loaddump.schema.base.KeyColumn;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlColumn;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractObMySqlConstraint
extends AbstractConstraint {
    private final Map<String, String> indexTypeMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = -1637246424096953846L;
        {
            this.put("HASH", " USING HASH");
            this.put("BTREE", " USING BTREE");
        }
    };
    private String constraintCatalog;
    private String nonunique;
    private String indexSchema;
    private String indexName;
    private String collation;
    private String cardinality;
    @Deprecated
    private String subPart;
    private String packed;
    private String nullable;
    private String indexType;
    private String comment;
    private String indexComment;
    private String positionInUniqueConstraint;
    private String matchOption;
    private String uniqueConstraintCatalog;
    private Map<String, ? extends ObMySqlColumn> columnMapping;

    public AbstractObMySqlConstraint(ObMySqlSchema schema) {
        super(schema);
    }

    @Override
    public ObMySqlSchema getSchema() {
        return (ObMySqlSchema)super.getSchema();
    }

    public void setSchema(ObMySqlSchema schema) {
        super.setSchema(schema);
    }

    protected void checkConstraintOnGeneratedColumns() throws UnsupportedGrammarException {
        for (KeyColumn keyCol : this.getConstraintColumns()) {
            String extra;
            ObMySqlColumn column = this.getColumnMapping().get(keyCol.getColumnName());
            if (column == null || StringUtils.isBlank(column.getExtra()) || (extra = column.getExtra()).contains("DEFAULT_GENERATED") || !extra.contains("GENERATED")) continue;
            throw new UnsupportedGrammarException(this.getSchemaObjectName(), "The primary key is unsupported for generated columns");
        }
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    @Override
    public String toString() {
        return "AbstractObMySqlConstraint(indexTypeMapping=" + this.getIndexTypeMapping() + ", constraintCatalog=" + this.getConstraintCatalog() + ", nonunique=" + this.getNonunique() + ", indexSchema=" + this.getIndexSchema() + ", indexName=" + this.getIndexName() + ", collation=" + this.getCollation() + ", cardinality=" + this.getCardinality() + ", subPart=" + this.getSubPart() + ", packed=" + this.getPacked() + ", nullable=" + this.getNullable() + ", indexType=" + this.getIndexType() + ", comment=" + this.getComment() + ", indexComment=" + this.getIndexComment() + ", positionInUniqueConstraint=" + this.getPositionInUniqueConstraint() + ", matchOption=" + this.getMatchOption() + ", uniqueConstraintCatalog=" + this.getUniqueConstraintCatalog() + ", columnMapping=" + this.getColumnMapping() + ")";
    }

    public AbstractObMySqlConstraint() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractObMySqlConstraint)) {
            return false;
        }
        AbstractObMySqlConstraint other = (AbstractObMySqlConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$indexTypeMapping = this.getIndexTypeMapping();
        Map<String, String> other$indexTypeMapping = other.getIndexTypeMapping();
        if (this$indexTypeMapping == null ? other$indexTypeMapping != null : !((Object)this$indexTypeMapping).equals(other$indexTypeMapping)) {
            return false;
        }
        String this$constraintCatalog = this.getConstraintCatalog();
        String other$constraintCatalog = other.getConstraintCatalog();
        if (this$constraintCatalog == null ? other$constraintCatalog != null : !this$constraintCatalog.equals(other$constraintCatalog)) {
            return false;
        }
        String this$nonunique = this.getNonunique();
        String other$nonunique = other.getNonunique();
        if (this$nonunique == null ? other$nonunique != null : !this$nonunique.equals(other$nonunique)) {
            return false;
        }
        String this$indexSchema = this.getIndexSchema();
        String other$indexSchema = other.getIndexSchema();
        if (this$indexSchema == null ? other$indexSchema != null : !this$indexSchema.equals(other$indexSchema)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$collation = this.getCollation();
        String other$collation = other.getCollation();
        if (this$collation == null ? other$collation != null : !this$collation.equals(other$collation)) {
            return false;
        }
        String this$cardinality = this.getCardinality();
        String other$cardinality = other.getCardinality();
        if (this$cardinality == null ? other$cardinality != null : !this$cardinality.equals(other$cardinality)) {
            return false;
        }
        String this$subPart = this.getSubPart();
        String other$subPart = other.getSubPart();
        if (this$subPart == null ? other$subPart != null : !this$subPart.equals(other$subPart)) {
            return false;
        }
        String this$packed = this.getPacked();
        String other$packed = other.getPacked();
        if (this$packed == null ? other$packed != null : !this$packed.equals(other$packed)) {
            return false;
        }
        String this$nullable = this.getNullable();
        String other$nullable = other.getNullable();
        if (this$nullable == null ? other$nullable != null : !this$nullable.equals(other$nullable)) {
            return false;
        }
        String this$indexType = this.getIndexType();
        String other$indexType = other.getIndexType();
        if (this$indexType == null ? other$indexType != null : !this$indexType.equals(other$indexType)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$indexComment = this.getIndexComment();
        String other$indexComment = other.getIndexComment();
        if (this$indexComment == null ? other$indexComment != null : !this$indexComment.equals(other$indexComment)) {
            return false;
        }
        String this$positionInUniqueConstraint = this.getPositionInUniqueConstraint();
        String other$positionInUniqueConstraint = other.getPositionInUniqueConstraint();
        if (this$positionInUniqueConstraint == null ? other$positionInUniqueConstraint != null : !this$positionInUniqueConstraint.equals(other$positionInUniqueConstraint)) {
            return false;
        }
        String this$matchOption = this.getMatchOption();
        String other$matchOption = other.getMatchOption();
        if (this$matchOption == null ? other$matchOption != null : !this$matchOption.equals(other$matchOption)) {
            return false;
        }
        String this$uniqueConstraintCatalog = this.getUniqueConstraintCatalog();
        String other$uniqueConstraintCatalog = other.getUniqueConstraintCatalog();
        if (this$uniqueConstraintCatalog == null ? other$uniqueConstraintCatalog != null : !this$uniqueConstraintCatalog.equals(other$uniqueConstraintCatalog)) {
            return false;
        }
        Map<String, ? extends ObMySqlColumn> this$columnMapping = this.getColumnMapping();
        Map<String, ? extends ObMySqlColumn> other$columnMapping = other.getColumnMapping();
        return !(this$columnMapping == null ? other$columnMapping != null : !((Object)this$columnMapping).equals(other$columnMapping));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractObMySqlConstraint;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $indexTypeMapping = this.getIndexTypeMapping();
        result = result * 59 + ($indexTypeMapping == null ? 43 : ((Object)$indexTypeMapping).hashCode());
        String $constraintCatalog = this.getConstraintCatalog();
        result = result * 59 + ($constraintCatalog == null ? 43 : $constraintCatalog.hashCode());
        String $nonunique = this.getNonunique();
        result = result * 59 + ($nonunique == null ? 43 : $nonunique.hashCode());
        String $indexSchema = this.getIndexSchema();
        result = result * 59 + ($indexSchema == null ? 43 : $indexSchema.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $collation = this.getCollation();
        result = result * 59 + ($collation == null ? 43 : $collation.hashCode());
        String $cardinality = this.getCardinality();
        result = result * 59 + ($cardinality == null ? 43 : $cardinality.hashCode());
        String $subPart = this.getSubPart();
        result = result * 59 + ($subPart == null ? 43 : $subPart.hashCode());
        String $packed = this.getPacked();
        result = result * 59 + ($packed == null ? 43 : $packed.hashCode());
        String $nullable = this.getNullable();
        result = result * 59 + ($nullable == null ? 43 : $nullable.hashCode());
        String $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : $indexType.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $indexComment = this.getIndexComment();
        result = result * 59 + ($indexComment == null ? 43 : $indexComment.hashCode());
        String $positionInUniqueConstraint = this.getPositionInUniqueConstraint();
        result = result * 59 + ($positionInUniqueConstraint == null ? 43 : $positionInUniqueConstraint.hashCode());
        String $matchOption = this.getMatchOption();
        result = result * 59 + ($matchOption == null ? 43 : $matchOption.hashCode());
        String $uniqueConstraintCatalog = this.getUniqueConstraintCatalog();
        result = result * 59 + ($uniqueConstraintCatalog == null ? 43 : $uniqueConstraintCatalog.hashCode());
        Map<String, ? extends ObMySqlColumn> $columnMapping = this.getColumnMapping();
        result = result * 59 + ($columnMapping == null ? 43 : ((Object)$columnMapping).hashCode());
        return result;
    }

    public Map<String, String> getIndexTypeMapping() {
        return this.indexTypeMapping;
    }

    public String getConstraintCatalog() {
        return this.constraintCatalog;
    }

    public void setConstraintCatalog(String constraintCatalog) {
        this.constraintCatalog = constraintCatalog;
    }

    public String getNonunique() {
        return this.nonunique;
    }

    public void setNonunique(String nonunique) {
        this.nonunique = nonunique;
    }

    public String getIndexSchema() {
        return this.indexSchema;
    }

    public void setIndexSchema(String indexSchema) {
        this.indexSchema = indexSchema;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    @Deprecated
    public String getSubPart() {
        return this.subPart;
    }

    @Deprecated
    public void setSubPart(String subPart) {
        this.subPart = subPart;
    }

    public String getPacked() {
        return this.packed;
    }

    public void setPacked(String packed) {
        this.packed = packed;
    }

    public String getNullable() {
        return this.nullable;
    }

    public void setNullable(String nullable) {
        this.nullable = nullable;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getIndexComment() {
        return this.indexComment;
    }

    public void setIndexComment(String indexComment) {
        this.indexComment = indexComment;
    }

    public String getPositionInUniqueConstraint() {
        return this.positionInUniqueConstraint;
    }

    public void setPositionInUniqueConstraint(String positionInUniqueConstraint) {
        this.positionInUniqueConstraint = positionInUniqueConstraint;
    }

    public String getMatchOption() {
        return this.matchOption;
    }

    public void setMatchOption(String matchOption) {
        this.matchOption = matchOption;
    }

    public String getUniqueConstraintCatalog() {
        return this.uniqueConstraintCatalog;
    }

    public void setUniqueConstraintCatalog(String uniqueConstraintCatalog) {
        this.uniqueConstraintCatalog = uniqueConstraintCatalog;
    }

    public Map<String, ? extends ObMySqlColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public void setColumnMapping(Map<String, ? extends ObMySqlColumn> columnMapping) {
        this.columnMapping = columnMapping;
    }
}

