/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.obmysql.AbstractObMySqlConstraint;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import org.apache.commons.lang3.StringUtils;

public class ObMySqlCheck
extends AbstractObMySqlConstraint {
    private String checkClause;

    public ObMySqlCheck(ObMySqlSchema schema) {
        super(schema);
    }

    @Override
    public ObMySqlSchema getSchema() {
        return super.getSchema();
    }

    @Override
    public void setSchema(ObMySqlSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (DbType.OBMYSQL_323.isSubsequent(this.getDbType())) {
            sb.append("check ").append(this.getCheckClause()).append(" is unsupported until OBMYSQL v3.2.3.0");
            throw new UnsupportedGrammarException(this.getSchemaObjectName(), sb.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getConstraintName())) {
            sb.append("constraint ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        return sb.append("check ").append(this.getCheckClause());
    }

    @Override
    public String toString() {
        return "ObMySqlCheck(checkClause=" + this.getCheckClause() + ")";
    }

    public ObMySqlCheck() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObMySqlCheck)) {
            return false;
        }
        ObMySqlCheck other = (ObMySqlCheck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$checkClause = this.getCheckClause();
        String other$checkClause = other.getCheckClause();
        return !(this$checkClause == null ? other$checkClause != null : !this$checkClause.equals(other$checkClause));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObMySqlCheck;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $checkClause = this.getCheckClause();
        result = result * 59 + ($checkClause == null ? 43 : $checkClause.hashCode());
        return result;
    }

    public String getCheckClause() {
        return this.checkClause;
    }

    public void setCheckClause(String checkClause) {
        this.checkClause = checkClause;
    }
}

