/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractFunction;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlRoutine;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.List;
import java.util.stream.Collectors;

public class ObMySqlFunction
extends AbstractFunction {
    private ObMySqlRoutine routine;

    public ObMySqlFunction(AbstractSchema schema, ObMySqlRoutine routine) {
        super(schema);
        this.routine = routine;
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CREATE ");
        if (StringUtils.isNotBlank(this.routine.getDefiner()) && JavaOpts.enableDefiner.booleanValue()) {
            sb.append("DEFINER=").append(this.routine.getDefiner()).append(" ");
        }
        sb.append("FUNCTION ").append(this.wrap(this.routine.getRoutineName()));
        sb.append(" (").append(this.buildParamList()).append(")");
        sb.append("\nRETURNS ").append(this.routine.getDtdIdentifier());
        sb.append("\nSQL SECURITY ").append(this.routine.getSecurityType());
        sb.append("YES".equals(this.routine.getIsDeterministic()) ? "\nDETERMINISTIC" : "").append(StringUtils.isNotBlank(this.routine.getComment()) ? "\nCOMMENT '" + this.routine.getComment() + "'" : "");
        sb.append("\n").append(this.routine.getRoutineDefinition());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.FUNCTION, this.getSimpleObjectName(), this.terminate(sb))});
    }

    private String buildParamList() {
        return this.getRoutine().getParameters().stream().map(e -> this.wrap(e.getParameterName()) + " " + e.getDtdIdentifier()).collect(Collectors.joining(", "));
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    public ObMySqlFunction() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObMySqlFunction)) {
            return false;
        }
        ObMySqlFunction other = (ObMySqlFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObMySqlRoutine this$routine = this.getRoutine();
        ObMySqlRoutine other$routine = other.getRoutine();
        return !(this$routine == null ? other$routine != null : !((Object)this$routine).equals(other$routine));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObMySqlFunction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ObMySqlRoutine $routine = this.getRoutine();
        result = result * 59 + ($routine == null ? 43 : ((Object)$routine).hashCode());
        return result;
    }

    public ObMySqlRoutine getRoutine() {
        return this.routine;
    }
}

