/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractObjUser;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ObMySqlObjUser
extends AbstractObjUser {
    private String host;

    public ObMySqlObjUser(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String wapName = "`" + this.getName() + "`";
        sb.append("create user ").append(wapName);
        if (!this.getHost().equals("%")) {
            sb.append("@" + this.host);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPassword())) {
            sb.append(" identified by '").append(this.getPassword()).append("'");
        }
        sb.append(";");
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        if (this.getPrivileges().size() > 0) {
            sb.append("\n");
            for (String privilege : this.getPrivileges()) {
                CreateObjectDefine subDefine = new CreateObjectDefine(ObjectType.PRIVILEGE, this.getObjectName(), this.terminate(privilege));
                subDefines.add(subDefine);
            }
        }
        CreateObjectDefine objectDefine = new CreateObjectDefine(ObjectType.OBJ_USER, this.getObjectName(), sb.toString(), subDefines);
        return Lists.newArrayList((Object[])new ObjectDefine[]{objectDefine});
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

