/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.oboracle.AbstractObOracleConstraint;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class ObOracleCheck
extends AbstractObOracleConstraint {
    private boolean complete = false;

    public ObOracleCheck(ObOracleSchema schema) {
        super(schema);
    }

    @Override
    public ObOracleSchema getSchema() {
        return (ObOracleSchema)super.getSchema();
    }

    public void setSchema(ObOracleSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String searchCondition = this.getSearchCondition();
        if (StringUtils.isBlank(searchCondition)) {
            return sb;
        }
        if (this.isComplete()) {
            return sb.append(searchCondition);
        }
        if (StringUtils.isNotBlank(this.getConstraintName()) && this.isUserGenerated()) {
            sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        if ((searchCondition = searchCondition.trim()).startsWith("(") && searchCondition.endsWith(")")) {
            sb.append("CHECK ").append(searchCondition);
        } else {
            sb.append("CHECK (").append(searchCondition).append(")");
        }
        String status = this.getStatus();
        String validated = this.getValidated();
        sb.append(this.safetyMapping(OPTION_MAPPING, status));
        return sb.append(this.safetyMapping(OPTION_MAPPING, validated));
    }

    @Override
    public String toString() {
        return "ObOracleCheck(complete=" + this.isComplete() + ")";
    }

    public ObOracleCheck() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleCheck)) {
            return false;
        }
        ObOracleCheck other = (ObOracleCheck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isComplete() == other.isComplete();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObOracleCheck;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isComplete() ? 79 : 97);
        return result;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }
}

