/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.oceanbase.tools.loaddump.schema.AbstractSequence;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import java.math.BigDecimal;

public class ObOracleSequence
extends AbstractSequence {
    private static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999999999999999999");

    public ObOracleSequence(ObOracleSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildSequenceGrammar() {
        BigDecimal min;
        StringBuilder sb = new StringBuilder(32);
        BigDecimal start = this.getStart();
        BigDecimal nextValue = this.getNextValue();
        if ("preserve".equalsIgnoreCase(this.getMode())) {
            if (nextValue == null) {
                throw new IllegalStateException("Failed to get next value of the sequence, may use --restart policy to work around");
            }
            sb.append(" START WITH ").append(nextValue);
        } else if (start != null) {
            sb.append(" START WITH ").append(start);
        }
        BigDecimal increment = this.getIncrement();
        if (increment != null) {
            sb.append(" INCREMENT BY ").append(increment);
        }
        if ((min = this.getMinValue()) != null) {
            sb.append(" MINVALUE ").append(min);
        } else {
            sb.append(" NOMINVALUE");
        }
        BigDecimal max = this.getMaxValue();
        if (max != null) {
            sb.append(" MAXVALUE ").append(max);
            String cycle = this.getCycle();
            if ("Y".equals(cycle) || "YES".equals(cycle)) {
                sb.append(" CYCLE");
            } else {
                sb.append(" NOCYCLE");
            }
        } else {
            sb.append(" NOMAXVALUE");
        }
        BigDecimal cache = this.getCache();
        if (cache != null && cache.compareTo(BigDecimal.ONE) > 0) {
            sb.append(" CACHE ").append(cache);
        } else {
            sb.append(" NOCACHE");
        }
        String order = this.getOrder();
        if ("Y".equals(order) || "YES".equals(order)) {
            sb.append(" ORDER");
        } else {
            sb.append(" NOORDER");
        }
        return sb;
    }

    @Override
    public StringBuilder buildIdentityGrammar() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(" AS IDENTITY (");
        sb.append(this.buildSequenceGrammar().toString().trim());
        return sb.append(")");
    }

    public ObOracleSequence() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleSequence)) {
            return false;
        }
        ObOracleSequence other = (ObOracleSequence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObOracleSequence;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

