/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractSynonym;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.List;

public class ObOracleSynonym
extends AbstractSynonym {
    protected static final String DISTINCT_SUFFIX = "__used_for_distinct_public";
    private String owner;
    private String dbLink;

    public ObOracleSynonym(ObOracleSchema schema) {
        super(schema);
    }

    @Override
    public ObOracleSchema getSchema() {
        return (ObOracleSchema)super.getSchema();
    }

    public void setSchema(ObOracleSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        boolean isPublicSynonym;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE");
        boolean bl = isPublicSynonym = "PUBLIC".equalsIgnoreCase(this.getOwner()) || "__public".equalsIgnoreCase(this.getOwner());
        if (isPublicSynonym) {
            sb.append(" PUBLIC");
        }
        sb.append(" SYNONYM ");
        boolean isWithSchema = super.getGlobal().withSchema();
        String objectName = this.getObjectName();
        if (objectName.endsWith(DISTINCT_SUFFIX)) {
            objectName = objectName.substring(0, objectName.length() - DISTINCT_SUFFIX.length());
        }
        boolean isTheSameName = StringUtils.equals(objectName, this.getTableName());
        if (!isPublicSynonym && (isWithSchema || isTheSameName)) {
            sb.append(this.wrap(this.getOwner())).append(".");
        }
        sb.append(this.wrap(objectName)).append(" FOR ");
        if (StringUtils.isNotBlank(this.getTableOwner()) && (isWithSchema || isTheSameName)) {
            sb.append(this.wrap(this.getTableOwner())).append(".");
        }
        sb.append(this.wrap(this.getTableName()));
        if (StringUtils.isNotBlank(this.getDbLink())) {
            sb.append("@").append(this.wrap(this.getDbLink()));
        }
        if (isPublicSynonym) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.PUBLIC_SYNONYM, this.getSimpleObjectName(), this.terminate(sb))});
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.SYNONYM, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public String getSimpleObjectName() {
        String objectName;
        StringBuilder sb = new StringBuilder();
        if (this.getGlobal().withSchema()) {
            sb.append(this.getSchemaName()).append(".");
        }
        if ((objectName = this.getObjectName()).endsWith(DISTINCT_SUFFIX)) {
            objectName = objectName.substring(0, objectName.length() - DISTINCT_SUFFIX.length());
        }
        return sb.append(objectName).toString();
    }

    public ObOracleSynonym() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleSynonym)) {
            return false;
        }
        ObOracleSynonym other = (ObOracleSynonym)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$dbLink = this.getDbLink();
        String other$dbLink = other.getDbLink();
        return !(this$dbLink == null ? other$dbLink != null : !this$dbLink.equals(other$dbLink));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObOracleSynonym;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $dbLink = this.getDbLink();
        result = result * 59 + ($dbLink == null ? 43 : $dbLink.hashCode());
        return result;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getDbLink() {
        return this.dbLink;
    }

    public void setDbLink(String dbLink) {
        this.dbLink = dbLink;
    }
}

