/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractTable;
import com.oceanbase.tools.loaddump.schema.base.KeyColumn;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.oboracle.AbstractObOracleConstraint;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleCheck;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleColumn;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleForeignKey;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleIndex;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOraclePrimaryKey;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleTablePartition;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleUniqueKey;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;

public class ObOracleTable
extends AbstractTable {
    public static final ArrayList<String> DEFAULT_DELIM_TOKENS = new ArrayList();
    private final Map<String, String> compressMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 233704211950958872L;
        {
            this.put("BASIC", " COMPRESS BASIC");
            this.put("OLTP", " COMPRESS FOR OLTP");
            this.put("QUERY LOW", " COMPRESS FOR QUERY LOW");
            this.put("QUERY HIGH", " COMPRESS FOR QUERY HIGH");
            this.put("ARCHIVE LOW", " COMPRESS FOR ARCHIVE LOW");
            this.put("ARCHIVE HIGH", " COMPRESS FOR ARCHIVE HIGH");
        }
    };
    private final Map<String, ObOracleColumn> columnMapping = new LinkedHashMap<String, ObOracleColumn>();
    private final Map<String, ObOracleIndex> indexMapping = new LinkedHashMap<String, ObOracleIndex>();
    private final Map<String, ObOracleUniqueKey> uniqueMapping = new LinkedHashMap<String, ObOracleUniqueKey>();
    private final Map<String, ObOracleForeignKey> foreignMapping = new LinkedHashMap<String, ObOracleForeignKey>();
    private final Map<String, ObOracleCheck> checkMapping = new LinkedHashMap<String, ObOracleCheck>();
    private String tablespaceName;
    private String clusterName;
    private String iotName;
    private String status;
    private Integer pctFree;
    private Integer pctUsed;
    private Integer iniTrans;
    private Integer maxTrans;
    private Integer initialExtent;
    private Integer nextExtent;
    private Integer minExtents;
    private Integer maxExtents;
    private Integer pctIncrease;
    private Integer freeLists;
    private Integer freeListGroups;
    private String logging;
    private String backedUp;
    private String numRows;
    private String blocks;
    private String emptyBlocks;
    private String avgSpace;
    private String chainCnt;
    private String avgRowLen;
    private String avgSpaceFreeListBlocks;
    private String numFreeListBlocks;
    private String degree;
    private String instances;
    private String cache;
    private String tableLock;
    private String sampleSize;
    private String lastAnalyzed;
    private String partitioned;
    private String iotType;
    private String objectIdType;
    private String tableTypeOwner;
    private String objectTableType;
    private String temporary;
    private String secondary;
    private String nested;
    private String bufferPool;
    private String flashCache;
    private String cellFlashCache;
    private String rowMovement;
    private String globalStats;
    private String userStats;
    private String duration;
    private String skipCorrupt;
    private String monitoring;
    private String clusterOwner;
    private String dependencies;
    private String compression;
    private String compressFor;
    private String dropped;
    private String segmentCreated;
    private String storeTableName;
    private String nestedTableName;
    private String tableGroupName;
    private ObOraclePrimaryKey primaryKey;
    private ObOracleTablePartition tablePartition;

    public ObOracleTable(ObOracleSchema schema) {
        super(schema);
    }

    public static Collection<String> parseGenerateExpr(String expr, Set<String> columnSet) {
        if (StringUtils.isBlank(expr)) {
            return Sets.newLinkedHashSetWithExpectedSize((int)0);
        }
        if (CollectionUtils.isEmpty(columnSet)) {
            throw new IllegalArgumentException("The column set is null");
        }
        int length = expr.length();
        char[] src = expr.toCharArray();
        LinkedHashSet<String> physicalColumnNames = new LinkedHashSet<String>();
        for (String tableColumnName : columnSet) {
            int count = tableColumnName.length();
            int searchTimes = length - count + 1;
            for (int i = 0; i < searchTimes; ++i) {
                String search = String.copyValueOf(src, i, count);
                if (!tableColumnName.equals(search)) continue;
                int prevIdx = i - 1;
                int nextIdx = i + count;
                if (prevIdx > -1 && !DEFAULT_DELIM_TOKENS.contains(String.valueOf(src[prevIdx])) || nextIdx < length && !DEFAULT_DELIM_TOKENS.contains(String.valueOf(src[nextIdx]))) continue;
                physicalColumnNames.add(tableColumnName);
            }
        }
        return physicalColumnNames;
    }

    @Override
    public ObOracleSchema getSchema() {
        return (ObOracleSchema)super.getSchema();
    }

    public void setSchema(ObOracleSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder grammar;
        StringBuilder sb = new StringBuilder();
        String objectName = this.getSchemaObjectName();
        sb.append("CREATE ");
        if ("Y".equals(this.getTemporary())) {
            sb.append("GLOBAL TEMPORARY ");
        }
        sb.append("TABLE ").append(objectName).append(" (");
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        String tableComment = this.getTableComment();
        if (StringUtils.isNotBlank(tableComment)) {
            tableComment = String.format("COMMENT ON TABLE %s IS '%s'", objectName, tableComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, objectName, this.terminate(tableComment)));
        }
        Iterator<ObOracleColumn> iter = this.getColumnMapping().values().iterator();
        while (iter.hasNext()) {
            String colComment;
            ObOracleColumn col = iter.next();
            sb.append("\n\t").append((CharSequence)col.buildGrammar());
            if (iter.hasNext()) {
                sb.append(",");
            }
            if (!StringUtils.isNotBlank(colComment = col.getColumnComment())) continue;
            String wrappedName = col.getWrappedName();
            colComment = String.format("COMMENT ON COLUMN %s.%s IS '%s'", objectName, wrappedName, colComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, wrappedName, this.terminate(colComment)));
        }
        ObOraclePrimaryKey primaryKey = this.getPrimaryKey();
        ObOracleTablePartition partition = this.getTablePartition();
        Map<String, ObOracleUniqueKey> uniqueMapping = this.getUniqueMapping();
        if (primaryKey != null) {
            primaryKey.setUsingIndexMapping(this.getIndexMapping());
            Iterator<AbstractObOracleConstraint> grammar2 = primaryKey.buildGrammar();
            if (StringUtils.isNotBlank((CharSequence)((Object)grammar2))) {
                sb.append(",").append("\n\t").append((CharSequence)((Object)grammar2));
                this.setPrimaryKey(primaryKey);
            }
        }
        if (MapUtils.isNotEmpty(uniqueMapping)) {
            for (ObOracleUniqueKey uniqueKey : uniqueMapping.values()) {
                uniqueKey.setUsingIndexMapping(this.getIndexMapping());
                grammar = uniqueKey.buildGrammar();
                if (!StringUtils.isNotBlank(grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (ObOracleCheck check : this.getCheckMapping().values()) {
                grammar = check.buildGrammar();
                if (!StringUtils.isNotBlank(grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (ObOracleForeignKey foreignKey : this.getForeignMapping().values()) {
                grammar = foreignKey.buildGrammar();
                if (!StringUtils.isNotBlank(grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        sb.append("\n").append(")").append((CharSequence)this.appendTableOptions());
        if (partition != null) {
            sb.append((CharSequence)partition.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            Collection<ObOracleIndex> indexes = this.getIndexMapping().values();
            Iterator<ObOracleIndex> it = indexes.iterator();
            while (it.hasNext()) {
                ObOracleIndex index = it.next();
                if (this.isAlreadyIndexed(index)) {
                    it.remove();
                    continue;
                }
                subDefines.addAll(index.buildDefinition());
            }
        }
        CreateObjectDefine objectDefine = new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines);
        return Lists.newArrayList((Object[])new ObjectDefine[]{objectDefine});
    }

    private boolean isAlreadyIndexed(ObOracleIndex index) {
        if (index == null) {
            return false;
        }
        Collection<KeyColumn> indexColumns = index.getIndexColumns();
        if (this.getPrimaryKey() != null && this.isAlreadyIndexed(indexColumns, this.getPrimaryKey().getConstraintColumns())) {
            return true;
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (ObOracleUniqueKey uniqueKey : this.getUniqueMapping().values()) {
                if (!this.isAlreadyIndexed(indexColumns, uniqueKey.getConstraintColumns())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAlreadyIndexed(Collection<KeyColumn> indexColumns, Collection<KeyColumn> constColumns) {
        if (indexColumns.size() != constColumns.size()) {
            return false;
        }
        String indexCols = indexColumns.stream().map(e -> {
            String col = e.getColumnName();
            if (col.startsWith("`") && col.endsWith("`") || col.startsWith("\"") && col.endsWith("\"")) {
                col = col.substring(1, col.length() - 1);
            }
            return col;
        }).collect(Collectors.joining(","));
        return indexCols.equals(constColumns.stream().map(e -> e.getColumnName()).collect(Collectors.joining(",")));
    }

    private StringBuilder appendTableOptions() {
        String tableGroupName;
        String duration;
        String rowMovement;
        Integer maxTrans;
        Integer iniTrans;
        Integer pctUsed;
        StringBuilder sb = new StringBuilder();
        Integer pctFree = this.getPctFree();
        if (pctFree != null && pctFree > 0) {
            sb.append(" PCTFREE ").append(pctFree);
        }
        if ((pctUsed = this.getPctUsed()) != null && pctUsed > 0) {
            sb.append(" PCTUSED ").append(pctUsed);
        }
        if ((iniTrans = this.getIniTrans()) != null && iniTrans > 0) {
            sb.append(" INITRANS ").append(iniTrans);
        }
        if ((maxTrans = this.getMaxTrans()) != null && maxTrans > 0) {
            sb.append(" MAXTRANS ").append(maxTrans);
        }
        boolean isCompressed = "ENABLED".equals(this.getCompression());
        String compressFor = this.safetyMapping(this.getCompressMapping(), this.getCompressFor());
        if (isCompressed && StringUtils.isNotBlank(compressFor)) {
            sb.append(compressFor);
        }
        if ("ENABLE".equals(rowMovement = this.getRowMovement()) || "ENABLED".equals(rowMovement)) {
            sb.append(" ENABLE ROW MOVEMENT");
        }
        if ("SYS$TRANSACTION".equals(duration = this.getDuration())) {
            sb.append(" ON COMMIT DELETE ROWS");
        } else if ("SYS$SESSION".equals(duration)) {
            sb.append(" ON COMMIT PRESERVE ROWS");
        }
        String tablespaceName = this.getTablespaceName();
        if (StringUtils.isNotBlank(tablespaceName)) {
            sb.append(" TABLESPACE ").append(this.wrap(tablespaceName));
        }
        if (StringUtils.isNotBlank(tableGroupName = this.getTableGroupName())) {
            sb.append(" TABLEGROUP ").append(tableGroupName);
        }
        return sb;
    }

    @Override
    public String toString() {
        return "ObOracleTable(compressMapping=" + this.getCompressMapping() + ", columnMapping=" + this.getColumnMapping() + ", indexMapping=" + this.getIndexMapping() + ", uniqueMapping=" + this.getUniqueMapping() + ", foreignMapping=" + this.getForeignMapping() + ", checkMapping=" + this.getCheckMapping() + ", tablespaceName=" + this.getTablespaceName() + ", clusterName=" + this.getClusterName() + ", iotName=" + this.getIotName() + ", status=" + this.getStatus() + ", pctFree=" + this.getPctFree() + ", pctUsed=" + this.getPctUsed() + ", iniTrans=" + this.getIniTrans() + ", maxTrans=" + this.getMaxTrans() + ", initialExtent=" + this.getInitialExtent() + ", nextExtent=" + this.getNextExtent() + ", minExtents=" + this.getMinExtents() + ", maxExtents=" + this.getMaxExtents() + ", pctIncrease=" + this.getPctIncrease() + ", freeLists=" + this.getFreeLists() + ", freeListGroups=" + this.getFreeListGroups() + ", logging=" + this.getLogging() + ", backedUp=" + this.getBackedUp() + ", numRows=" + this.getNumRows() + ", blocks=" + this.getBlocks() + ", emptyBlocks=" + this.getEmptyBlocks() + ", avgSpace=" + this.getAvgSpace() + ", chainCnt=" + this.getChainCnt() + ", avgRowLen=" + this.getAvgRowLen() + ", avgSpaceFreeListBlocks=" + this.getAvgSpaceFreeListBlocks() + ", numFreeListBlocks=" + this.getNumFreeListBlocks() + ", degree=" + this.getDegree() + ", instances=" + this.getInstances() + ", cache=" + this.getCache() + ", tableLock=" + this.getTableLock() + ", sampleSize=" + this.getSampleSize() + ", lastAnalyzed=" + this.getLastAnalyzed() + ", partitioned=" + this.getPartitioned() + ", iotType=" + this.getIotType() + ", objectIdType=" + this.getObjectIdType() + ", tableTypeOwner=" + this.getTableTypeOwner() + ", objectTableType=" + this.getObjectTableType() + ", temporary=" + this.getTemporary() + ", secondary=" + this.getSecondary() + ", nested=" + this.getNested() + ", bufferPool=" + this.getBufferPool() + ", flashCache=" + this.getFlashCache() + ", cellFlashCache=" + this.getCellFlashCache() + ", rowMovement=" + this.getRowMovement() + ", globalStats=" + this.getGlobalStats() + ", userStats=" + this.getUserStats() + ", duration=" + this.getDuration() + ", skipCorrupt=" + this.getSkipCorrupt() + ", monitoring=" + this.getMonitoring() + ", clusterOwner=" + this.getClusterOwner() + ", dependencies=" + this.getDependencies() + ", compression=" + this.getCompression() + ", compressFor=" + this.getCompressFor() + ", dropped=" + this.getDropped() + ", segmentCreated=" + this.getSegmentCreated() + ", storeTableName=" + this.getStoreTableName() + ", nestedTableName=" + this.getNestedTableName() + ", tableGroupName=" + this.getTableGroupName() + ", primaryKey=" + this.getPrimaryKey() + ", tablePartition=" + this.getTablePartition() + ")";
    }

    public ObOracleTable() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleTable)) {
            return false;
        }
        ObOracleTable other = (ObOracleTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$pctFree = this.getPctFree();
        Integer other$pctFree = other.getPctFree();
        if (this$pctFree == null ? other$pctFree != null : !((Object)this$pctFree).equals(other$pctFree)) {
            return false;
        }
        Integer this$pctUsed = this.getPctUsed();
        Integer other$pctUsed = other.getPctUsed();
        if (this$pctUsed == null ? other$pctUsed != null : !((Object)this$pctUsed).equals(other$pctUsed)) {
            return false;
        }
        Integer this$iniTrans = this.getIniTrans();
        Integer other$iniTrans = other.getIniTrans();
        if (this$iniTrans == null ? other$iniTrans != null : !((Object)this$iniTrans).equals(other$iniTrans)) {
            return false;
        }
        Integer this$maxTrans = this.getMaxTrans();
        Integer other$maxTrans = other.getMaxTrans();
        if (this$maxTrans == null ? other$maxTrans != null : !((Object)this$maxTrans).equals(other$maxTrans)) {
            return false;
        }
        Integer this$initialExtent = this.getInitialExtent();
        Integer other$initialExtent = other.getInitialExtent();
        if (this$initialExtent == null ? other$initialExtent != null : !((Object)this$initialExtent).equals(other$initialExtent)) {
            return false;
        }
        Integer this$nextExtent = this.getNextExtent();
        Integer other$nextExtent = other.getNextExtent();
        if (this$nextExtent == null ? other$nextExtent != null : !((Object)this$nextExtent).equals(other$nextExtent)) {
            return false;
        }
        Integer this$minExtents = this.getMinExtents();
        Integer other$minExtents = other.getMinExtents();
        if (this$minExtents == null ? other$minExtents != null : !((Object)this$minExtents).equals(other$minExtents)) {
            return false;
        }
        Integer this$maxExtents = this.getMaxExtents();
        Integer other$maxExtents = other.getMaxExtents();
        if (this$maxExtents == null ? other$maxExtents != null : !((Object)this$maxExtents).equals(other$maxExtents)) {
            return false;
        }
        Integer this$pctIncrease = this.getPctIncrease();
        Integer other$pctIncrease = other.getPctIncrease();
        if (this$pctIncrease == null ? other$pctIncrease != null : !((Object)this$pctIncrease).equals(other$pctIncrease)) {
            return false;
        }
        Integer this$freeLists = this.getFreeLists();
        Integer other$freeLists = other.getFreeLists();
        if (this$freeLists == null ? other$freeLists != null : !((Object)this$freeLists).equals(other$freeLists)) {
            return false;
        }
        Integer this$freeListGroups = this.getFreeListGroups();
        Integer other$freeListGroups = other.getFreeListGroups();
        if (this$freeListGroups == null ? other$freeListGroups != null : !((Object)this$freeListGroups).equals(other$freeListGroups)) {
            return false;
        }
        Map<String, String> this$compressMapping = this.getCompressMapping();
        Map<String, String> other$compressMapping = other.getCompressMapping();
        if (this$compressMapping == null ? other$compressMapping != null : !((Object)this$compressMapping).equals(other$compressMapping)) {
            return false;
        }
        Map<String, ObOracleColumn> this$columnMapping = this.getColumnMapping();
        Map<String, ObOracleColumn> other$columnMapping = other.getColumnMapping();
        if (this$columnMapping == null ? other$columnMapping != null : !((Object)this$columnMapping).equals(other$columnMapping)) {
            return false;
        }
        Map<String, ObOracleIndex> this$indexMapping = this.getIndexMapping();
        Map<String, ObOracleIndex> other$indexMapping = other.getIndexMapping();
        if (this$indexMapping == null ? other$indexMapping != null : !((Object)this$indexMapping).equals(other$indexMapping)) {
            return false;
        }
        Map<String, ObOracleUniqueKey> this$uniqueMapping = this.getUniqueMapping();
        Map<String, ObOracleUniqueKey> other$uniqueMapping = other.getUniqueMapping();
        if (this$uniqueMapping == null ? other$uniqueMapping != null : !((Object)this$uniqueMapping).equals(other$uniqueMapping)) {
            return false;
        }
        Map<String, ObOracleForeignKey> this$foreignMapping = this.getForeignMapping();
        Map<String, ObOracleForeignKey> other$foreignMapping = other.getForeignMapping();
        if (this$foreignMapping == null ? other$foreignMapping != null : !((Object)this$foreignMapping).equals(other$foreignMapping)) {
            return false;
        }
        Map<String, ObOracleCheck> this$checkMapping = this.getCheckMapping();
        Map<String, ObOracleCheck> other$checkMapping = other.getCheckMapping();
        if (this$checkMapping == null ? other$checkMapping != null : !((Object)this$checkMapping).equals(other$checkMapping)) {
            return false;
        }
        String this$tablespaceName = this.getTablespaceName();
        String other$tablespaceName = other.getTablespaceName();
        if (this$tablespaceName == null ? other$tablespaceName != null : !this$tablespaceName.equals(other$tablespaceName)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$iotName = this.getIotName();
        String other$iotName = other.getIotName();
        if (this$iotName == null ? other$iotName != null : !this$iotName.equals(other$iotName)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$logging = this.getLogging();
        String other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !this$logging.equals(other$logging)) {
            return false;
        }
        String this$backedUp = this.getBackedUp();
        String other$backedUp = other.getBackedUp();
        if (this$backedUp == null ? other$backedUp != null : !this$backedUp.equals(other$backedUp)) {
            return false;
        }
        String this$numRows = this.getNumRows();
        String other$numRows = other.getNumRows();
        if (this$numRows == null ? other$numRows != null : !this$numRows.equals(other$numRows)) {
            return false;
        }
        String this$blocks = this.getBlocks();
        String other$blocks = other.getBlocks();
        if (this$blocks == null ? other$blocks != null : !this$blocks.equals(other$blocks)) {
            return false;
        }
        String this$emptyBlocks = this.getEmptyBlocks();
        String other$emptyBlocks = other.getEmptyBlocks();
        if (this$emptyBlocks == null ? other$emptyBlocks != null : !this$emptyBlocks.equals(other$emptyBlocks)) {
            return false;
        }
        String this$avgSpace = this.getAvgSpace();
        String other$avgSpace = other.getAvgSpace();
        if (this$avgSpace == null ? other$avgSpace != null : !this$avgSpace.equals(other$avgSpace)) {
            return false;
        }
        String this$chainCnt = this.getChainCnt();
        String other$chainCnt = other.getChainCnt();
        if (this$chainCnt == null ? other$chainCnt != null : !this$chainCnt.equals(other$chainCnt)) {
            return false;
        }
        String this$avgRowLen = this.getAvgRowLen();
        String other$avgRowLen = other.getAvgRowLen();
        if (this$avgRowLen == null ? other$avgRowLen != null : !this$avgRowLen.equals(other$avgRowLen)) {
            return false;
        }
        String this$avgSpaceFreeListBlocks = this.getAvgSpaceFreeListBlocks();
        String other$avgSpaceFreeListBlocks = other.getAvgSpaceFreeListBlocks();
        if (this$avgSpaceFreeListBlocks == null ? other$avgSpaceFreeListBlocks != null : !this$avgSpaceFreeListBlocks.equals(other$avgSpaceFreeListBlocks)) {
            return false;
        }
        String this$numFreeListBlocks = this.getNumFreeListBlocks();
        String other$numFreeListBlocks = other.getNumFreeListBlocks();
        if (this$numFreeListBlocks == null ? other$numFreeListBlocks != null : !this$numFreeListBlocks.equals(other$numFreeListBlocks)) {
            return false;
        }
        String this$degree = this.getDegree();
        String other$degree = other.getDegree();
        if (this$degree == null ? other$degree != null : !this$degree.equals(other$degree)) {
            return false;
        }
        String this$instances = this.getInstances();
        String other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !this$instances.equals(other$instances)) {
            return false;
        }
        String this$cache = this.getCache();
        String other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !this$cache.equals(other$cache)) {
            return false;
        }
        String this$tableLock = this.getTableLock();
        String other$tableLock = other.getTableLock();
        if (this$tableLock == null ? other$tableLock != null : !this$tableLock.equals(other$tableLock)) {
            return false;
        }
        String this$sampleSize = this.getSampleSize();
        String other$sampleSize = other.getSampleSize();
        if (this$sampleSize == null ? other$sampleSize != null : !this$sampleSize.equals(other$sampleSize)) {
            return false;
        }
        String this$lastAnalyzed = this.getLastAnalyzed();
        String other$lastAnalyzed = other.getLastAnalyzed();
        if (this$lastAnalyzed == null ? other$lastAnalyzed != null : !this$lastAnalyzed.equals(other$lastAnalyzed)) {
            return false;
        }
        String this$partitioned = this.getPartitioned();
        String other$partitioned = other.getPartitioned();
        if (this$partitioned == null ? other$partitioned != null : !this$partitioned.equals(other$partitioned)) {
            return false;
        }
        String this$iotType = this.getIotType();
        String other$iotType = other.getIotType();
        if (this$iotType == null ? other$iotType != null : !this$iotType.equals(other$iotType)) {
            return false;
        }
        String this$objectIdType = this.getObjectIdType();
        String other$objectIdType = other.getObjectIdType();
        if (this$objectIdType == null ? other$objectIdType != null : !this$objectIdType.equals(other$objectIdType)) {
            return false;
        }
        String this$tableTypeOwner = this.getTableTypeOwner();
        String other$tableTypeOwner = other.getTableTypeOwner();
        if (this$tableTypeOwner == null ? other$tableTypeOwner != null : !this$tableTypeOwner.equals(other$tableTypeOwner)) {
            return false;
        }
        String this$objectTableType = this.getObjectTableType();
        String other$objectTableType = other.getObjectTableType();
        if (this$objectTableType == null ? other$objectTableType != null : !this$objectTableType.equals(other$objectTableType)) {
            return false;
        }
        String this$temporary = this.getTemporary();
        String other$temporary = other.getTemporary();
        if (this$temporary == null ? other$temporary != null : !this$temporary.equals(other$temporary)) {
            return false;
        }
        String this$secondary = this.getSecondary();
        String other$secondary = other.getSecondary();
        if (this$secondary == null ? other$secondary != null : !this$secondary.equals(other$secondary)) {
            return false;
        }
        String this$nested = this.getNested();
        String other$nested = other.getNested();
        if (this$nested == null ? other$nested != null : !this$nested.equals(other$nested)) {
            return false;
        }
        String this$bufferPool = this.getBufferPool();
        String other$bufferPool = other.getBufferPool();
        if (this$bufferPool == null ? other$bufferPool != null : !this$bufferPool.equals(other$bufferPool)) {
            return false;
        }
        String this$flashCache = this.getFlashCache();
        String other$flashCache = other.getFlashCache();
        if (this$flashCache == null ? other$flashCache != null : !this$flashCache.equals(other$flashCache)) {
            return false;
        }
        String this$cellFlashCache = this.getCellFlashCache();
        String other$cellFlashCache = other.getCellFlashCache();
        if (this$cellFlashCache == null ? other$cellFlashCache != null : !this$cellFlashCache.equals(other$cellFlashCache)) {
            return false;
        }
        String this$rowMovement = this.getRowMovement();
        String other$rowMovement = other.getRowMovement();
        if (this$rowMovement == null ? other$rowMovement != null : !this$rowMovement.equals(other$rowMovement)) {
            return false;
        }
        String this$globalStats = this.getGlobalStats();
        String other$globalStats = other.getGlobalStats();
        if (this$globalStats == null ? other$globalStats != null : !this$globalStats.equals(other$globalStats)) {
            return false;
        }
        String this$userStats = this.getUserStats();
        String other$userStats = other.getUserStats();
        if (this$userStats == null ? other$userStats != null : !this$userStats.equals(other$userStats)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        String this$skipCorrupt = this.getSkipCorrupt();
        String other$skipCorrupt = other.getSkipCorrupt();
        if (this$skipCorrupt == null ? other$skipCorrupt != null : !this$skipCorrupt.equals(other$skipCorrupt)) {
            return false;
        }
        String this$monitoring = this.getMonitoring();
        String other$monitoring = other.getMonitoring();
        if (this$monitoring == null ? other$monitoring != null : !this$monitoring.equals(other$monitoring)) {
            return false;
        }
        String this$clusterOwner = this.getClusterOwner();
        String other$clusterOwner = other.getClusterOwner();
        if (this$clusterOwner == null ? other$clusterOwner != null : !this$clusterOwner.equals(other$clusterOwner)) {
            return false;
        }
        String this$dependencies = this.getDependencies();
        String other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !this$dependencies.equals(other$dependencies)) {
            return false;
        }
        String this$compression = this.getCompression();
        String other$compression = other.getCompression();
        if (this$compression == null ? other$compression != null : !this$compression.equals(other$compression)) {
            return false;
        }
        String this$compressFor = this.getCompressFor();
        String other$compressFor = other.getCompressFor();
        if (this$compressFor == null ? other$compressFor != null : !this$compressFor.equals(other$compressFor)) {
            return false;
        }
        String this$dropped = this.getDropped();
        String other$dropped = other.getDropped();
        if (this$dropped == null ? other$dropped != null : !this$dropped.equals(other$dropped)) {
            return false;
        }
        String this$segmentCreated = this.getSegmentCreated();
        String other$segmentCreated = other.getSegmentCreated();
        if (this$segmentCreated == null ? other$segmentCreated != null : !this$segmentCreated.equals(other$segmentCreated)) {
            return false;
        }
        String this$storeTableName = this.getStoreTableName();
        String other$storeTableName = other.getStoreTableName();
        if (this$storeTableName == null ? other$storeTableName != null : !this$storeTableName.equals(other$storeTableName)) {
            return false;
        }
        String this$nestedTableName = this.getNestedTableName();
        String other$nestedTableName = other.getNestedTableName();
        if (this$nestedTableName == null ? other$nestedTableName != null : !this$nestedTableName.equals(other$nestedTableName)) {
            return false;
        }
        String this$tableGroupName = this.getTableGroupName();
        String other$tableGroupName = other.getTableGroupName();
        if (this$tableGroupName == null ? other$tableGroupName != null : !this$tableGroupName.equals(other$tableGroupName)) {
            return false;
        }
        ObOraclePrimaryKey this$primaryKey = this.getPrimaryKey();
        ObOraclePrimaryKey other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !((Object)this$primaryKey).equals(other$primaryKey)) {
            return false;
        }
        ObOracleTablePartition this$tablePartition = this.getTablePartition();
        ObOracleTablePartition other$tablePartition = other.getTablePartition();
        return !(this$tablePartition == null ? other$tablePartition != null : !((Object)this$tablePartition).equals(other$tablePartition));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObOracleTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $pctFree = this.getPctFree();
        result = result * 59 + ($pctFree == null ? 43 : ((Object)$pctFree).hashCode());
        Integer $pctUsed = this.getPctUsed();
        result = result * 59 + ($pctUsed == null ? 43 : ((Object)$pctUsed).hashCode());
        Integer $iniTrans = this.getIniTrans();
        result = result * 59 + ($iniTrans == null ? 43 : ((Object)$iniTrans).hashCode());
        Integer $maxTrans = this.getMaxTrans();
        result = result * 59 + ($maxTrans == null ? 43 : ((Object)$maxTrans).hashCode());
        Integer $initialExtent = this.getInitialExtent();
        result = result * 59 + ($initialExtent == null ? 43 : ((Object)$initialExtent).hashCode());
        Integer $nextExtent = this.getNextExtent();
        result = result * 59 + ($nextExtent == null ? 43 : ((Object)$nextExtent).hashCode());
        Integer $minExtents = this.getMinExtents();
        result = result * 59 + ($minExtents == null ? 43 : ((Object)$minExtents).hashCode());
        Integer $maxExtents = this.getMaxExtents();
        result = result * 59 + ($maxExtents == null ? 43 : ((Object)$maxExtents).hashCode());
        Integer $pctIncrease = this.getPctIncrease();
        result = result * 59 + ($pctIncrease == null ? 43 : ((Object)$pctIncrease).hashCode());
        Integer $freeLists = this.getFreeLists();
        result = result * 59 + ($freeLists == null ? 43 : ((Object)$freeLists).hashCode());
        Integer $freeListGroups = this.getFreeListGroups();
        result = result * 59 + ($freeListGroups == null ? 43 : ((Object)$freeListGroups).hashCode());
        Map<String, String> $compressMapping = this.getCompressMapping();
        result = result * 59 + ($compressMapping == null ? 43 : ((Object)$compressMapping).hashCode());
        Map<String, ObOracleColumn> $columnMapping = this.getColumnMapping();
        result = result * 59 + ($columnMapping == null ? 43 : ((Object)$columnMapping).hashCode());
        Map<String, ObOracleIndex> $indexMapping = this.getIndexMapping();
        result = result * 59 + ($indexMapping == null ? 43 : ((Object)$indexMapping).hashCode());
        Map<String, ObOracleUniqueKey> $uniqueMapping = this.getUniqueMapping();
        result = result * 59 + ($uniqueMapping == null ? 43 : ((Object)$uniqueMapping).hashCode());
        Map<String, ObOracleForeignKey> $foreignMapping = this.getForeignMapping();
        result = result * 59 + ($foreignMapping == null ? 43 : ((Object)$foreignMapping).hashCode());
        Map<String, ObOracleCheck> $checkMapping = this.getCheckMapping();
        result = result * 59 + ($checkMapping == null ? 43 : ((Object)$checkMapping).hashCode());
        String $tablespaceName = this.getTablespaceName();
        result = result * 59 + ($tablespaceName == null ? 43 : $tablespaceName.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $iotName = this.getIotName();
        result = result * 59 + ($iotName == null ? 43 : $iotName.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : $logging.hashCode());
        String $backedUp = this.getBackedUp();
        result = result * 59 + ($backedUp == null ? 43 : $backedUp.hashCode());
        String $numRows = this.getNumRows();
        result = result * 59 + ($numRows == null ? 43 : $numRows.hashCode());
        String $blocks = this.getBlocks();
        result = result * 59 + ($blocks == null ? 43 : $blocks.hashCode());
        String $emptyBlocks = this.getEmptyBlocks();
        result = result * 59 + ($emptyBlocks == null ? 43 : $emptyBlocks.hashCode());
        String $avgSpace = this.getAvgSpace();
        result = result * 59 + ($avgSpace == null ? 43 : $avgSpace.hashCode());
        String $chainCnt = this.getChainCnt();
        result = result * 59 + ($chainCnt == null ? 43 : $chainCnt.hashCode());
        String $avgRowLen = this.getAvgRowLen();
        result = result * 59 + ($avgRowLen == null ? 43 : $avgRowLen.hashCode());
        String $avgSpaceFreeListBlocks = this.getAvgSpaceFreeListBlocks();
        result = result * 59 + ($avgSpaceFreeListBlocks == null ? 43 : $avgSpaceFreeListBlocks.hashCode());
        String $numFreeListBlocks = this.getNumFreeListBlocks();
        result = result * 59 + ($numFreeListBlocks == null ? 43 : $numFreeListBlocks.hashCode());
        String $degree = this.getDegree();
        result = result * 59 + ($degree == null ? 43 : $degree.hashCode());
        String $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : $instances.hashCode());
        String $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        String $tableLock = this.getTableLock();
        result = result * 59 + ($tableLock == null ? 43 : $tableLock.hashCode());
        String $sampleSize = this.getSampleSize();
        result = result * 59 + ($sampleSize == null ? 43 : $sampleSize.hashCode());
        String $lastAnalyzed = this.getLastAnalyzed();
        result = result * 59 + ($lastAnalyzed == null ? 43 : $lastAnalyzed.hashCode());
        String $partitioned = this.getPartitioned();
        result = result * 59 + ($partitioned == null ? 43 : $partitioned.hashCode());
        String $iotType = this.getIotType();
        result = result * 59 + ($iotType == null ? 43 : $iotType.hashCode());
        String $objectIdType = this.getObjectIdType();
        result = result * 59 + ($objectIdType == null ? 43 : $objectIdType.hashCode());
        String $tableTypeOwner = this.getTableTypeOwner();
        result = result * 59 + ($tableTypeOwner == null ? 43 : $tableTypeOwner.hashCode());
        String $objectTableType = this.getObjectTableType();
        result = result * 59 + ($objectTableType == null ? 43 : $objectTableType.hashCode());
        String $temporary = this.getTemporary();
        result = result * 59 + ($temporary == null ? 43 : $temporary.hashCode());
        String $secondary = this.getSecondary();
        result = result * 59 + ($secondary == null ? 43 : $secondary.hashCode());
        String $nested = this.getNested();
        result = result * 59 + ($nested == null ? 43 : $nested.hashCode());
        String $bufferPool = this.getBufferPool();
        result = result * 59 + ($bufferPool == null ? 43 : $bufferPool.hashCode());
        String $flashCache = this.getFlashCache();
        result = result * 59 + ($flashCache == null ? 43 : $flashCache.hashCode());
        String $cellFlashCache = this.getCellFlashCache();
        result = result * 59 + ($cellFlashCache == null ? 43 : $cellFlashCache.hashCode());
        String $rowMovement = this.getRowMovement();
        result = result * 59 + ($rowMovement == null ? 43 : $rowMovement.hashCode());
        String $globalStats = this.getGlobalStats();
        result = result * 59 + ($globalStats == null ? 43 : $globalStats.hashCode());
        String $userStats = this.getUserStats();
        result = result * 59 + ($userStats == null ? 43 : $userStats.hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        String $skipCorrupt = this.getSkipCorrupt();
        result = result * 59 + ($skipCorrupt == null ? 43 : $skipCorrupt.hashCode());
        String $monitoring = this.getMonitoring();
        result = result * 59 + ($monitoring == null ? 43 : $monitoring.hashCode());
        String $clusterOwner = this.getClusterOwner();
        result = result * 59 + ($clusterOwner == null ? 43 : $clusterOwner.hashCode());
        String $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : $dependencies.hashCode());
        String $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : $compression.hashCode());
        String $compressFor = this.getCompressFor();
        result = result * 59 + ($compressFor == null ? 43 : $compressFor.hashCode());
        String $dropped = this.getDropped();
        result = result * 59 + ($dropped == null ? 43 : $dropped.hashCode());
        String $segmentCreated = this.getSegmentCreated();
        result = result * 59 + ($segmentCreated == null ? 43 : $segmentCreated.hashCode());
        String $storeTableName = this.getStoreTableName();
        result = result * 59 + ($storeTableName == null ? 43 : $storeTableName.hashCode());
        String $nestedTableName = this.getNestedTableName();
        result = result * 59 + ($nestedTableName == null ? 43 : $nestedTableName.hashCode());
        String $tableGroupName = this.getTableGroupName();
        result = result * 59 + ($tableGroupName == null ? 43 : $tableGroupName.hashCode());
        ObOraclePrimaryKey $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : ((Object)$primaryKey).hashCode());
        ObOracleTablePartition $tablePartition = this.getTablePartition();
        result = result * 59 + ($tablePartition == null ? 43 : ((Object)$tablePartition).hashCode());
        return result;
    }

    public Map<String, String> getCompressMapping() {
        return this.compressMapping;
    }

    public Map<String, ObOracleColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, ObOracleIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, ObOracleUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, ObOracleForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public Map<String, ObOracleCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public void setTablespaceName(String tablespaceName) {
        this.tablespaceName = tablespaceName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getIotName() {
        return this.iotName;
    }

    public void setIotName(String iotName) {
        this.iotName = iotName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getPctFree() {
        return this.pctFree;
    }

    public void setPctFree(Integer pctFree) {
        this.pctFree = pctFree;
    }

    public Integer getPctUsed() {
        return this.pctUsed;
    }

    public void setPctUsed(Integer pctUsed) {
        this.pctUsed = pctUsed;
    }

    public Integer getIniTrans() {
        return this.iniTrans;
    }

    public void setIniTrans(Integer iniTrans) {
        this.iniTrans = iniTrans;
    }

    public Integer getMaxTrans() {
        return this.maxTrans;
    }

    public void setMaxTrans(Integer maxTrans) {
        this.maxTrans = maxTrans;
    }

    public Integer getInitialExtent() {
        return this.initialExtent;
    }

    public void setInitialExtent(Integer initialExtent) {
        this.initialExtent = initialExtent;
    }

    public Integer getNextExtent() {
        return this.nextExtent;
    }

    public void setNextExtent(Integer nextExtent) {
        this.nextExtent = nextExtent;
    }

    public Integer getMinExtents() {
        return this.minExtents;
    }

    public void setMinExtents(Integer minExtents) {
        this.minExtents = minExtents;
    }

    public Integer getMaxExtents() {
        return this.maxExtents;
    }

    public void setMaxExtents(Integer maxExtents) {
        this.maxExtents = maxExtents;
    }

    public Integer getPctIncrease() {
        return this.pctIncrease;
    }

    public void setPctIncrease(Integer pctIncrease) {
        this.pctIncrease = pctIncrease;
    }

    public Integer getFreeLists() {
        return this.freeLists;
    }

    public void setFreeLists(Integer freeLists) {
        this.freeLists = freeLists;
    }

    public Integer getFreeListGroups() {
        return this.freeListGroups;
    }

    public void setFreeListGroups(Integer freeListGroups) {
        this.freeListGroups = freeListGroups;
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String logging) {
        this.logging = logging;
    }

    public String getBackedUp() {
        return this.backedUp;
    }

    public void setBackedUp(String backedUp) {
        this.backedUp = backedUp;
    }

    public String getNumRows() {
        return this.numRows;
    }

    public void setNumRows(String numRows) {
        this.numRows = numRows;
    }

    public String getBlocks() {
        return this.blocks;
    }

    public void setBlocks(String blocks) {
        this.blocks = blocks;
    }

    public String getEmptyBlocks() {
        return this.emptyBlocks;
    }

    public void setEmptyBlocks(String emptyBlocks) {
        this.emptyBlocks = emptyBlocks;
    }

    public String getAvgSpace() {
        return this.avgSpace;
    }

    public void setAvgSpace(String avgSpace) {
        this.avgSpace = avgSpace;
    }

    public String getChainCnt() {
        return this.chainCnt;
    }

    public void setChainCnt(String chainCnt) {
        this.chainCnt = chainCnt;
    }

    public String getAvgRowLen() {
        return this.avgRowLen;
    }

    public void setAvgRowLen(String avgRowLen) {
        this.avgRowLen = avgRowLen;
    }

    public String getAvgSpaceFreeListBlocks() {
        return this.avgSpaceFreeListBlocks;
    }

    public void setAvgSpaceFreeListBlocks(String avgSpaceFreeListBlocks) {
        this.avgSpaceFreeListBlocks = avgSpaceFreeListBlocks;
    }

    public String getNumFreeListBlocks() {
        return this.numFreeListBlocks;
    }

    public void setNumFreeListBlocks(String numFreeListBlocks) {
        this.numFreeListBlocks = numFreeListBlocks;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        this.degree = degree;
    }

    public String getInstances() {
        return this.instances;
    }

    public void setInstances(String instances) {
        this.instances = instances;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public String getTableLock() {
        return this.tableLock;
    }

    public void setTableLock(String tableLock) {
        this.tableLock = tableLock;
    }

    public String getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(String sampleSize) {
        this.sampleSize = sampleSize;
    }

    public String getLastAnalyzed() {
        return this.lastAnalyzed;
    }

    public void setLastAnalyzed(String lastAnalyzed) {
        this.lastAnalyzed = lastAnalyzed;
    }

    public String getPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(String partitioned) {
        this.partitioned = partitioned;
    }

    public String getIotType() {
        return this.iotType;
    }

    public void setIotType(String iotType) {
        this.iotType = iotType;
    }

    public String getObjectIdType() {
        return this.objectIdType;
    }

    public void setObjectIdType(String objectIdType) {
        this.objectIdType = objectIdType;
    }

    public String getTableTypeOwner() {
        return this.tableTypeOwner;
    }

    public void setTableTypeOwner(String tableTypeOwner) {
        this.tableTypeOwner = tableTypeOwner;
    }

    public String getObjectTableType() {
        return this.objectTableType;
    }

    public void setObjectTableType(String objectTableType) {
        this.objectTableType = objectTableType;
    }

    public String getTemporary() {
        return this.temporary;
    }

    public void setTemporary(String temporary) {
        this.temporary = temporary;
    }

    public String getSecondary() {
        return this.secondary;
    }

    public void setSecondary(String secondary) {
        this.secondary = secondary;
    }

    public String getNested() {
        return this.nested;
    }

    public void setNested(String nested) {
        this.nested = nested;
    }

    public String getBufferPool() {
        return this.bufferPool;
    }

    public void setBufferPool(String bufferPool) {
        this.bufferPool = bufferPool;
    }

    public String getFlashCache() {
        return this.flashCache;
    }

    public void setFlashCache(String flashCache) {
        this.flashCache = flashCache;
    }

    public String getCellFlashCache() {
        return this.cellFlashCache;
    }

    public void setCellFlashCache(String cellFlashCache) {
        this.cellFlashCache = cellFlashCache;
    }

    public String getRowMovement() {
        return this.rowMovement;
    }

    public void setRowMovement(String rowMovement) {
        this.rowMovement = rowMovement;
    }

    public String getGlobalStats() {
        return this.globalStats;
    }

    public void setGlobalStats(String globalStats) {
        this.globalStats = globalStats;
    }

    public String getUserStats() {
        return this.userStats;
    }

    public void setUserStats(String userStats) {
        this.userStats = userStats;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getSkipCorrupt() {
        return this.skipCorrupt;
    }

    public void setSkipCorrupt(String skipCorrupt) {
        this.skipCorrupt = skipCorrupt;
    }

    public String getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(String monitoring) {
        this.monitoring = monitoring;
    }

    public String getClusterOwner() {
        return this.clusterOwner;
    }

    public void setClusterOwner(String clusterOwner) {
        this.clusterOwner = clusterOwner;
    }

    public String getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(String dependencies) {
        this.dependencies = dependencies;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getCompressFor() {
        return this.compressFor;
    }

    public void setCompressFor(String compressFor) {
        this.compressFor = compressFor;
    }

    public String getDropped() {
        return this.dropped;
    }

    public void setDropped(String dropped) {
        this.dropped = dropped;
    }

    public String getSegmentCreated() {
        return this.segmentCreated;
    }

    public void setSegmentCreated(String segmentCreated) {
        this.segmentCreated = segmentCreated;
    }

    public String getStoreTableName() {
        return this.storeTableName;
    }

    public void setStoreTableName(String storeTableName) {
        this.storeTableName = storeTableName;
    }

    public String getNestedTableName() {
        return this.nestedTableName;
    }

    public void setNestedTableName(String nestedTableName) {
        this.nestedTableName = nestedTableName;
    }

    public String getTableGroupName() {
        return this.tableGroupName;
    }

    public void setTableGroupName(String tableGroupName) {
        this.tableGroupName = tableGroupName;
    }

    public ObOraclePrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(ObOraclePrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public ObOracleTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(ObOracleTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }

    static {
        DEFAULT_DELIM_TOKENS.add("`");
        DEFAULT_DELIM_TOKENS.add(",");
        DEFAULT_DELIM_TOKENS.add(";");
        DEFAULT_DELIM_TOKENS.add(" ");
        DEFAULT_DELIM_TOKENS.add("(");
        DEFAULT_DELIM_TOKENS.add(")");
        DEFAULT_DELIM_TOKENS.add("+");
        DEFAULT_DELIM_TOKENS.add("-");
        DEFAULT_DELIM_TOKENS.add("*");
        DEFAULT_DELIM_TOKENS.add("/");
        DEFAULT_DELIM_TOKENS.add("%");
        DEFAULT_DELIM_TOKENS.add("=");
        DEFAULT_DELIM_TOKENS.add(">");
        DEFAULT_DELIM_TOKENS.add("<");
        DEFAULT_DELIM_TOKENS.add("|");
        DEFAULT_DELIM_TOKENS.add("$");
        DEFAULT_DELIM_TOKENS.add("!");
        DEFAULT_DELIM_TOKENS.add("||");
        DEFAULT_DELIM_TOKENS.add("&");
        DEFAULT_DELIM_TOKENS.add("~");
        DEFAULT_DELIM_TOKENS.add("\n");
        DEFAULT_DELIM_TOKENS.add("\t");
        DEFAULT_DELIM_TOKENS.add("\"");
    }
}

