/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractTablePartition;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ObOracleTablePartition
extends AbstractTablePartition {
    private final Collection<OracleTablePartitionItem> tablePartitions = new LinkedHashSet<OracleTablePartitionItem>();
    private final Collection<OracleTablePartitionColumn> tablePartitionColumns = new LinkedHashSet<OracleTablePartitionColumn>();
    private final Collection<OracleTablePartitionColumn> tableSubPartitionColumns = new LinkedHashSet<OracleTablePartitionColumn>();
    private final Collection<OracleTablePartitionTemplate> tablePartitionTemplates = new LinkedHashSet<OracleTablePartitionTemplate>();
    private final Map<String, List<OracleTablePartitionItem>> tableSubPartitionMapping = new LinkedHashMap<String, List<OracleTablePartitionItem>>();
    private String partitioningType;
    private String subPartitioningType;
    private Integer partitionCount;
    private Integer defSubPartitionCount;
    private Integer partitioningKeyCount;
    private Integer subPartitioningKeyCount;
    private String status;
    private String defTablespaceName;
    private Integer defPctFree;
    private Integer defPctUsed;
    private Integer defIniTrans;
    private Integer defMaxTrans;
    private String defInitialExtent;
    private String defNextExtent;
    private String defMinExtents;
    private String defMaxExtents;
    private String defMaxSize;
    private String defPctIncrease;
    private Integer defFreeLists;
    private Integer defFreeListGroups;
    private String defLogging;
    private String defCompression;
    private String defCompressFor;
    private String defBufferPool;
    private String defFlashCache;
    private String defCellFlashCache;
    private String refPtnConstraintName;
    private String interval;
    private String isNested;
    private String defSegmentCreation;

    public ObOracleTablePartition(ObOracleSchema schema) {
        super(schema);
    }

    @Override
    public ObOracleSchema getSchema() {
        return (ObOracleSchema)super.getSchema();
    }

    public void setSchema(ObOracleSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String partitionType = this.getPartTypeMapping().get(this.getPartitioningType());
        if (StringUtils.isBlank(partitionType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The table partition type is null");
        }
        if ("SYSTEM".equals(partitionType) || "REFERENCE".equals(partitionType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The table partition type: " + this.getPartitioningType() + " is unsupported");
        }
        if (this.isComposite()) {
            if (DbType.OBORACLE_2273.isSubsequent(this.getDbType())) {
                return this.buildCompositePartitionGrammarOld(partitionType);
            }
            return this.buildCompositePartitionGrammar(partitionType);
        }
        return this.buildNonCompositePartitionGrammar(partitionType);
    }

    protected StringBuilder buildCompositePartitionGrammarOld(String partitionType) throws UnsupportedGrammarException {
        String subPartitionType = this.getPartTypeMapping().get(this.getSubPartitioningType());
        if (StringUtils.isBlank(subPartitionType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The table subpartition type is null");
        }
        this.setPartitioningKeyCount(Math.max(this.getPartitioningKeyCount(), 1));
        this.setSubPartitioningKeyCount(Math.max(this.getSubPartitioningKeyCount(), 1));
        if (this.getDbType() != null && this.getDbType().isPrior(DbType.OBORACLE_2271)) {
            if (partitionType.equals(subPartitionType) && CollectionUtils.isNotEmpty(this.getTableSubPartitionColumns())) {
                throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The composite table partition: [" + partitionType + " + " + subPartitionType + "] is unsupported");
            }
            boolean isHashSubPartition = "HASH".equals(subPartitionType);
            if (isHashSubPartition && CollectionUtils.isNotEmpty(this.getTablePartitionTemplates())) {
                this.setDefSubPartitionCount(this.getTablePartitionTemplates().size());
                this.getTablePartitionTemplates().clear();
            }
        }
        return this.buildCompositePartitionGrammar(partitionType);
    }

    protected StringBuilder buildCompositePartitionGrammar(String partitionType) throws UnsupportedGrammarException {
        String subPartitionType;
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("PARTITION BY ").append(partitionType);
        if ("REFERENCE".equals(partitionType)) {
            sb.append((CharSequence)this.enclose(this.getRefPtnConstraintName()));
        } else {
            Integer partitioningKeyCount = this.getPartitioningKeyCount();
            if (partitioningKeyCount != null && partitioningKeyCount > 0) {
                sb.append((CharSequence)this.joinColumns(this.getTablePartitionColumns()));
            }
        }
        String interval = this.getInterval();
        if ("RANGE".equals(partitionType) && StringUtils.isNotBlank(interval)) {
            sb.append((CharSequence)this.buildIntervalExpr(partitionType, interval));
        }
        if (StringUtils.isBlank(subPartitionType = this.getPartTypeMapping().get(this.getSubPartitioningType()))) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The table subpartition type: " + this.getSubPartitioningType() + " is unsupported");
        }
        sb.append("\n").append("SUBPARTITION BY ").append(subPartitionType);
        Integer subPartitionKeyCount = this.getSubPartitioningKeyCount();
        if (subPartitionKeyCount != null && subPartitionKeyCount > 0) {
            sb.append((CharSequence)this.joinColumns(this.getTableSubPartitionColumns()));
        }
        if (CollectionUtils.isNotEmpty(this.getTablePartitionTemplates())) {
            return sb.append((CharSequence)this.buildCompositePartitionGrammarWithTemplate(partitionType, subPartitionType));
        }
        return sb.append((CharSequence)this.buildCompositePartitionGrammarWithoutTemplate(partitionType, subPartitionType));
    }

    protected StringBuilder buildNonCompositePartitionGrammar(String partitionType) throws UnsupportedGrammarException {
        Collection<OracleTablePartitionItem> tablePartitions;
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("PARTITION BY ").append(partitionType);
        if ("REFERENCE".equals(partitionType)) {
            return sb.append((CharSequence)this.enclose(this.getRefPtnConstraintName()));
        }
        Integer partitioningKeyCount = this.getPartitioningKeyCount();
        if (partitioningKeyCount != null && partitioningKeyCount > 0) {
            sb.append((CharSequence)this.joinColumns(this.getTablePartitionColumns()));
        }
        String interval = this.getInterval();
        if ("RANGE".equals(partitionType) && StringUtils.isNotBlank(interval)) {
            sb.append((CharSequence)this.buildIntervalExpr(partitionType, interval));
        }
        if (CollectionUtils.isEmpty(tablePartitions = this.getTablePartitions())) {
            return sb;
        }
        String partFormat = this.getTablePartTemplateMapping().get(partitionType);
        sb.append("\n").append("(");
        Iterator<OracleTablePartitionItem> iter = tablePartitions.iterator();
        while (iter.hasNext()) {
            OracleTablePartitionItem partItem = iter.next();
            sb.append("\n\t");
            String highValue = partItem.getHighValue();
            String partName = this.wrap(partItem.getPartitionName());
            if (highValue == null) {
                sb.append(String.format(partFormat, partName));
            } else {
                sb.append(String.format(partFormat, partName, highValue));
            }
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    protected StringBuilder buildCompositePartitionGrammarWithTemplate(String partitionType, String subPartitionType) throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String subPartFormat = this.getTableSubPartTemplateMapping().get(subPartitionType);
        sb.append("\n").append("SUBPARTITION TEMPLATE");
        sb.append("\n").append("(");
        Iterator<OracleTablePartitionTemplate> iter = this.getTablePartitionTemplates().iterator();
        while (iter.hasNext()) {
            OracleTablePartitionTemplate template = iter.next();
            sb.append("\n\t");
            sb.append(String.format(subPartFormat, this.wrap(template.getSubPartitionName()), template.getHighBound()));
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("\n").append(")");
        String partFormat = this.getTablePartTemplateMapping().get(partitionType);
        sb.append("\n").append("(");
        Iterator<OracleTablePartitionItem> iter2 = this.getTablePartitions().iterator();
        while (iter2.hasNext()) {
            OracleTablePartitionItem partItem = iter2.next();
            sb.append("\n\t");
            sb.append(String.format(partFormat, this.wrap(partItem.getPartitionName()), partItem.getHighValue()));
            if (!iter2.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    protected StringBuilder buildCompositePartitionGrammarWithoutTemplate(String partitionType, String subPartitionType) throws UnsupportedGrammarException {
        if (this.getDbType() != null && this.getDbType().isPrior(DbType.OBORACLE_2270)) {
            if (!"HASH".equals(subPartitionType)) {
                throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The table subpartition must be declared as SUBPARTITION TEMPLATE");
            }
            StringBuilder sb = new StringBuilder();
            Integer defSubPartitionCount = this.getDefSubPartitionCount();
            if (defSubPartitionCount != null && defSubPartitionCount > 0) {
                sb.append("\n").append("SUBPARTITIONS ").append(defSubPartitionCount);
            }
            sb.append("\n").append("(");
            String partFormat = this.getTablePartTemplateMapping().get(partitionType);
            Iterator<OracleTablePartitionItem> iter = this.getTablePartitions().iterator();
            while (iter.hasNext()) {
                boolean isUserSpecified;
                OracleTablePartitionItem partItem = iter.next();
                String partName = partItem.getPartitionName();
                sb.append("\n\t");
                sb.append(String.format(partFormat, this.wrap(partName), partItem.getHighValue()));
                List<OracleTablePartitionItem> subPartItems = this.getTableSubPartitionMapping().get(partName);
                if (CollectionUtils.isNotEmpty(subPartItems) && ((isUserSpecified = subPartItems.stream().filter(e -> e != null).anyMatch(e -> "N".equals(e.getGenerated()) || "NO".equals(e.getGenerated()))) || defSubPartitionCount != null && !defSubPartitionCount.equals(partItem.getSubPartitionCount()))) {
                    throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The individual hash subpartition is unsupported");
                }
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            return sb.append("\n").append(")");
        }
        return this.buildCompositePartitionGrammarWithoutTemplate2(partitionType, subPartitionType);
    }

    protected StringBuilder buildCompositePartitionGrammarWithoutTemplate2(String partitionType, String subPartitionType) throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        Integer defSubPartitionCount = this.getDefSubPartitionCount();
        boolean isHashSubpartition = "HASH".equals(subPartitionType);
        boolean isHasSubPartitions = defSubPartitionCount != null && defSubPartitionCount > 0;
        boolean isHashPartitionsByQuantity = isHashSubpartition && isHasSubPartitions && defSubPartitionCount > 1;
        sb.append("\n").append("(");
        String partFormat = this.getTablePartTemplateMapping().get(partitionType);
        String subPartFormat = this.getTableSubPartTemplateMapping().get(subPartitionType);
        Iterator<OracleTablePartitionItem> iter = this.getTablePartitions().iterator();
        block0: while (iter.hasNext()) {
            OracleTablePartitionItem partItem = iter.next();
            String partName = partItem.getPartitionName();
            sb.append("\n\t");
            sb.append(String.format(partFormat, this.wrap(partName), partItem.getHighValue()));
            List<OracleTablePartitionItem> subPartItems = this.getTableSubPartitionMapping().get(partName);
            if (!isHashPartitionsByQuantity && CollectionUtils.isNotEmpty(subPartItems)) {
                boolean isFirstSubPartItem = true;
                Iterator<OracleTablePartitionItem> subIter = subPartItems.iterator();
                while (subIter.hasNext()) {
                    OracleTablePartitionItem subPartItem = subIter.next();
                    boolean isGenerated = "Y".equals(subPartItem.getGenerated());
                    if (!isGenerated && isFirstSubPartItem) {
                        sb.append("\n\t").append("(");
                        isFirstSubPartItem = false;
                    }
                    if (isGenerated) {
                        int itemSize = subPartItems.size();
                        if (itemSize > 1) {
                            sb.append("\n\t\tSUBPARTITIONS ").append(itemSize);
                        }
                        if (!iter.hasNext()) continue block0;
                        sb.append(",");
                        continue block0;
                    }
                    String subPartName = this.wrap(subPartItem.getSubPartitionName());
                    sb.append("\n\t\t");
                    sb.append(String.format(subPartFormat, subPartName, subPartItem.getHighValue()));
                    if (!subIter.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("\n\t").append(")");
            }
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    public boolean isComposite() {
        String subPartitionType = this.getSubPartitioningType();
        return subPartitionType != null && !"NONE".equals(subPartitionType) && CollectionUtils.isNotEmpty(this.getTableSubPartitionColumns());
    }

    protected StringBuilder buildIntervalExpr(String partitionType, String interval) {
        return new StringBuilder();
    }

    protected StringBuilder joinColumns(Collection<OracleTablePartitionColumn> cols) {
        if (CollectionUtils.isEmpty(cols)) {
            throw new IllegalArgumentException("Table partition columns is null. Object: " + this.getOriginSchemaObjectName());
        }
        return this.enclose(cols.stream().map(e -> ((OracleTablePartitionColumn)e).isExpression ? e.getColumnName() : this.wrap(e.getColumnName())).collect(Collectors.joining(", ")));
    }

    @Override
    public String toString() {
        return "ObOracleTablePartition(tablePartitions=" + this.getTablePartitions() + ", tablePartitionColumns=" + this.getTablePartitionColumns() + ", tableSubPartitionColumns=" + this.getTableSubPartitionColumns() + ", tablePartitionTemplates=" + this.getTablePartitionTemplates() + ", tableSubPartitionMapping=" + this.getTableSubPartitionMapping() + ", partitioningType=" + this.getPartitioningType() + ", subPartitioningType=" + this.getSubPartitioningType() + ", partitionCount=" + this.getPartitionCount() + ", defSubPartitionCount=" + this.getDefSubPartitionCount() + ", partitioningKeyCount=" + this.getPartitioningKeyCount() + ", subPartitioningKeyCount=" + this.getSubPartitioningKeyCount() + ", status=" + this.getStatus() + ", defTablespaceName=" + this.getDefTablespaceName() + ", defPctFree=" + this.getDefPctFree() + ", defPctUsed=" + this.getDefPctUsed() + ", defIniTrans=" + this.getDefIniTrans() + ", defMaxTrans=" + this.getDefMaxTrans() + ", defInitialExtent=" + this.getDefInitialExtent() + ", defNextExtent=" + this.getDefNextExtent() + ", defMinExtents=" + this.getDefMinExtents() + ", defMaxExtents=" + this.getDefMaxExtents() + ", defMaxSize=" + this.getDefMaxSize() + ", defPctIncrease=" + this.getDefPctIncrease() + ", defFreeLists=" + this.getDefFreeLists() + ", defFreeListGroups=" + this.getDefFreeListGroups() + ", defLogging=" + this.getDefLogging() + ", defCompression=" + this.getDefCompression() + ", defCompressFor=" + this.getDefCompressFor() + ", defBufferPool=" + this.getDefBufferPool() + ", defFlashCache=" + this.getDefFlashCache() + ", defCellFlashCache=" + this.getDefCellFlashCache() + ", refPtnConstraintName=" + this.getRefPtnConstraintName() + ", interval=" + this.getInterval() + ", isNested=" + this.getIsNested() + ", defSegmentCreation=" + this.getDefSegmentCreation() + ")";
    }

    public ObOracleTablePartition() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleTablePartition)) {
            return false;
        }
        ObOracleTablePartition other = (ObOracleTablePartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$partitionCount = this.getPartitionCount();
        Integer other$partitionCount = other.getPartitionCount();
        if (this$partitionCount == null ? other$partitionCount != null : !((Object)this$partitionCount).equals(other$partitionCount)) {
            return false;
        }
        Integer this$defSubPartitionCount = this.getDefSubPartitionCount();
        Integer other$defSubPartitionCount = other.getDefSubPartitionCount();
        if (this$defSubPartitionCount == null ? other$defSubPartitionCount != null : !((Object)this$defSubPartitionCount).equals(other$defSubPartitionCount)) {
            return false;
        }
        Integer this$partitioningKeyCount = this.getPartitioningKeyCount();
        Integer other$partitioningKeyCount = other.getPartitioningKeyCount();
        if (this$partitioningKeyCount == null ? other$partitioningKeyCount != null : !((Object)this$partitioningKeyCount).equals(other$partitioningKeyCount)) {
            return false;
        }
        Integer this$subPartitioningKeyCount = this.getSubPartitioningKeyCount();
        Integer other$subPartitioningKeyCount = other.getSubPartitioningKeyCount();
        if (this$subPartitioningKeyCount == null ? other$subPartitioningKeyCount != null : !((Object)this$subPartitioningKeyCount).equals(other$subPartitioningKeyCount)) {
            return false;
        }
        Integer this$defPctFree = this.getDefPctFree();
        Integer other$defPctFree = other.getDefPctFree();
        if (this$defPctFree == null ? other$defPctFree != null : !((Object)this$defPctFree).equals(other$defPctFree)) {
            return false;
        }
        Integer this$defPctUsed = this.getDefPctUsed();
        Integer other$defPctUsed = other.getDefPctUsed();
        if (this$defPctUsed == null ? other$defPctUsed != null : !((Object)this$defPctUsed).equals(other$defPctUsed)) {
            return false;
        }
        Integer this$defIniTrans = this.getDefIniTrans();
        Integer other$defIniTrans = other.getDefIniTrans();
        if (this$defIniTrans == null ? other$defIniTrans != null : !((Object)this$defIniTrans).equals(other$defIniTrans)) {
            return false;
        }
        Integer this$defMaxTrans = this.getDefMaxTrans();
        Integer other$defMaxTrans = other.getDefMaxTrans();
        if (this$defMaxTrans == null ? other$defMaxTrans != null : !((Object)this$defMaxTrans).equals(other$defMaxTrans)) {
            return false;
        }
        Integer this$defFreeLists = this.getDefFreeLists();
        Integer other$defFreeLists = other.getDefFreeLists();
        if (this$defFreeLists == null ? other$defFreeLists != null : !((Object)this$defFreeLists).equals(other$defFreeLists)) {
            return false;
        }
        Integer this$defFreeListGroups = this.getDefFreeListGroups();
        Integer other$defFreeListGroups = other.getDefFreeListGroups();
        if (this$defFreeListGroups == null ? other$defFreeListGroups != null : !((Object)this$defFreeListGroups).equals(other$defFreeListGroups)) {
            return false;
        }
        Collection<OracleTablePartitionItem> this$tablePartitions = this.getTablePartitions();
        Collection<OracleTablePartitionItem> other$tablePartitions = other.getTablePartitions();
        if (this$tablePartitions == null ? other$tablePartitions != null : !((Object)this$tablePartitions).equals(other$tablePartitions)) {
            return false;
        }
        Collection<OracleTablePartitionColumn> this$tablePartitionColumns = this.getTablePartitionColumns();
        Collection<OracleTablePartitionColumn> other$tablePartitionColumns = other.getTablePartitionColumns();
        if (this$tablePartitionColumns == null ? other$tablePartitionColumns != null : !((Object)this$tablePartitionColumns).equals(other$tablePartitionColumns)) {
            return false;
        }
        Collection<OracleTablePartitionColumn> this$tableSubPartitionColumns = this.getTableSubPartitionColumns();
        Collection<OracleTablePartitionColumn> other$tableSubPartitionColumns = other.getTableSubPartitionColumns();
        if (this$tableSubPartitionColumns == null ? other$tableSubPartitionColumns != null : !((Object)this$tableSubPartitionColumns).equals(other$tableSubPartitionColumns)) {
            return false;
        }
        Collection<OracleTablePartitionTemplate> this$tablePartitionTemplates = this.getTablePartitionTemplates();
        Collection<OracleTablePartitionTemplate> other$tablePartitionTemplates = other.getTablePartitionTemplates();
        if (this$tablePartitionTemplates == null ? other$tablePartitionTemplates != null : !((Object)this$tablePartitionTemplates).equals(other$tablePartitionTemplates)) {
            return false;
        }
        Map<String, List<OracleTablePartitionItem>> this$tableSubPartitionMapping = this.getTableSubPartitionMapping();
        Map<String, List<OracleTablePartitionItem>> other$tableSubPartitionMapping = other.getTableSubPartitionMapping();
        if (this$tableSubPartitionMapping == null ? other$tableSubPartitionMapping != null : !((Object)this$tableSubPartitionMapping).equals(other$tableSubPartitionMapping)) {
            return false;
        }
        String this$partitioningType = this.getPartitioningType();
        String other$partitioningType = other.getPartitioningType();
        if (this$partitioningType == null ? other$partitioningType != null : !this$partitioningType.equals(other$partitioningType)) {
            return false;
        }
        String this$subPartitioningType = this.getSubPartitioningType();
        String other$subPartitioningType = other.getSubPartitioningType();
        if (this$subPartitioningType == null ? other$subPartitioningType != null : !this$subPartitioningType.equals(other$subPartitioningType)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$defTablespaceName = this.getDefTablespaceName();
        String other$defTablespaceName = other.getDefTablespaceName();
        if (this$defTablespaceName == null ? other$defTablespaceName != null : !this$defTablespaceName.equals(other$defTablespaceName)) {
            return false;
        }
        String this$defInitialExtent = this.getDefInitialExtent();
        String other$defInitialExtent = other.getDefInitialExtent();
        if (this$defInitialExtent == null ? other$defInitialExtent != null : !this$defInitialExtent.equals(other$defInitialExtent)) {
            return false;
        }
        String this$defNextExtent = this.getDefNextExtent();
        String other$defNextExtent = other.getDefNextExtent();
        if (this$defNextExtent == null ? other$defNextExtent != null : !this$defNextExtent.equals(other$defNextExtent)) {
            return false;
        }
        String this$defMinExtents = this.getDefMinExtents();
        String other$defMinExtents = other.getDefMinExtents();
        if (this$defMinExtents == null ? other$defMinExtents != null : !this$defMinExtents.equals(other$defMinExtents)) {
            return false;
        }
        String this$defMaxExtents = this.getDefMaxExtents();
        String other$defMaxExtents = other.getDefMaxExtents();
        if (this$defMaxExtents == null ? other$defMaxExtents != null : !this$defMaxExtents.equals(other$defMaxExtents)) {
            return false;
        }
        String this$defMaxSize = this.getDefMaxSize();
        String other$defMaxSize = other.getDefMaxSize();
        if (this$defMaxSize == null ? other$defMaxSize != null : !this$defMaxSize.equals(other$defMaxSize)) {
            return false;
        }
        String this$defPctIncrease = this.getDefPctIncrease();
        String other$defPctIncrease = other.getDefPctIncrease();
        if (this$defPctIncrease == null ? other$defPctIncrease != null : !this$defPctIncrease.equals(other$defPctIncrease)) {
            return false;
        }
        String this$defLogging = this.getDefLogging();
        String other$defLogging = other.getDefLogging();
        if (this$defLogging == null ? other$defLogging != null : !this$defLogging.equals(other$defLogging)) {
            return false;
        }
        String this$defCompression = this.getDefCompression();
        String other$defCompression = other.getDefCompression();
        if (this$defCompression == null ? other$defCompression != null : !this$defCompression.equals(other$defCompression)) {
            return false;
        }
        String this$defCompressFor = this.getDefCompressFor();
        String other$defCompressFor = other.getDefCompressFor();
        if (this$defCompressFor == null ? other$defCompressFor != null : !this$defCompressFor.equals(other$defCompressFor)) {
            return false;
        }
        String this$defBufferPool = this.getDefBufferPool();
        String other$defBufferPool = other.getDefBufferPool();
        if (this$defBufferPool == null ? other$defBufferPool != null : !this$defBufferPool.equals(other$defBufferPool)) {
            return false;
        }
        String this$defFlashCache = this.getDefFlashCache();
        String other$defFlashCache = other.getDefFlashCache();
        if (this$defFlashCache == null ? other$defFlashCache != null : !this$defFlashCache.equals(other$defFlashCache)) {
            return false;
        }
        String this$defCellFlashCache = this.getDefCellFlashCache();
        String other$defCellFlashCache = other.getDefCellFlashCache();
        if (this$defCellFlashCache == null ? other$defCellFlashCache != null : !this$defCellFlashCache.equals(other$defCellFlashCache)) {
            return false;
        }
        String this$refPtnConstraintName = this.getRefPtnConstraintName();
        String other$refPtnConstraintName = other.getRefPtnConstraintName();
        if (this$refPtnConstraintName == null ? other$refPtnConstraintName != null : !this$refPtnConstraintName.equals(other$refPtnConstraintName)) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
            return false;
        }
        String this$isNested = this.getIsNested();
        String other$isNested = other.getIsNested();
        if (this$isNested == null ? other$isNested != null : !this$isNested.equals(other$isNested)) {
            return false;
        }
        String this$defSegmentCreation = this.getDefSegmentCreation();
        String other$defSegmentCreation = other.getDefSegmentCreation();
        return !(this$defSegmentCreation == null ? other$defSegmentCreation != null : !this$defSegmentCreation.equals(other$defSegmentCreation));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObOracleTablePartition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $partitionCount = this.getPartitionCount();
        result = result * 59 + ($partitionCount == null ? 43 : ((Object)$partitionCount).hashCode());
        Integer $defSubPartitionCount = this.getDefSubPartitionCount();
        result = result * 59 + ($defSubPartitionCount == null ? 43 : ((Object)$defSubPartitionCount).hashCode());
        Integer $partitioningKeyCount = this.getPartitioningKeyCount();
        result = result * 59 + ($partitioningKeyCount == null ? 43 : ((Object)$partitioningKeyCount).hashCode());
        Integer $subPartitioningKeyCount = this.getSubPartitioningKeyCount();
        result = result * 59 + ($subPartitioningKeyCount == null ? 43 : ((Object)$subPartitioningKeyCount).hashCode());
        Integer $defPctFree = this.getDefPctFree();
        result = result * 59 + ($defPctFree == null ? 43 : ((Object)$defPctFree).hashCode());
        Integer $defPctUsed = this.getDefPctUsed();
        result = result * 59 + ($defPctUsed == null ? 43 : ((Object)$defPctUsed).hashCode());
        Integer $defIniTrans = this.getDefIniTrans();
        result = result * 59 + ($defIniTrans == null ? 43 : ((Object)$defIniTrans).hashCode());
        Integer $defMaxTrans = this.getDefMaxTrans();
        result = result * 59 + ($defMaxTrans == null ? 43 : ((Object)$defMaxTrans).hashCode());
        Integer $defFreeLists = this.getDefFreeLists();
        result = result * 59 + ($defFreeLists == null ? 43 : ((Object)$defFreeLists).hashCode());
        Integer $defFreeListGroups = this.getDefFreeListGroups();
        result = result * 59 + ($defFreeListGroups == null ? 43 : ((Object)$defFreeListGroups).hashCode());
        Collection<OracleTablePartitionItem> $tablePartitions = this.getTablePartitions();
        result = result * 59 + ($tablePartitions == null ? 43 : ((Object)$tablePartitions).hashCode());
        Collection<OracleTablePartitionColumn> $tablePartitionColumns = this.getTablePartitionColumns();
        result = result * 59 + ($tablePartitionColumns == null ? 43 : ((Object)$tablePartitionColumns).hashCode());
        Collection<OracleTablePartitionColumn> $tableSubPartitionColumns = this.getTableSubPartitionColumns();
        result = result * 59 + ($tableSubPartitionColumns == null ? 43 : ((Object)$tableSubPartitionColumns).hashCode());
        Collection<OracleTablePartitionTemplate> $tablePartitionTemplates = this.getTablePartitionTemplates();
        result = result * 59 + ($tablePartitionTemplates == null ? 43 : ((Object)$tablePartitionTemplates).hashCode());
        Map<String, List<OracleTablePartitionItem>> $tableSubPartitionMapping = this.getTableSubPartitionMapping();
        result = result * 59 + ($tableSubPartitionMapping == null ? 43 : ((Object)$tableSubPartitionMapping).hashCode());
        String $partitioningType = this.getPartitioningType();
        result = result * 59 + ($partitioningType == null ? 43 : $partitioningType.hashCode());
        String $subPartitioningType = this.getSubPartitioningType();
        result = result * 59 + ($subPartitioningType == null ? 43 : $subPartitioningType.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $defTablespaceName = this.getDefTablespaceName();
        result = result * 59 + ($defTablespaceName == null ? 43 : $defTablespaceName.hashCode());
        String $defInitialExtent = this.getDefInitialExtent();
        result = result * 59 + ($defInitialExtent == null ? 43 : $defInitialExtent.hashCode());
        String $defNextExtent = this.getDefNextExtent();
        result = result * 59 + ($defNextExtent == null ? 43 : $defNextExtent.hashCode());
        String $defMinExtents = this.getDefMinExtents();
        result = result * 59 + ($defMinExtents == null ? 43 : $defMinExtents.hashCode());
        String $defMaxExtents = this.getDefMaxExtents();
        result = result * 59 + ($defMaxExtents == null ? 43 : $defMaxExtents.hashCode());
        String $defMaxSize = this.getDefMaxSize();
        result = result * 59 + ($defMaxSize == null ? 43 : $defMaxSize.hashCode());
        String $defPctIncrease = this.getDefPctIncrease();
        result = result * 59 + ($defPctIncrease == null ? 43 : $defPctIncrease.hashCode());
        String $defLogging = this.getDefLogging();
        result = result * 59 + ($defLogging == null ? 43 : $defLogging.hashCode());
        String $defCompression = this.getDefCompression();
        result = result * 59 + ($defCompression == null ? 43 : $defCompression.hashCode());
        String $defCompressFor = this.getDefCompressFor();
        result = result * 59 + ($defCompressFor == null ? 43 : $defCompressFor.hashCode());
        String $defBufferPool = this.getDefBufferPool();
        result = result * 59 + ($defBufferPool == null ? 43 : $defBufferPool.hashCode());
        String $defFlashCache = this.getDefFlashCache();
        result = result * 59 + ($defFlashCache == null ? 43 : $defFlashCache.hashCode());
        String $defCellFlashCache = this.getDefCellFlashCache();
        result = result * 59 + ($defCellFlashCache == null ? 43 : $defCellFlashCache.hashCode());
        String $refPtnConstraintName = this.getRefPtnConstraintName();
        result = result * 59 + ($refPtnConstraintName == null ? 43 : $refPtnConstraintName.hashCode());
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        String $isNested = this.getIsNested();
        result = result * 59 + ($isNested == null ? 43 : $isNested.hashCode());
        String $defSegmentCreation = this.getDefSegmentCreation();
        result = result * 59 + ($defSegmentCreation == null ? 43 : $defSegmentCreation.hashCode());
        return result;
    }

    public Collection<OracleTablePartitionItem> getTablePartitions() {
        return this.tablePartitions;
    }

    public Collection<OracleTablePartitionColumn> getTablePartitionColumns() {
        return this.tablePartitionColumns;
    }

    public Collection<OracleTablePartitionColumn> getTableSubPartitionColumns() {
        return this.tableSubPartitionColumns;
    }

    public Collection<OracleTablePartitionTemplate> getTablePartitionTemplates() {
        return this.tablePartitionTemplates;
    }

    public Map<String, List<OracleTablePartitionItem>> getTableSubPartitionMapping() {
        return this.tableSubPartitionMapping;
    }

    public String getPartitioningType() {
        return this.partitioningType;
    }

    public void setPartitioningType(String partitioningType) {
        this.partitioningType = partitioningType;
    }

    public String getSubPartitioningType() {
        return this.subPartitioningType;
    }

    public void setSubPartitioningType(String subPartitioningType) {
        this.subPartitioningType = subPartitioningType;
    }

    public Integer getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
    }

    public Integer getDefSubPartitionCount() {
        return this.defSubPartitionCount;
    }

    public void setDefSubPartitionCount(Integer defSubPartitionCount) {
        this.defSubPartitionCount = defSubPartitionCount;
    }

    public Integer getPartitioningKeyCount() {
        return this.partitioningKeyCount;
    }

    public void setPartitioningKeyCount(Integer partitioningKeyCount) {
        this.partitioningKeyCount = partitioningKeyCount;
    }

    public Integer getSubPartitioningKeyCount() {
        return this.subPartitioningKeyCount;
    }

    public void setSubPartitioningKeyCount(Integer subPartitioningKeyCount) {
        this.subPartitioningKeyCount = subPartitioningKeyCount;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDefTablespaceName() {
        return this.defTablespaceName;
    }

    public void setDefTablespaceName(String defTablespaceName) {
        this.defTablespaceName = defTablespaceName;
    }

    public Integer getDefPctFree() {
        return this.defPctFree;
    }

    public void setDefPctFree(Integer defPctFree) {
        this.defPctFree = defPctFree;
    }

    public Integer getDefPctUsed() {
        return this.defPctUsed;
    }

    public void setDefPctUsed(Integer defPctUsed) {
        this.defPctUsed = defPctUsed;
    }

    public Integer getDefIniTrans() {
        return this.defIniTrans;
    }

    public void setDefIniTrans(Integer defIniTrans) {
        this.defIniTrans = defIniTrans;
    }

    public Integer getDefMaxTrans() {
        return this.defMaxTrans;
    }

    public void setDefMaxTrans(Integer defMaxTrans) {
        this.defMaxTrans = defMaxTrans;
    }

    public String getDefInitialExtent() {
        return this.defInitialExtent;
    }

    public void setDefInitialExtent(String defInitialExtent) {
        this.defInitialExtent = defInitialExtent;
    }

    public String getDefNextExtent() {
        return this.defNextExtent;
    }

    public void setDefNextExtent(String defNextExtent) {
        this.defNextExtent = defNextExtent;
    }

    public String getDefMinExtents() {
        return this.defMinExtents;
    }

    public void setDefMinExtents(String defMinExtents) {
        this.defMinExtents = defMinExtents;
    }

    public String getDefMaxExtents() {
        return this.defMaxExtents;
    }

    public void setDefMaxExtents(String defMaxExtents) {
        this.defMaxExtents = defMaxExtents;
    }

    public String getDefMaxSize() {
        return this.defMaxSize;
    }

    public void setDefMaxSize(String defMaxSize) {
        this.defMaxSize = defMaxSize;
    }

    public String getDefPctIncrease() {
        return this.defPctIncrease;
    }

    public void setDefPctIncrease(String defPctIncrease) {
        this.defPctIncrease = defPctIncrease;
    }

    public Integer getDefFreeLists() {
        return this.defFreeLists;
    }

    public void setDefFreeLists(Integer defFreeLists) {
        this.defFreeLists = defFreeLists;
    }

    public Integer getDefFreeListGroups() {
        return this.defFreeListGroups;
    }

    public void setDefFreeListGroups(Integer defFreeListGroups) {
        this.defFreeListGroups = defFreeListGroups;
    }

    public String getDefLogging() {
        return this.defLogging;
    }

    public void setDefLogging(String defLogging) {
        this.defLogging = defLogging;
    }

    public String getDefCompression() {
        return this.defCompression;
    }

    public void setDefCompression(String defCompression) {
        this.defCompression = defCompression;
    }

    public String getDefCompressFor() {
        return this.defCompressFor;
    }

    public void setDefCompressFor(String defCompressFor) {
        this.defCompressFor = defCompressFor;
    }

    public String getDefBufferPool() {
        return this.defBufferPool;
    }

    public void setDefBufferPool(String defBufferPool) {
        this.defBufferPool = defBufferPool;
    }

    public String getDefFlashCache() {
        return this.defFlashCache;
    }

    public void setDefFlashCache(String defFlashCache) {
        this.defFlashCache = defFlashCache;
    }

    public String getDefCellFlashCache() {
        return this.defCellFlashCache;
    }

    public void setDefCellFlashCache(String defCellFlashCache) {
        this.defCellFlashCache = defCellFlashCache;
    }

    public String getRefPtnConstraintName() {
        return this.refPtnConstraintName;
    }

    public void setRefPtnConstraintName(String refPtnConstraintName) {
        this.refPtnConstraintName = refPtnConstraintName;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public String getIsNested() {
        return this.isNested;
    }

    public void setIsNested(String isNested) {
        this.isNested = isNested;
    }

    public String getDefSegmentCreation() {
        return this.defSegmentCreation;
    }

    public void setDefSegmentCreation(String defSegmentCreation) {
        this.defSegmentCreation = defSegmentCreation;
    }

    public static class OracleTablePartitionItem {
        private String tableName;
        private String composite;
        private String partitionName;
        private Integer subPartitionCount;
        private String subPartitionName;
        private String highValue;
        private Integer highValueLength;
        private Integer partitionPosition;
        private String tablespaceName;
        private Integer pctFree;
        private Integer pctUsed;
        private Integer iniTrans;
        private Integer maxTrans;
        private Integer initialExtent;
        private Integer nextExtent;
        private Integer minExtent;
        private Integer maxExtent;
        private Integer maxSize;
        private Integer pctIncrease;
        private Integer freeLists;
        private Integer freeListGroups;
        private String logging;
        private String compression;
        private String compressFor;
        private Integer numRows;
        private Integer blocks;
        private Integer emptyBlocks;
        private Integer avgSpace;
        private Integer chainCnt;
        private Integer avgRowLen;
        private Integer sampleSize;
        private Date lastAnalyzed;
        private String bufferPool;
        private String flashCache;
        private String cellFlashCache;
        private String globalStats;
        private String userStats;
        private String isNested;
        private String parentTablePartition;
        private String interval;
        private String segmentCreated;
        private String generated;

        public String getUniformHighValue() {
            if (this.getHighValue() == null) {
                return "High value is null";
            }
            return Arrays.stream(this.getHighValue().split(",")).filter(e -> e != null).map(e -> {
                if ((e = e.trim()).startsWith("'") && e.endsWith("'")) {
                    return e;
                }
                return "'" + e + "'";
            }).collect(Collectors.joining(","));
        }

        public int hashCode() {
            if (this.partitionPosition == null || this.partitionPosition < 0) {
                return Objects.hash(this.partitionName, this.partitionPosition);
            }
            return Objects.hash(this.partitionPosition);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OracleTablePartitionItem other = (OracleTablePartitionItem)obj;
            if (this.partitionPosition == null || this.partitionPosition < 0) {
                return Objects.deepEquals(other.partitionName, this.partitionName) && Objects.deepEquals(other.partitionPosition, this.partitionPosition);
            }
            return Objects.deepEquals(other.partitionPosition, this.partitionPosition);
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getComposite() {
            return this.composite;
        }

        public void setComposite(String composite) {
            this.composite = composite;
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public Integer getSubPartitionCount() {
            return this.subPartitionCount;
        }

        public void setSubPartitionCount(Integer subPartitionCount) {
            this.subPartitionCount = subPartitionCount;
        }

        public String getSubPartitionName() {
            return this.subPartitionName;
        }

        public void setSubPartitionName(String subPartitionName) {
            this.subPartitionName = subPartitionName;
        }

        public String getHighValue() {
            return this.highValue;
        }

        public void setHighValue(String highValue) {
            this.highValue = highValue;
        }

        public Integer getHighValueLength() {
            return this.highValueLength;
        }

        public void setHighValueLength(Integer highValueLength) {
            this.highValueLength = highValueLength;
        }

        public Integer getPartitionPosition() {
            return this.partitionPosition;
        }

        public void setPartitionPosition(Integer partitionPosition) {
            this.partitionPosition = partitionPosition;
        }

        public String getTablespaceName() {
            return this.tablespaceName;
        }

        public void setTablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
        }

        public Integer getPctFree() {
            return this.pctFree;
        }

        public void setPctFree(Integer pctFree) {
            this.pctFree = pctFree;
        }

        public Integer getPctUsed() {
            return this.pctUsed;
        }

        public void setPctUsed(Integer pctUsed) {
            this.pctUsed = pctUsed;
        }

        public Integer getIniTrans() {
            return this.iniTrans;
        }

        public void setIniTrans(Integer iniTrans) {
            this.iniTrans = iniTrans;
        }

        public Integer getMaxTrans() {
            return this.maxTrans;
        }

        public void setMaxTrans(Integer maxTrans) {
            this.maxTrans = maxTrans;
        }

        public Integer getInitialExtent() {
            return this.initialExtent;
        }

        public void setInitialExtent(Integer initialExtent) {
            this.initialExtent = initialExtent;
        }

        public Integer getNextExtent() {
            return this.nextExtent;
        }

        public void setNextExtent(Integer nextExtent) {
            this.nextExtent = nextExtent;
        }

        public Integer getMinExtent() {
            return this.minExtent;
        }

        public void setMinExtent(Integer minExtent) {
            this.minExtent = minExtent;
        }

        public Integer getMaxExtent() {
            return this.maxExtent;
        }

        public void setMaxExtent(Integer maxExtent) {
            this.maxExtent = maxExtent;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public Integer getPctIncrease() {
            return this.pctIncrease;
        }

        public void setPctIncrease(Integer pctIncrease) {
            this.pctIncrease = pctIncrease;
        }

        public Integer getFreeLists() {
            return this.freeLists;
        }

        public void setFreeLists(Integer freeLists) {
            this.freeLists = freeLists;
        }

        public Integer getFreeListGroups() {
            return this.freeListGroups;
        }

        public void setFreeListGroups(Integer freeListGroups) {
            this.freeListGroups = freeListGroups;
        }

        public String getLogging() {
            return this.logging;
        }

        public void setLogging(String logging) {
            this.logging = logging;
        }

        public String getCompression() {
            return this.compression;
        }

        public void setCompression(String compression) {
            this.compression = compression;
        }

        public String getCompressFor() {
            return this.compressFor;
        }

        public void setCompressFor(String compressFor) {
            this.compressFor = compressFor;
        }

        public Integer getNumRows() {
            return this.numRows;
        }

        public void setNumRows(Integer numRows) {
            this.numRows = numRows;
        }

        public Integer getBlocks() {
            return this.blocks;
        }

        public void setBlocks(Integer blocks) {
            this.blocks = blocks;
        }

        public Integer getEmptyBlocks() {
            return this.emptyBlocks;
        }

        public void setEmptyBlocks(Integer emptyBlocks) {
            this.emptyBlocks = emptyBlocks;
        }

        public Integer getAvgSpace() {
            return this.avgSpace;
        }

        public void setAvgSpace(Integer avgSpace) {
            this.avgSpace = avgSpace;
        }

        public Integer getChainCnt() {
            return this.chainCnt;
        }

        public void setChainCnt(Integer chainCnt) {
            this.chainCnt = chainCnt;
        }

        public Integer getAvgRowLen() {
            return this.avgRowLen;
        }

        public void setAvgRowLen(Integer avgRowLen) {
            this.avgRowLen = avgRowLen;
        }

        public Integer getSampleSize() {
            return this.sampleSize;
        }

        public void setSampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
        }

        public Date getLastAnalyzed() {
            return this.lastAnalyzed;
        }

        public void setLastAnalyzed(Date lastAnalyzed) {
            this.lastAnalyzed = lastAnalyzed;
        }

        public String getBufferPool() {
            return this.bufferPool;
        }

        public void setBufferPool(String bufferPool) {
            this.bufferPool = bufferPool;
        }

        public String getFlashCache() {
            return this.flashCache;
        }

        public void setFlashCache(String flashCache) {
            this.flashCache = flashCache;
        }

        public String getCellFlashCache() {
            return this.cellFlashCache;
        }

        public void setCellFlashCache(String cellFlashCache) {
            this.cellFlashCache = cellFlashCache;
        }

        public String getGlobalStats() {
            return this.globalStats;
        }

        public void setGlobalStats(String globalStats) {
            this.globalStats = globalStats;
        }

        public String getUserStats() {
            return this.userStats;
        }

        public void setUserStats(String userStats) {
            this.userStats = userStats;
        }

        public String getIsNested() {
            return this.isNested;
        }

        public void setIsNested(String isNested) {
            this.isNested = isNested;
        }

        public String getParentTablePartition() {
            return this.parentTablePartition;
        }

        public void setParentTablePartition(String parentTablePartition) {
            this.parentTablePartition = parentTablePartition;
        }

        public String getInterval() {
            return this.interval;
        }

        public void setInterval(String interval) {
            this.interval = interval;
        }

        public String getSegmentCreated() {
            return this.segmentCreated;
        }

        public void setSegmentCreated(String segmentCreated) {
            this.segmentCreated = segmentCreated;
        }

        public String getGenerated() {
            return this.generated;
        }

        public void setGenerated(String generated) {
            this.generated = generated;
        }
    }

    public static class OracleTablePartitionTemplate {
        private String subPartitionName;
        private Integer subPartitionPosition;
        private String tablespaceName;
        private String highBound;
        private String compression;
        private String indexing;
        private String readOnly;

        public String getSubPartitionName() {
            return this.subPartitionName;
        }

        public void setSubPartitionName(String subPartitionName) {
            this.subPartitionName = subPartitionName;
        }

        public Integer getSubPartitionPosition() {
            return this.subPartitionPosition;
        }

        public void setSubPartitionPosition(Integer subPartitionPosition) {
            this.subPartitionPosition = subPartitionPosition;
        }

        public String getTablespaceName() {
            return this.tablespaceName;
        }

        public void setTablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
        }

        public String getHighBound() {
            return this.highBound;
        }

        public void setHighBound(String highBound) {
            this.highBound = highBound;
        }

        public String getCompression() {
            return this.compression;
        }

        public void setCompression(String compression) {
            this.compression = compression;
        }

        public String getIndexing() {
            return this.indexing;
        }

        public void setIndexing(String indexing) {
            this.indexing = indexing;
        }

        public String getReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(String readOnly) {
            this.readOnly = readOnly;
        }
    }

    public static class OracleTablePartitionColumn {
        private String name;
        private String objectType;
        private String columnName;
        private Integer columnPosition;
        private Integer collatedColumnId;
        private boolean isExpression;

        public OracleTablePartitionColumn(String columnName) {
            this.columnName = columnName;
        }

        public OracleTablePartitionColumn() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public Integer getColumnPosition() {
            return this.columnPosition;
        }

        public void setColumnPosition(Integer columnPosition) {
            this.columnPosition = columnPosition;
        }

        public Integer getCollatedColumnId() {
            return this.collatedColumnId;
        }

        public void setCollatedColumnId(Integer collatedColumnId) {
            this.collatedColumnId = collatedColumnId;
        }

        public boolean isExpression() {
            return this.isExpression;
        }

        public void setExpression(boolean isExpression) {
            this.isExpression = isExpression;
        }
    }
}

