/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractTablespace;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import java.util.ArrayList;
import java.util.List;

public class ObOracleTablespace
extends AbstractTablespace {
    private final List<FileSpecification> fileSpecifications = new ArrayList<FileSpecification>();
    private Long blockSize;
    private Long initialExtent;
    private Long nextExtent;
    private Long minExtents;
    private Long maxExtents;
    private Long maxSize;
    private Long pctIncrease;
    private Long minExtlen;
    private String status;
    private String contents;
    private String logging;
    private String forceLogging;
    private String extentManagement;
    private String allocationType;
    private String pluggedIn;
    private String segmentSpaceManagement;
    private String defTabCompression;
    private String retention;
    private String bigfile;
    private String predicateEvaluation;
    private String encrypted;
    private String compressFor;
    private String groupName;

    public ObOracleTablespace(ObOracleSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String objectName = this.getObjectName();
        sb.append("CREATE TABLESPACE ").append(objectName);
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLESPACE, objectName, this.terminate(sb))});
    }

    public ObOracleTablespace() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleTablespace)) {
            return false;
        }
        ObOracleTablespace other = (ObOracleTablespace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$blockSize = this.getBlockSize();
        Long other$blockSize = other.getBlockSize();
        if (this$blockSize == null ? other$blockSize != null : !((Object)this$blockSize).equals(other$blockSize)) {
            return false;
        }
        Long this$initialExtent = this.getInitialExtent();
        Long other$initialExtent = other.getInitialExtent();
        if (this$initialExtent == null ? other$initialExtent != null : !((Object)this$initialExtent).equals(other$initialExtent)) {
            return false;
        }
        Long this$nextExtent = this.getNextExtent();
        Long other$nextExtent = other.getNextExtent();
        if (this$nextExtent == null ? other$nextExtent != null : !((Object)this$nextExtent).equals(other$nextExtent)) {
            return false;
        }
        Long this$minExtents = this.getMinExtents();
        Long other$minExtents = other.getMinExtents();
        if (this$minExtents == null ? other$minExtents != null : !((Object)this$minExtents).equals(other$minExtents)) {
            return false;
        }
        Long this$maxExtents = this.getMaxExtents();
        Long other$maxExtents = other.getMaxExtents();
        if (this$maxExtents == null ? other$maxExtents != null : !((Object)this$maxExtents).equals(other$maxExtents)) {
            return false;
        }
        Long this$maxSize = this.getMaxSize();
        Long other$maxSize = other.getMaxSize();
        if (this$maxSize == null ? other$maxSize != null : !((Object)this$maxSize).equals(other$maxSize)) {
            return false;
        }
        Long this$pctIncrease = this.getPctIncrease();
        Long other$pctIncrease = other.getPctIncrease();
        if (this$pctIncrease == null ? other$pctIncrease != null : !((Object)this$pctIncrease).equals(other$pctIncrease)) {
            return false;
        }
        Long this$minExtlen = this.getMinExtlen();
        Long other$minExtlen = other.getMinExtlen();
        if (this$minExtlen == null ? other$minExtlen != null : !((Object)this$minExtlen).equals(other$minExtlen)) {
            return false;
        }
        List<FileSpecification> this$fileSpecifications = this.getFileSpecifications();
        List<FileSpecification> other$fileSpecifications = other.getFileSpecifications();
        if (this$fileSpecifications == null ? other$fileSpecifications != null : !((Object)this$fileSpecifications).equals(other$fileSpecifications)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$contents = this.getContents();
        String other$contents = other.getContents();
        if (this$contents == null ? other$contents != null : !this$contents.equals(other$contents)) {
            return false;
        }
        String this$logging = this.getLogging();
        String other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !this$logging.equals(other$logging)) {
            return false;
        }
        String this$forceLogging = this.getForceLogging();
        String other$forceLogging = other.getForceLogging();
        if (this$forceLogging == null ? other$forceLogging != null : !this$forceLogging.equals(other$forceLogging)) {
            return false;
        }
        String this$extentManagement = this.getExtentManagement();
        String other$extentManagement = other.getExtentManagement();
        if (this$extentManagement == null ? other$extentManagement != null : !this$extentManagement.equals(other$extentManagement)) {
            return false;
        }
        String this$allocationType = this.getAllocationType();
        String other$allocationType = other.getAllocationType();
        if (this$allocationType == null ? other$allocationType != null : !this$allocationType.equals(other$allocationType)) {
            return false;
        }
        String this$pluggedIn = this.getPluggedIn();
        String other$pluggedIn = other.getPluggedIn();
        if (this$pluggedIn == null ? other$pluggedIn != null : !this$pluggedIn.equals(other$pluggedIn)) {
            return false;
        }
        String this$segmentSpaceManagement = this.getSegmentSpaceManagement();
        String other$segmentSpaceManagement = other.getSegmentSpaceManagement();
        if (this$segmentSpaceManagement == null ? other$segmentSpaceManagement != null : !this$segmentSpaceManagement.equals(other$segmentSpaceManagement)) {
            return false;
        }
        String this$defTabCompression = this.getDefTabCompression();
        String other$defTabCompression = other.getDefTabCompression();
        if (this$defTabCompression == null ? other$defTabCompression != null : !this$defTabCompression.equals(other$defTabCompression)) {
            return false;
        }
        String this$retention = this.getRetention();
        String other$retention = other.getRetention();
        if (this$retention == null ? other$retention != null : !this$retention.equals(other$retention)) {
            return false;
        }
        String this$bigfile = this.getBigfile();
        String other$bigfile = other.getBigfile();
        if (this$bigfile == null ? other$bigfile != null : !this$bigfile.equals(other$bigfile)) {
            return false;
        }
        String this$predicateEvaluation = this.getPredicateEvaluation();
        String other$predicateEvaluation = other.getPredicateEvaluation();
        if (this$predicateEvaluation == null ? other$predicateEvaluation != null : !this$predicateEvaluation.equals(other$predicateEvaluation)) {
            return false;
        }
        String this$encrypted = this.getEncrypted();
        String other$encrypted = other.getEncrypted();
        if (this$encrypted == null ? other$encrypted != null : !this$encrypted.equals(other$encrypted)) {
            return false;
        }
        String this$compressFor = this.getCompressFor();
        String other$compressFor = other.getCompressFor();
        if (this$compressFor == null ? other$compressFor != null : !this$compressFor.equals(other$compressFor)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        return !(this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObOracleTablespace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $blockSize = this.getBlockSize();
        result = result * 59 + ($blockSize == null ? 43 : ((Object)$blockSize).hashCode());
        Long $initialExtent = this.getInitialExtent();
        result = result * 59 + ($initialExtent == null ? 43 : ((Object)$initialExtent).hashCode());
        Long $nextExtent = this.getNextExtent();
        result = result * 59 + ($nextExtent == null ? 43 : ((Object)$nextExtent).hashCode());
        Long $minExtents = this.getMinExtents();
        result = result * 59 + ($minExtents == null ? 43 : ((Object)$minExtents).hashCode());
        Long $maxExtents = this.getMaxExtents();
        result = result * 59 + ($maxExtents == null ? 43 : ((Object)$maxExtents).hashCode());
        Long $maxSize = this.getMaxSize();
        result = result * 59 + ($maxSize == null ? 43 : ((Object)$maxSize).hashCode());
        Long $pctIncrease = this.getPctIncrease();
        result = result * 59 + ($pctIncrease == null ? 43 : ((Object)$pctIncrease).hashCode());
        Long $minExtlen = this.getMinExtlen();
        result = result * 59 + ($minExtlen == null ? 43 : ((Object)$minExtlen).hashCode());
        List<FileSpecification> $fileSpecifications = this.getFileSpecifications();
        result = result * 59 + ($fileSpecifications == null ? 43 : ((Object)$fileSpecifications).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : $contents.hashCode());
        String $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : $logging.hashCode());
        String $forceLogging = this.getForceLogging();
        result = result * 59 + ($forceLogging == null ? 43 : $forceLogging.hashCode());
        String $extentManagement = this.getExtentManagement();
        result = result * 59 + ($extentManagement == null ? 43 : $extentManagement.hashCode());
        String $allocationType = this.getAllocationType();
        result = result * 59 + ($allocationType == null ? 43 : $allocationType.hashCode());
        String $pluggedIn = this.getPluggedIn();
        result = result * 59 + ($pluggedIn == null ? 43 : $pluggedIn.hashCode());
        String $segmentSpaceManagement = this.getSegmentSpaceManagement();
        result = result * 59 + ($segmentSpaceManagement == null ? 43 : $segmentSpaceManagement.hashCode());
        String $defTabCompression = this.getDefTabCompression();
        result = result * 59 + ($defTabCompression == null ? 43 : $defTabCompression.hashCode());
        String $retention = this.getRetention();
        result = result * 59 + ($retention == null ? 43 : $retention.hashCode());
        String $bigfile = this.getBigfile();
        result = result * 59 + ($bigfile == null ? 43 : $bigfile.hashCode());
        String $predicateEvaluation = this.getPredicateEvaluation();
        result = result * 59 + ($predicateEvaluation == null ? 43 : $predicateEvaluation.hashCode());
        String $encrypted = this.getEncrypted();
        result = result * 59 + ($encrypted == null ? 43 : $encrypted.hashCode());
        String $compressFor = this.getCompressFor();
        result = result * 59 + ($compressFor == null ? 43 : $compressFor.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        return result;
    }

    public List<FileSpecification> getFileSpecifications() {
        return this.fileSpecifications;
    }

    public Long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Long blockSize) {
        this.blockSize = blockSize;
    }

    public Long getInitialExtent() {
        return this.initialExtent;
    }

    public void setInitialExtent(Long initialExtent) {
        this.initialExtent = initialExtent;
    }

    public Long getNextExtent() {
        return this.nextExtent;
    }

    public void setNextExtent(Long nextExtent) {
        this.nextExtent = nextExtent;
    }

    public Long getMinExtents() {
        return this.minExtents;
    }

    public void setMinExtents(Long minExtents) {
        this.minExtents = minExtents;
    }

    public Long getMaxExtents() {
        return this.maxExtents;
    }

    public void setMaxExtents(Long maxExtents) {
        this.maxExtents = maxExtents;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }

    public Long getPctIncrease() {
        return this.pctIncrease;
    }

    public void setPctIncrease(Long pctIncrease) {
        this.pctIncrease = pctIncrease;
    }

    public Long getMinExtlen() {
        return this.minExtlen;
    }

    public void setMinExtlen(Long minExtlen) {
        this.minExtlen = minExtlen;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String logging) {
        this.logging = logging;
    }

    public String getForceLogging() {
        return this.forceLogging;
    }

    public void setForceLogging(String forceLogging) {
        this.forceLogging = forceLogging;
    }

    public String getExtentManagement() {
        return this.extentManagement;
    }

    public void setExtentManagement(String extentManagement) {
        this.extentManagement = extentManagement;
    }

    public String getAllocationType() {
        return this.allocationType;
    }

    public void setAllocationType(String allocationType) {
        this.allocationType = allocationType;
    }

    public String getPluggedIn() {
        return this.pluggedIn;
    }

    public void setPluggedIn(String pluggedIn) {
        this.pluggedIn = pluggedIn;
    }

    public String getSegmentSpaceManagement() {
        return this.segmentSpaceManagement;
    }

    public void setSegmentSpaceManagement(String segmentSpaceManagement) {
        this.segmentSpaceManagement = segmentSpaceManagement;
    }

    public String getDefTabCompression() {
        return this.defTabCompression;
    }

    public void setDefTabCompression(String defTabCompression) {
        this.defTabCompression = defTabCompression;
    }

    public String getRetention() {
        return this.retention;
    }

    public void setRetention(String retention) {
        this.retention = retention;
    }

    public String getBigfile() {
        return this.bigfile;
    }

    public void setBigfile(String bigfile) {
        this.bigfile = bigfile;
    }

    public String getPredicateEvaluation() {
        return this.predicateEvaluation;
    }

    public void setPredicateEvaluation(String predicateEvaluation) {
        this.predicateEvaluation = predicateEvaluation;
    }

    public String getEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(String encrypted) {
        this.encrypted = encrypted;
    }

    public String getCompressFor() {
        return this.compressFor;
    }

    public void setCompressFor(String compressFor) {
        this.compressFor = compressFor;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public static class FileSpecification {
        private Long fileId;
        private String fileName;
        private Long bytes;
        private Long blocks;
        private String status;
        private Long relativeFno;
        private String autoExtensible;
        private Long maxBytes;
        private Long maxBlocks;
        private Long incrementBy;
        private Long userBytes;
        private Long userBlocks;
        private String onlineStatus;

        public Long getFileId() {
            return this.fileId;
        }

        public void setFileId(Long fileId) {
            this.fileId = fileId;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public Long getBytes() {
            return this.bytes;
        }

        public void setBytes(Long bytes) {
            this.bytes = bytes;
        }

        public Long getBlocks() {
            return this.blocks;
        }

        public void setBlocks(Long blocks) {
            this.blocks = blocks;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Long getRelativeFno() {
            return this.relativeFno;
        }

        public void setRelativeFno(Long relativeFno) {
            this.relativeFno = relativeFno;
        }

        public String getAutoExtensible() {
            return this.autoExtensible;
        }

        public void setAutoExtensible(String autoExtensible) {
            this.autoExtensible = autoExtensible;
        }

        public Long getMaxBytes() {
            return this.maxBytes;
        }

        public void setMaxBytes(Long maxBytes) {
            this.maxBytes = maxBytes;
        }

        public Long getMaxBlocks() {
            return this.maxBlocks;
        }

        public void setMaxBlocks(Long maxBlocks) {
            this.maxBlocks = maxBlocks;
        }

        public Long getIncrementBy() {
            return this.incrementBy;
        }

        public void setIncrementBy(Long incrementBy) {
            this.incrementBy = incrementBy;
        }

        public Long getUserBytes() {
            return this.userBytes;
        }

        public void setUserBytes(Long userBytes) {
            this.userBytes = userBytes;
        }

        public Long getUserBlocks() {
            return this.userBlocks;
        }

        public void setUserBlocks(Long userBlocks) {
            this.userBlocks = userBlocks;
        }

        public String getOnlineStatus() {
            return this.onlineStatus;
        }

        public void setOnlineStatus(String onlineStatus) {
            this.onlineStatus = onlineStatus;
        }
    }
}

