/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.security;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.utils.ArrayUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.Cipher;

public final class OpenSslDecryptor {
    private OpenSslDecryptor() {
    }

    public static String decrypt(String encryptStr, String privateKeyPath) throws Exception {
        PrivateKey privateKey = OpenSslDecryptor.generatePrivateKey(privateKeyPath);
        byte[] encryptBytes = FileUtils.readFileToByteArray((File)new File(encryptStr));
        return OpenSslDecryptor.decrypt(privateKey, encryptBytes);
    }

    private static PrivateKey generatePrivateKey(String privateKeyPath) throws Exception {
        List lines = FileUtils.readLines((File)new File(privateKeyPath), (Charset)StandardCharsets.UTF_8);
        String key = lines.stream().filter(l -> !l.startsWith("-")).collect(Collectors.joining());
        byte[] buffer = Base64.getDecoder().decode(key);
        return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(buffer));
    }

    private static String decrypt(PrivateKey privateKey, byte[] encryptBytes) throws Exception {
        Preconditions.checkArgument((privateKey != null ? 1 : 0) != 0, (Object)"Private key is null");
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((byte[])encryptBytes), (Object)"Encrypt password is null");
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return new String(cipher.doFinal(encryptBytes));
    }
}

