/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.security;

import java.util.Properties;

public final class SecureParameters {
    private transient String password;
    private transient String sysPassword;
    private transient String trustStorePassword;
    private transient String keyStorePassword;
    private transient String accessKey;
    private transient String secretKey;

    public SecureParameters() {
    }

    public SecureParameters(String password, String sysPassword, String accessKey, String secretKey) {
        this(password, sysPassword, null, null, accessKey, secretKey);
    }

    public SecureParameters(String password, String sysPassword, String trustStorePassword, String keyStorePassword, String accessKey, String secretKey) {
        this.password = password;
        this.sysPassword = sysPassword;
        this.trustStorePassword = trustStorePassword;
        this.keyStorePassword = keyStorePassword;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public static SecureParameters newInstance(Properties prop) {
        String password = prop.getProperty("oceanbase.jdbc.password");
        String sysPassword = prop.getProperty("oceanbase.jdbc.sys.password");
        String trustStorePassword = prop.getProperty("oceanbase.jdbc.trustStorePassword");
        String keyStorePassword = prop.getProperty("oceanbase.jdbc.keyStorePassword");
        String accessKey = prop.getProperty("cloud.storage.access.key");
        String secretKey = prop.getProperty("cloud.storage.secret.key");
        return new SecureParameters(password, sysPassword, trustStorePassword, keyStorePassword, accessKey, secretKey);
    }

    public String getPassword() {
        return this.password;
    }

    public String getSysPassword() {
        return this.sysPassword;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }
}

