/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.tablefmt;

import com.oceanbase.tools.loaddump.tablefmt.BorderStyle;
import com.oceanbase.tools.loaddump.tablefmt.Column;
import com.oceanbase.tools.loaddump.tablefmt.Filler;
import com.oceanbase.tools.loaddump.tablefmt.Row;
import java.util.List;

public class ShownBorders {
    public static final ShownBorders SURROUND_HEADER_AND_COLUMNS = new ShownBorders("t..ttttttt");
    private boolean headerSeparator;
    private boolean middleSeparator;
    private boolean footerSeparator;
    private boolean leftSeparator;
    private boolean centerSeparator;
    private boolean rightSeparator;
    private boolean topBorder;
    private boolean bottomBorder;
    private boolean leftBorder;
    private boolean rightBorder;

    public ShownBorders(boolean headerSeparator, boolean middleSeparator, boolean footerSeparator, boolean leftSeparator, boolean centerSeparator, boolean rightSeparator, boolean topBorder, boolean bottomBorder, boolean leftBorder, boolean rightBorder) {
        this.headerSeparator = headerSeparator;
        this.middleSeparator = middleSeparator;
        this.footerSeparator = footerSeparator;
        this.leftSeparator = leftSeparator;
        this.centerSeparator = centerSeparator;
        this.rightSeparator = rightSeparator;
        this.topBorder = topBorder;
        this.bottomBorder = bottomBorder;
        this.leftBorder = leftBorder;
        this.rightBorder = rightBorder;
    }

    public ShownBorders(String separatorsAndBordersToRender) {
        this.headerSeparator = this.get(separatorsAndBordersToRender, 0);
        this.middleSeparator = this.get(separatorsAndBordersToRender, 1);
        this.footerSeparator = this.get(separatorsAndBordersToRender, 2);
        this.leftSeparator = this.get(separatorsAndBordersToRender, 3);
        this.centerSeparator = this.get(separatorsAndBordersToRender, 4);
        this.rightSeparator = this.get(separatorsAndBordersToRender, 5);
        this.topBorder = this.get(separatorsAndBordersToRender, 6);
        this.bottomBorder = this.get(separatorsAndBordersToRender, 7);
        this.leftBorder = this.get(separatorsAndBordersToRender, 8);
        this.rightBorder = this.get(separatorsAndBordersToRender, 9);
    }

    private boolean get(String flags, int index) {
        if (flags == null) {
            return false;
        }
        if (index < 0 || index > flags.length()) {
            return false;
        }
        return "t".equalsIgnoreCase(flags.substring(index, index + 1));
    }

    String renderTopBorder(List<Column> columns, BorderStyle tiles, Row lowerRow) {
        return this.renderHorizontalSeparator(columns, tiles.getTLCorner(), tiles.getTCCorner(), tiles.getTRCorner(), tiles.getTop(), null, lowerRow, null, tiles.getTCCorner(), tiles.getCenterWidth());
    }

    String renderMiddleSeparator(List<Column> columns, BorderStyle tiles, Row upperRow, Row lowerRow) {
        return this.renderHorizontalSeparator(columns, tiles.getMLCorner(), tiles.getMCCorner(), tiles.getMRCorner(), tiles.getMiddle(), upperRow, lowerRow, tiles.getUpperColSpan(), tiles.getLowerColSpan(), tiles.getCenterWidth());
    }

    String renderBottomBorder(List<Column> columns, BorderStyle tiles, Row upperRow) {
        return this.renderHorizontalSeparator(columns, tiles.getBLCorner(), tiles.getBCCorner(), tiles.getBRCorner(), tiles.getBottom(), upperRow, null, tiles.getBCCorner(), null, tiles.getCenterWidth());
    }

    private String renderHorizontalSeparator(List<Column> columns, String left, String cross, String right, String horizontal, Row upperRow, Row lowerRow, String upperColSpan, String lowerColSpan, int centerWidth) {
        StringBuffer sb = new StringBuffer();
        if (this.showLeftBorder()) {
            sb.append(left);
        }
        int totalColumns = columns.size();
        for (int j = 0; j < totalColumns; ++j) {
            boolean lowerSep;
            boolean upperSep = upperRow != null ? upperRow.hasSeparator(j) : false;
            boolean bl = lowerSep = lowerRow != null ? lowerRow.hasSeparator(j) : false;
            if (j != 0 && (j > 1 && j < totalColumns - 1 && this.showCenterSeparator() || j == 1 && this.showLeftSeparator() || j == totalColumns - 1 && this.showRightSeparator())) {
                if (upperSep) {
                    if (lowerSep) {
                        sb.append(cross);
                    } else {
                        sb.append(upperColSpan);
                    }
                } else if (lowerSep) {
                    sb.append(lowerColSpan);
                } else {
                    for (int i = 0; i < centerWidth; ++i) {
                        sb.append(horizontal);
                    }
                }
            }
            Column col = columns.get(j);
            sb.append(Filler.getFiller(horizontal, col.getColumnWidth()));
        }
        if (this.showRightBorder()) {
            sb.append(right);
        }
        return sb.toString();
    }

    boolean showRightBorder() {
        return this.rightBorder;
    }

    boolean showRightSeparator() {
        return this.rightSeparator;
    }

    boolean showTopBorder() {
        return this.topBorder;
    }

    boolean showBottomBorder() {
        return this.bottomBorder;
    }

    boolean showCenterSeparator() {
        return this.centerSeparator;
    }

    boolean showFooterSeparator() {
        return this.footerSeparator;
    }

    boolean showHeaderSeparator() {
        return this.headerSeparator;
    }

    boolean showLeftBorder() {
        return this.leftBorder;
    }

    boolean showLeftSeparator() {
        return this.leftSeparator;
    }

    boolean showMiddleSeparator() {
        return this.middleSeparator;
    }
}

