/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.throttle;

import com.oceanbase.tools.loaddump.common.model.Payload;
import com.oceanbase.tools.loaddump.throttle.Throttle;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

abstract class AbstractReentrantThrottle
implements Throttle {
    AbstractReentrantThrottle() {
    }

    protected abstract long pollingDuration();

    @Override
    public void acquire(@NonNull Payload payload) throws InterruptedException {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        while (!this.tryAcquire(payload)) {
            Thread.sleep(this.pollingDuration());
        }
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        long remainingMillis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        long limitTimestamp = System.currentTimeMillis() + remainingMillis;
        while (!this.tryAcquire(payload)) {
            if (remainingMillis <= 0L) {
                return false;
            }
            Thread.sleep(this.pollingDuration());
            remainingMillis = limitTimestamp - System.currentTimeMillis();
        }
        return true;
    }
}

