/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.throttle;

import com.oceanbase.tools.loaddump.common.model.Payload;
import com.oceanbase.tools.loaddump.throttle.Throttle;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class DummyGCThrottle
implements Throttle {
    @Override
    public String getName() {
        return "DummyGCThrottle";
    }

    @Override
    public String toLogString() {
        return "\n\t" + ManagementFactory.getGarbageCollectorMXBeans().stream().map(gc -> String.format("Name: %22s \t GC Count: %5s \t GC Cost: %15s", gc.getName(), gc.getCollectionCount(), DurationFormatUtils.formatDurationHMS((long)gc.getCollectionTime()))).collect(Collectors.joining("\n\t"));
    }

    @Override
    public void acquire(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        return true;
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload, long timeout, @NonNull TimeUnit unit) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        return true;
    }

    @Override
    public void release(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
    }

    @Override
    public void close() throws Exception {
    }
}

