/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.throttle;

import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.model.Payload;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.common.unit.BinarySizeUnit;
import com.oceanbase.tools.loaddump.throttle.MemoryThrottle;
import com.oceanbase.tools.loaddump.throttle.RateLimiterThrottle;
import com.oceanbase.tools.loaddump.throttle.ThrottleCenter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class LoadThreadStartUpThrottle
extends ThrottleCenter {
    private static final Payload MOCK_PAYLOAD = new Payload();
    private final Lock syncObject = new ReentrantLock();
    private final Map<String, Boolean> threadName2Block = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, AtomicInteger> threadName2LockCounter = new ConcurrentHashMap<String, AtomicInteger>();

    public LoadThreadStartUpThrottle() {
        this(JavaOpts.loadThreadStartUpMinIntervalMillis);
    }

    public LoadThreadStartUpThrottle(Long timeSlotMillis) {
        super(Arrays.asList(new RateLimiterThrottle("ThreadSubmitTpsThrottle", LoadThreadStartUpThrottle.getThreadSubmitTps(timeSlotMillis), 10L, TimeUnit.SECONDS), new MemoryThrottle("ThreadSubmitMemThrottle", BinarySizeUnit.MB.of(500L), BinarySizeUnit.MB.of(0L), 0, 100, 1)));
    }

    @Override
    public String toLogString() {
        return "Block Threads: " + this.threadName2Block.values().stream().filter(Boolean.TRUE::equals).count() + super.toLogString();
    }

    @Override
    public String getName() {
        return "ThreadThrottle";
    }

    @Override
    public void acquire(@NonNull Payload payload) throws InterruptedException {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.threadName2Block.put(Thread.currentThread().getName(), true);
        this.syncObject.lockInterruptibly();
        this.incrementLockCount();
        try {
            super.acquire(MOCK_PAYLOAD);
            this.threadName2Block.put(Thread.currentThread().getName(), false);
        }
        catch (Exception e) {
            this.syncObject.unlock();
            this.decrementLockCount();
            throw e;
        }
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.threadName2Block.put(Thread.currentThread().getName(), true);
        if (this.syncObject.tryLock()) {
            this.incrementLockCount();
            try {
                if (super.tryAcquire(MOCK_PAYLOAD)) {
                    this.threadName2Block.put(Thread.currentThread().getName(), false);
                    return true;
                }
                this.releaseLock();
                return false;
            }
            catch (Exception e) {
                this.releaseLock();
                throw e;
            }
        }
        return false;
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.threadName2Block.put(Thread.currentThread().getName(), true);
        long remainMillis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        long start = System.currentTimeMillis();
        if (this.syncObject.tryLock(timeout, unit)) {
            this.incrementLockCount();
            if ((remainMillis -= System.currentTimeMillis() - start) <= 0L) {
                this.releaseLock();
                return false;
            }
            try {
                if (super.tryAcquire(MOCK_PAYLOAD, remainMillis, TimeUnit.MILLISECONDS)) {
                    this.threadName2Block.put(Thread.currentThread().getName(), false);
                    return true;
                }
                this.releaseLock();
                return false;
            }
            catch (Exception e) {
                this.releaseLock();
                throw e;
            }
        }
        return false;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void release(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        AtomicInteger counter = this.threadName2LockCounter.get(Thread.currentThread().getName());
        if (counter != null && counter.get() > 0) {
            for (int i = counter.get(); i > 0; --i) {
                this.syncObject.unlock();
                counter.decrementAndGet();
            }
        }
    }

    private void releaseLock() {
        this.syncObject.unlock();
        this.decrementLockCount();
    }

    private void incrementLockCount() {
        AtomicInteger counter = this.threadName2LockCounter.computeIfAbsent(Thread.currentThread().getName(), k -> new AtomicInteger(0));
        counter.incrementAndGet();
    }

    private void decrementLockCount() {
        AtomicInteger counter = this.threadName2LockCounter.computeIfAbsent(Thread.currentThread().getName(), k -> new AtomicInteger(0));
        counter.decrementAndGet();
    }

    private static BigDecimal getThreadSubmitTps(Long timeSlotMillis) {
        Validate.isTrue((timeSlotMillis > 0L ? 1 : 0) != 0);
        return new BigDecimal(1000).divide(new BigDecimal(timeSlotMillis), 4, RoundingMode.HALF_UP);
    }

    static {
        MOCK_PAYLOAD.addByteSize(4L);
        MOCK_PAYLOAD.addRecord(new Record(Collections.singletonList("mock")));
    }
}

