/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.throttle;

import com.oceanbase.tools.loaddump.common.model.Payload;
import com.oceanbase.tools.loaddump.common.unit.BinarySize;
import com.oceanbase.tools.loaddump.common.unit.BinarySizeUnit;
import com.oceanbase.tools.loaddump.throttle.AbstractReentrantThrottle;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryThrottle
extends AbstractReentrantThrottle {
    private static final Logger log = LoggerFactory.getLogger(MemoryThrottle.class);
    private static final BinarySize ABSOLUTELY_AVAILABLE_MEMORY = BinarySizeUnit.MB.of(200L);
    private static final int DENY_PERCENT_GRADIENT = 1;
    private static final int MAX_DENY_PERCENT = 99;
    private static final int MIN_DENY_PERCENT = 0;
    private static final String HEAP_MEM_NAME = "HEAP_MEM";
    private static final String NON_HEAP_MEM_NAME = "NON_HEAP_MEM";
    private final String name;
    private final Map<String, List<Pair<Long, Integer>>> memName2DenyPercent;

    public MemoryThrottle() {
        this("MemoryThrottle", BinarySizeUnit.MB.of(300L), BinarySizeUnit.MB.of(200L), 0, 99, 1);
    }

    public MemoryThrottle(@NonNull String name, @NonNull BinarySize notAvailableMemorySize, @NonNull BinarySize possibleAvailableMemorySize, int minDenyPercent, int maxDenyPercent, int denyPercentGradient) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (notAvailableMemorySize == null) {
            throw new NullPointerException("notAvailableMemorySize is marked non-null but is null");
        }
        if (possibleAvailableMemorySize == null) {
            throw new NullPointerException("possibleAvailableMemorySize is marked non-null but is null");
        }
        this.name = name;
        this.memName2DenyPercent = new HashMap<String, List<Pair<Long, Integer>>>();
        this.memName2DenyPercent.put(HEAP_MEM_NAME, this.getDenyPercentTable(HEAP_MEM_NAME, notAvailableMemorySize.convert(BinarySizeUnit.B).getSizeDigit(), possibleAvailableMemorySize.convert(BinarySizeUnit.B).getSizeDigit(), minDenyPercent, maxDenyPercent, denyPercentGradient));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toLogString() {
        return this.getJvmMemoryUsage().entrySet().stream().map(entry -> {
            MemoryUsage mu = (MemoryUsage)entry.getValue();
            String max = mu.getMax() > 0L ? BinarySizeUnit.B.of(mu.getMax()).toString() : "N/A";
            String used = mu.getUsed() > 0L ? BinarySizeUnit.B.of(mu.getUsed()).toString() : "N/A";
            return "[" + (String)entry.getKey() + ": " + used + "/" + max + "]";
        }).collect(Collectors.joining(", ")) + ", Block Possible: " + this.getDenyPercent(HEAP_MEM_NAME) + " %";
    }

    @Override
    protected long pollingDuration() {
        return 100L;
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        return this.permits(HEAP_MEM_NAME);
    }

    @Override
    public void release(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
    }

    @Override
    public void close() throws Exception {
    }

    private boolean permits(String key) {
        return new Random().nextInt(100) >= this.getDenyPercent(key);
    }

    private List<Pair<Long, Integer>> getDenyPercentTable(String key, long notAvailableMemorySize, long possibleAvailableMemorySize, int minDenyPercent, int maxDenyPercent, int denyPercentGradient) {
        long sizeBytes = this.getJvmMemoryUsage().get(key).getMax();
        long right = sizeBytes - notAvailableMemorySize;
        long left = right - possibleAvailableMemorySize;
        long interval = left - ABSOLUTELY_AVAILABLE_MEMORY.convert(BinarySizeUnit.B).getSizeDigit();
        if (interval < 0L) {
            long minHeapMem = sizeBytes - interval;
            throw new IllegalArgumentException("Jvm Heap size is too small: " + BinarySizeUnit.B.of(sizeBytes) + ", at least " + BinarySizeUnit.B.of(minHeapMem));
        }
        long step = Math.round((double)((right - left) * (long)denyPercentGradient) / 100.0);
        if (step <= 0L) {
            step = 1L;
        }
        ArrayList<Pair<Long, Integer>> list = new ArrayList<Pair<Long, Integer>>();
        list.add(Pair.of((Object)left, (Object)minDenyPercent));
        int ratio = minDenyPercent + denyPercentGradient;
        for (long limit = left + step; limit < right && ratio < maxDenyPercent; limit += step, ratio += denyPercentGradient) {
            list.add(Pair.of((Object)limit, (Object)ratio));
        }
        list.add(Pair.of((Object)right, (Object)maxDenyPercent));
        return list;
    }

    private Integer getDenyPercent(String key) {
        List<Pair<Long, Integer>> list;
        Pair<Long, Integer> left;
        long sizeBytes = this.getJvmMemoryUsage().get(key).getUsed();
        if (sizeBytes <= (Long)(left = (list = this.memName2DenyPercent.get(key)).get(0)).getLeft()) {
            return (Integer)left.getValue();
        }
        int size = list.size();
        Pair<Long, Integer> right = list.get(size - 1);
        if (sizeBytes >= (Long)right.getLeft()) {
            return (Integer)right.getValue();
        }
        for (int i = 1; i < size - 1; ++i) {
            Pair<Long, Integer> item = list.get(i);
            if ((Long)item.getLeft() < sizeBytes) continue;
            return (Integer)item.getValue();
        }
        return (Integer)right.getValue();
    }

    private Map<String, MemoryUsage> getJvmMemoryUsage() {
        MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();
        HashMap<String, MemoryUsage> memName2Usage = new HashMap<String, MemoryUsage>();
        memName2Usage.put(HEAP_MEM_NAME, mxBean.getHeapMemoryUsage());
        memName2Usage.put(NON_HEAP_MEM_NAME, mxBean.getNonHeapMemoryUsage());
        return memName2Usage;
    }
}

