/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.throttle;

import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.LoadStatus;
import com.oceanbase.tools.loaddump.common.model.Payload;
import com.oceanbase.tools.loaddump.common.thread.NamedThreadFactory;
import com.oceanbase.tools.loaddump.throttle.AbstractReentrantThrottle;
import com.oceanbase.tools.loaddump.utils.ExecutorUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBServerLoadThrottle
extends AbstractReentrantThrottle {
    private static final Logger log = LoggerFactory.getLogger(OBServerLoadThrottle.class);
    private static final String FORMAT = "Server: %22s \t Merge Status: %5s \t Mem Used Ratio: %4s \t Load Mode: %5s";
    private boolean noAuthOnMonitorMemTable;
    private final LoadParameter parameter;
    private final ScheduledExecutorService executorService;
    private final Map<String, LoadStatus> observer2LoadStatus;

    public OBServerLoadThrottle(@NonNull LoadParameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        this.parameter = parameter;
        this.observer2LoadStatus = new ConcurrentHashMap<String, LoadStatus>();
        this.executorService = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("observer-load-refresher-"), new ThreadPoolExecutor.DiscardOldestPolicy());
        this.refreshOBServerLoadStatus();
        this.executorService.scheduleAtFixedRate(() -> {
            try {
                this.refreshOBServerLoadStatus();
            }
            catch (Exception e) {
                log.warn("Refresh observer load status failed. Error: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getName() {
        return "OBServerLoadThrottle";
    }

    @Override
    public String toLogString() {
        if (this.noAuthOnMonitorMemTable) {
            return "No Server Status";
        }
        return "\n\t" + this.observer2LoadStatus.entrySet().stream().map(entry -> {
            LoadStatus status = (LoadStatus)entry.getValue();
            return String.format(FORMAT, new Object[]{entry.getKey(), status.isMerging(), status.getMemUsedPercent(), status.getLoadMode()});
        }).collect(Collectors.joining("\n\t"));
    }

    @Override
    protected long pollingDuration() {
        return 100L;
    }

    @Override
    public void acquire(@NonNull Payload payload) throws InterruptedException {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (this.isSlowLoadMode(payload)) {
            Thread.sleep(this.pollingDuration());
            return;
        }
        super.acquire(payload);
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        return this.observer2LoadStatus.values().stream().noneMatch(s -> LoadStatus.LoadMode.PAUSE.equals((Object)s.getLoadMode()));
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (this.isSlowLoadMode(payload)) {
            Thread.sleep(Math.min(this.pollingDuration(), TimeUnit.MILLISECONDS.convert(timeout, unit)));
            return true;
        }
        return super.tryAcquire(payload, timeout, unit);
    }

    @Override
    public void release(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
    }

    @Override
    public void close() throws Exception {
        ExecutorUtils.gracefulShutdown(this.executorService, 500L);
    }

    private void refreshOBServerLoadStatus() {
        ServerMode serverMode = this.parameter.getDatabase().getServerMode();
        ConnectionKey connectionKey = this.parameter.getConnectionKey();
        if (this.parameter.hasNoSysPrivileges() && serverMode.isPreviousV4()) {
            this.observer2LoadStatus.put("0.0.0.0", new LoadStatus(false, 0.01));
            this.noAuthOnMonitorMemTable = true;
        } else {
            try {
                this.observer2LoadStatus.putAll(connectionKey.getMetadataProvider().queryObserverLoad(serverMode, connectionKey.getTenant()));
            }
            catch (Exception e) {
                if (!this.noAuthOnMonitorMemTable) {
                    log.warn("No authorized to query system tables/views, real-time monitor on mem-table will be disabled. errMsg: {}", (Object)e.getMessage());
                    this.noAuthOnMonitorMemTable = true;
                }
                this.observer2LoadStatus.put("0.0.0.0", new LoadStatus(false, 0.01));
            }
        }
    }

    private boolean isSlowLoadMode(Payload payload) {
        return this.tryAcquire(payload) && this.observer2LoadStatus.values().stream().anyMatch(s -> LoadStatus.LoadMode.SLOW.equals((Object)s.getLoadMode()));
    }
}

