/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.throttle;

import com.google.common.util.concurrent.RateLimiter;
import com.oceanbase.tools.loaddump.common.model.Payload;
import com.oceanbase.tools.loaddump.throttle.Throttle;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;

public class RateLimiterThrottle
implements Throttle {
    private static final String FORMAT = "[Tps: %s], Blocking: %s";
    private final RateLimiter limiter;
    private final BigDecimal maxTps;
    private final String name;
    private final AtomicBoolean blocking;

    public RateLimiterThrottle(int maxTps) {
        this("TpsThrottle", new BigDecimal(maxTps));
    }

    public RateLimiterThrottle(@NonNull String name, BigDecimal maxTps) {
        this(name, maxTps, -1L, null);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    public RateLimiterThrottle(@NonNull String name, BigDecimal maxTps, long warmupPeriod, TimeUnit unit) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.maxTps = maxTps;
        this.name = name;
        this.blocking = new AtomicBoolean(false);
        this.limiter = warmupPeriod <= 0L ? RateLimiter.create((double)maxTps.doubleValue()) : RateLimiter.create((double)maxTps.doubleValue(), (long)warmupPeriod, (TimeUnit)unit);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toLogString() {
        return String.format(FORMAT, this.maxTps.toPlainString(), this.blocking.get());
    }

    @Override
    public void acquire(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.blocking.compareAndSet(false, true);
        this.limiter.acquire(payload.getRecordCount());
        this.blocking.compareAndSet(true, false);
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        boolean origin = this.blocking.get();
        boolean result = this.limiter.tryAcquire(payload.getRecordCount());
        this.blocking.compareAndSet(origin, !result);
        return result;
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload, long timeout, @NonNull TimeUnit unit) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.blocking.compareAndSet(false, true);
        boolean result = this.limiter.tryAcquire(payload.getRecordCount(), timeout, unit);
        this.blocking.compareAndSet(true, !result);
        return result;
    }

    @Override
    public void release(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
    }

    @Override
    public void close() throws Exception {
    }
}

