/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.throttle;

import com.lmax.disruptor.RingBuffer;
import com.oceanbase.tools.loaddump.common.model.Insertion;
import com.oceanbase.tools.loaddump.common.model.Payload;
import com.oceanbase.tools.loaddump.throttle.AbstractReentrantThrottle;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;

public class RingBufferThrottle
extends AbstractReentrantThrottle {
    private final AtomicBoolean blocking = new AtomicBoolean(false);

    @Override
    protected long pollingDuration() {
        return 100L;
    }

    @Override
    public String getName() {
        return "RingBufferThrottle";
    }

    @Override
    public String toLogString() {
        return "Blocking: " + this.blocking.get();
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        boolean origin = this.blocking.get();
        RingBuffer<Insertion> ringBuffer = payload.getRingBuffer();
        boolean result = ringBuffer == null ? true : ringBuffer.remainingCapacity() > 0L;
        this.blocking.compareAndSet(origin, !result);
        return result;
    }

    @Override
    public void release(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
    }

    @Override
    public void close() throws Exception {
    }
}

