/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.throttle;

import com.oceanbase.tools.loaddump.common.model.Payload;
import com.oceanbase.tools.loaddump.throttle.Throttle;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleCenter
implements Throttle {
    private static final Logger log = LoggerFactory.getLogger(ThrottleCenter.class);
    private static final String HORIZON_LINE = "\n---------------------------------------------------------------------------------------------------------\n";
    private final List<Throttle> throttles;

    public ThrottleCenter(@NonNull List<Throttle> throttles) {
        if (throttles == null) {
            throw new NullPointerException("throttles is marked non-null but is null");
        }
        this.throttles = Collections.unmodifiableList(throttles);
    }

    @Override
    public String getName() {
        return "ThrottleCenter";
    }

    @Override
    public void acquire(@NonNull Payload payload) throws InterruptedException {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        for (Throttle throttle : this.throttles) {
            throttle.acquire(payload);
        }
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        for (Throttle throttle : this.throttles) {
            if (throttle.tryAcquire(payload)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean tryAcquire(@NonNull Payload payload, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        long remaining = TimeUnit.MILLISECONDS.convert(timeout, unit);
        long limit = System.currentTimeMillis() + remaining;
        for (Throttle throttle : this.throttles) {
            if (remaining <= 0L) {
                return false;
            }
            if (!throttle.tryAcquire(payload, remaining, TimeUnit.MILLISECONDS)) {
                return false;
            }
            remaining = limit - System.currentTimeMillis();
        }
        return true;
    }

    @Override
    public void release(@NonNull Payload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        for (Throttle throttle : this.throttles) {
            try {
                throttle.release(payload);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Failed to release the throttle \"{}\", error={}", (Object)throttle.getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    @Override
    public void close() throws Exception {
        for (Throttle throttle : this.throttles) {
            try {
                throttle.close();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Failed to close the throttle \"{}\", error={}", (Object)throttle.getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    @Override
    public String toLogString() {
        if (CollectionUtils.isEmpty(this.throttles)) {
            return "No Throttle";
        }
        return HORIZON_LINE + this.throttles.stream().map(t -> t.getName() + ": " + t.toLogString()).collect(Collectors.joining(HORIZON_LINE)) + HORIZON_LINE;
    }

    public List<Throttle> getThrottles() {
        return this.throttles;
    }
}

