/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static String getAbbreviatedName(Class<?> clazz) {
        return ClassUtils.getAbbreviatedName(clazz, 1);
    }

    public static String getAbbreviatedName(Class<?> cls, int len) {
        if (cls == null) {
            return "";
        }
        Preconditions.checkArgument((len > 0 ? 1 : 0) != 0, (Object)"len must be >0");
        int availableSpace = len;
        String className = cls.getName();
        int packageLevels = StringUtils.countMatches(className, '.');
        Object[] output = new String[packageLevels + 1];
        int endIndex = className.length() - 1;
        for (int level = packageLevels; level >= 0; --level) {
            int startIndex = className.lastIndexOf(46, endIndex);
            String part = className.substring(startIndex + 1, endIndex + 1);
            availableSpace -= part.length();
            if (level > 0) {
                --availableSpace;
            }
            output[level] = level == packageLevels ? part : (availableSpace > 0 ? part : part.substring(0, 1));
            endIndex = startIndex - 1;
        }
        return StringUtils.join(output, '.');
    }
}

