/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

public class CodecUtils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encodeHexString(byte[] data) {
        if (data == null) {
            return null;
        }
        return new String(CodecUtils.encodeHex(data));
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        if (data == null) {
            return null;
        }
        return new String(CodecUtils.encodeHex(data, toLowerCase));
    }

    public static char[] encodeHex(byte[] data) {
        if (data == null) {
            return null;
        }
        return CodecUtils.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        if (data == null) {
            return null;
        }
        return CodecUtils.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        if (data == null) {
            return null;
        }
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String decodeHex(String[] datas) throws Exception {
        StringBuilder sb = new StringBuilder(datas.length * 2);
        for (String data : datas) {
            sb.append(new String(CodecUtils.decodeHex(data.toCharArray())));
        }
        return sb.toString();
    }

    public static byte[] decodeHex(String data) throws Exception {
        return CodecUtils.decodeHex(data.toCharArray());
    }

    public static byte[] decodeHex(char[] data) throws Exception {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = CodecUtils.toDigit(data[j], j) << 4;
            f |= CodecUtils.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) throws Exception {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

