/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.ObPartIdCalculator;
import com.oceanbase.partition.calculator.enums.ObPartLevel;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import com.oceanbase.partition.metadata.desc.ObTablePart;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtils {
    private static final Logger log = LoggerFactory.getLogger(DBUtils.class);

    public static Long calculatePartitionId(TableInfo tableInfo, ObPartIdCalculator calculator, Record record, Map<String, Integer> fieldIndexMapping) {
        TableEntry tableEntry = calculator.getTableEntry();
        if (calculator.isPublicCloud() || tableEntry == null || tableEntry.isNonPartitionTable()) {
            return 0L;
        }
        try {
            Long l;
            Integer fieldIndex;
            int metaIndex;
            ObTablePart tablePart = tableEntry.getTablePart();
            for (Map.Entry<String, MapObject> entry : tableInfo.getColumnIndexMapping().entrySet()) {
                MapObject mapObject = entry.getValue();
                if (mapObject.getTarget() != null) continue;
                throw new IllegalArgumentException("Column information mismatch, unable to recognize column [" + entry.getKey() + "] in the target table.");
            }
            Object[] objects = new Object[tableInfo.getColumnInfoList().size()];
            if (tablePart.getLevel().getIndex() > ObPartLevel.LEVEL_ZERO.getIndex()) {
                for (ObPartColumn partColumn : tablePart.getPartColumns()) {
                    metaIndex = partColumn.getColumnIndex();
                    fieldIndex = fieldIndexMapping == null ? tableInfo.getLogicOffset(partColumn.getColumnName()) : fieldIndexMapping.get(partColumn.getColumnName());
                    if (fieldIndex == null) continue;
                    objects[metaIndex] = record.getValues().get(fieldIndex);
                }
            }
            if (tablePart.getLevel().getIndex() >= ObPartLevel.LEVEL_TWO.getIndex()) {
                for (ObPartColumn subPartColumn : tablePart.getSubPartColumns()) {
                    metaIndex = subPartColumn.getColumnIndex();
                    fieldIndex = fieldIndexMapping == null ? tableInfo.getLogicOffset(subPartColumn.getColumnName()) : fieldIndexMapping.get(subPartColumn.getColumnName());
                    if (fieldIndex == null) continue;
                    objects[metaIndex] = record.getValues().get(fieldIndex);
                }
            }
            return (l = calculator.calculatePartId(objects)) == null ? Long.MIN_VALUE : l;
        }
        catch (Exception e) {
            log.warn("Calculate partition id failed. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            return Long.MIN_VALUE;
        }
    }

    public static List<String> toCaseInsensitiveNamesList(ServerMode serverMode, Collection<String> tableNames) {
        if (CollectionUtils.isEmpty(tableNames)) {
            return Lists.newArrayList();
        }
        return tableNames.stream().map(e -> DBUtils.extractObjectName(e.trim(), serverMode)).collect(Collectors.toList());
    }

    public static Collection<String> toCaseInsensitiveCollections(ServerMode serverMode, Collection<String> tableNames, Supplier<Collection<String>> collectionFactory) {
        if (CollectionUtils.isEmpty(tableNames)) {
            return collectionFactory.get();
        }
        return tableNames.stream().map(e -> DBUtils.extractObjectName(e.trim(), serverMode)).collect(Collectors.toCollection(collectionFactory));
    }

    public static Collection<String> toCaseInsensitiveColumnNameCollections(ServerMode serverMode, Collection<String> columnNames, Supplier<Collection<String>> collectionFactory) {
        if (CollectionUtils.isEmpty(columnNames)) {
            return collectionFactory.get();
        }
        return columnNames.stream().map(e -> DBUtils.extractColumnName(e.trim(), serverMode)).collect(Collectors.toCollection(collectionFactory));
    }

    public static String extractObjectName(String objectName, ServerMode serverMode) {
        return DBUtils.tryUnwrapAndMap(objectName, s -> s, s -> serverMode == null ? s : serverMode.toCaseSensitiveName((String)s));
    }

    public static String extractColumnName(String objectName, ServerMode serverMode) {
        return DBUtils.tryUnwrapAndMap(objectName, input -> {
            if (serverMode == null || serverMode.isMysqlMode()) {
                return input.toLowerCase();
            }
            return input;
        }, input -> {
            if (serverMode == null || serverMode.isMysqlMode()) {
                return input.toLowerCase();
            }
            return serverMode.toCaseSensitiveName((String)input);
        });
    }

    private static String tryUnwrapAndMap(String objectName, Function<String, String> wrappedNameMapper, Function<String, String> noWrappedNameMapper) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(objectName), (Object)"Input object name is null");
        String trimmedName = objectName.trim();
        char c1 = trimmedName.charAt(0);
        char cn = trimmedName.charAt(trimmedName.length() - 1);
        if (c1 == '`' && cn == '`' || c1 == '[' && cn == ']' || c1 == '\"' && cn == '\"' || c1 == '\'' && cn == '\'') {
            return wrappedNameMapper.apply(trimmedName.substring(1, trimmedName.length() - 1));
        }
        return noWrappedNameMapper.apply(trimmedName);
    }

    public static List<Set<String>> splitObjectNames(Collection<String> objectNames) {
        ArrayList<Set<String>> groupList = new ArrayList<Set<String>>(2);
        groupList.add(objectNames.stream().filter(e -> e.contains("*")).map(e -> "^" + e.replaceAll("\\*", ".*") + "$").collect(Collectors.toSet()));
        groupList.add(objectNames.stream().filter(e -> !e.contains("*")).collect(Collectors.toSet()));
        return groupList;
    }

    public static boolean matches(Collection<String> objectNames, String name) {
        List<Set<String>> patternGroups = DBUtils.splitObjectNames(objectNames);
        boolean isRegex = true;
        for (Set<String> patterns : patternGroups) {
            if (isRegex ? patterns.stream().anyMatch(s -> Pattern.matches(s, name)) : patterns.contains(name)) {
                return true;
            }
            isRegex = !isRegex;
        }
        return false;
    }

    public static String wrapWhereClause(String whereClause) {
        return StringUtils.isBlank(whereClause) ? null : "(" + whereClause + ")";
    }
}

