/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final Logger log = LoggerFactory.getLogger(ExecutorUtils.class);

    public static void gracefulShutdown(ExecutorService executor, long timeoutMilliSeconds) {
        if (Objects.isNull(executor)) {
            return;
        }
        try {
            executor.shutdown();
            log.debug("shutdown signal received, terminating...");
            if (executor.awaitTermination(timeoutMilliSeconds, TimeUnit.MILLISECONDS)) {
                log.debug("Executor terminated success.");
            } else {
                log.warn("Executor terminate failed, forcing shutdown...");
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.warn("Executor terminate interrupted, message={}", (Object)e.getMessage());
        }
    }
}

