/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class ListUtils {
    public static <T, V extends Collection<T>> List<V> groupByCount(@NonNull V collections, int groupCount, @NonNull Function<Integer, V> collectionSupplier) {
        int itemsForThisSubCollection;
        if (collections == null) {
            throw new NullPointerException("collections is marked non-null but is null");
        }
        if (collectionSupplier == null) {
            throw new NullPointerException("collectionSupplier is marked non-null but is null");
        }
        Validate.isTrue((groupCount > 0 ? 1 : 0) != 0, (String)"Group count can not be negative", (Object[])new Object[0]);
        ArrayList<Collection> returnList = new ArrayList<Collection>(groupCount);
        if (collections.isEmpty()) {
            return returnList;
        }
        if (collections.size() <= groupCount) {
            Collection subCollection = (Collection)collectionSupplier.apply(collections.size());
            subCollection.addAll(collections);
            returnList.add(subCollection);
            return returnList;
        }
        int itemsPerCollection = collections.size() / groupCount;
        int remainingItems = collections.size() % groupCount;
        int currentIndex = 0;
        ArrayList listCollections = new ArrayList(collections);
        for (int i = 0; i < groupCount && (itemsForThisSubCollection = itemsPerCollection + (i < remainingItems ? 1 : 0)) != 0; ++i) {
            int startIndex = currentIndex;
            int endIndex = currentIndex + itemsForThisSubCollection - 1;
            Collection subCollection = (Collection)collectionSupplier.apply(endIndex - startIndex + 1);
            for (int j = startIndex; j <= endIndex; ++j) {
                subCollection.add(listCollections.get(j));
            }
            returnList.add(subCollection);
            currentIndex += itemsForThisSubCollection;
        }
        return returnList;
    }
}

