/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.oceanbase.tools.loaddump.common.JavaOpts;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;

public final class LogUtils {
    private static Logger PROGRESS_LOGGER = null;

    private LogUtils() {
    }

    public static void progress(String format, Object ... arguments) {
        if (JavaOpts.isBackupRestoreMode) {
            PROGRESS_LOGGER.info(format, arguments);
        }
    }

    public static void info(String message) {
        LogUtils.println(Level.INFO, message, "");
    }

    public static void info(String message, Object ... params) {
        LogUtils.println(Level.INFO, message, params);
    }

    public static void error(String message) {
        LogUtils.println(Level.ERROR, message, "");
    }

    public static void error(String message, Object ... params) {
        LogUtils.println(Level.ERROR, message, params);
    }

    public static void warn(String message) {
        LogUtils.println(Level.WARN, message, "");
    }

    public static void warn(String message, Object ... params) {
        LogUtils.println(Level.WARN, message, params);
    }

    public static void debug(String message) {
        if (JavaOpts.isDebugable) {
            LogUtils.println(Level.DEBUG, message, "");
        }
    }

    public static void debug(String message, Object ... params) {
        if (JavaOpts.isDebugable) {
            LogUtils.println(Level.DEBUG, message, params);
        }
    }

    private static void println(@NonNull Level level, @NonNull String message, Object ... params) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        String formatMessage = message;
        if (params != null) {
            formatMessage = MessageFormatter.arrayFormat((String)message, (Object[])params).getMessage();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        sb.append(" [").append(level.toString()).append("] ").append(formatMessage);
        if (Level.ERROR.equals((Object)level)) {
            System.err.println(sb);
        } else {
            System.out.println(sb);
        }
    }

    static {
        if (JavaOpts.isBackupRestoreMode) {
            PROGRESS_LOGGER = LoggerFactory.getLogger((String)"ProgressLogger");
        }
    }
}

