/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.security.OpenSslDecryptor;
import com.oceanbase.tools.loaddump.security.SecureParameters;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.PropertiesUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static byte[] encryptSM4(byte[] plaintext, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance("SM4", "BC");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "SM4");
        cipher.init(1, secretKeySpec);
        return cipher.doFinal(plaintext);
    }

    public static byte[] decryptSM4(byte[] ciphertext, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance("SM4", "BC");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "SM4");
        cipher.init(2, secretKeySpec);
        return cipher.doFinal(ciphertext);
    }

    public static byte[] hashSM3(byte[] data) throws Exception {
        SM3Digest digest = new SM3Digest();
        digest.update(data, 0, data.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    @NonNull
    public static SecureParameters decrypt() throws Exception {
        String path = System.getProperty("security.configurationFile");
        if (StringUtils.isBlank(path) && StringUtils.isBlank(path = System.getProperty("security.configurationFile"))) {
            return new SecureParameters();
        }
        String propertiesStr = SecurityUtils.readFileToString(path);
        Properties properties = PropertiesUtils.loadPropertiesFromString(propertiesStr);
        if (properties.isEmpty()) {
            return new SecureParameters();
        }
        if (StringUtils.isBlank(properties.getProperty("security.className"))) {
            return SecurityUtils.decryptByOpenSsl(properties);
        }
        return SecurityUtils.decryptByCustomImpl(properties);
    }

    @NonNull
    private static SecureParameters decryptByOpenSsl(Properties props) throws Exception {
        try {
            String secretKeyPath;
            String encryptFilePath = props.getProperty("encrypt.filePath");
            if (StringUtils.isBlank(encryptFilePath)) {
                encryptFilePath = props.getProperty("secure.filePath");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank(encryptFilePath), (Object)"The property \"encrypt.filePath\" should be set");
            }
            if (StringUtils.isBlank(secretKeyPath = props.getProperty("secretKey.filePath"))) {
                secretKeyPath = props.getProperty("privateKey.filePath");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank(secretKeyPath), (Object)"The property \"secretKey.filePath\" should be set");
            }
            String decryptedStr = OpenSslDecryptor.decrypt(encryptFilePath, secretKeyPath);
            return SecureParameters.newInstance(PropertiesUtils.loadPropertiesFromString(decryptedStr));
        }
        catch (Exception e) {
            LogUtils.error("Try to security security parameters with OpenSSL failed. Reason: {}.\n-\tNote: It may caused by incorrect config in \"security.properties\". To resolve this, you may reset the \"security.properties\" as the official document guided.", e.getMessage());
            throw e;
        }
    }

    private static SecureParameters decryptByCustomImpl(Properties props) throws Exception {
        try {
            String encryptFilePath = props.getProperty("encrypt.filePath");
            if (StringUtils.isBlank(encryptFilePath)) {
                encryptFilePath = props.getProperty("secure.filePath");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank(encryptFilePath), (Object)"The property \"encrypt.filePath\" should be set");
            }
            Class<?> decryptClass = Class.forName(props.getProperty("security.className"));
            Object instance = decryptClass.newInstance();
            Method decryptMethod = decryptClass.getMethod("security", String.class);
            String encryptedStr = SecurityUtils.readFileToString(encryptFilePath);
            String decryptedStr = (String)decryptMethod.invoke(instance, encryptedStr);
            return SecureParameters.newInstance(PropertiesUtils.loadPropertiesFromString(decryptedStr));
        }
        catch (Exception e) {
            LogUtils.error("Try to security secure parameters with custom impl failed. Reason: {}.\n-\tNote: It may caused by incorrect config in \"security.properties\". To resolve this, you may reset the \"security.properties\" as the official document guided.", e.getMessage());
            throw e;
        }
    }

    private static String readFileToString(String path) throws Exception {
        if (path.startsWith("http://")) {
            return IOUtils.toString((URL)new URL(path), (Charset)StandardCharsets.UTF_8);
        }
        if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        }
        if (FileUtils.exists(path)) {
            return FileUtils.readFileToString((File)new File(path), (Charset)StandardCharsets.UTF_8);
        }
        throw new FileNotFoundException("File: \"" + path + "\" is not exists");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

