/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import com.esotericsoftware.kryo.util.Pool;
import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializeUtils {
    private static final Logger log = LoggerFactory.getLogger(SerializeUtils.class);
    private static final Pool<Kryo> KRYO_POOL = new Pool<Kryo>(true, false, Constants.AVAILABLE_CPUS * 2){

        protected Kryo create() {
            Kryo kryo = new Kryo();
            kryo.setReferences(true);
            kryo.setRegistrationRequired(false);
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            return kryo;
        }
    };

    private SerializeUtils() {
    }

    public static <T> void serializeObjectByKryo(T obj, String path) throws Exception {
        if (!new File(path).exists()) {
            FileUtils.touch((File)new File(path));
        }
        SerializeUtils.serializeObjectByKryo(obj, Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]));
    }

    public static <T> void serializeListByKryo(List<T> list, String path) throws Exception {
        if (!new File(path).exists()) {
            FileUtils.touch((File)new File(path));
        }
        SerializeUtils.serializeObjectByKryo(list, Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void serializeObjectByKryo(Object obj, OutputStream os) {
        Kryo kryo = (Kryo)KRYO_POOL.obtain();
        try (Output output = new Output(os);){
            kryo.writeClassAndObject(output, obj);
            output.flush();
        }
        catch (Exception e) {
            log.warn("Serialize object failed. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
        }
        finally {
            KRYO_POOL.free((Object)kryo);
        }
    }

    public static <T> List<T> deserializeListByKryo(String path) throws Exception {
        Preconditions.checkArgument((boolean)new File(path).exists(), (String)"File: \"{%s}\" is not exists", (Object)path);
        List returnVal = (List)SerializeUtils.deserializeObjectByKryo(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));
        return returnVal == null ? new ArrayList() : returnVal;
    }

    public static <T> T deserializeObjectByKryo(String path) throws Exception {
        Preconditions.checkArgument((boolean)new File(path).exists(), (String)"File: \"%s\" is not exists", (Object)path);
        return SerializeUtils.deserializeObjectByKryo(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <T> T deserializeObjectByKryo(InputStream is) {
        Kryo kryo = (Kryo)KRYO_POOL.obtain();
        try {
            Object object;
            Throwable throwable;
            Input input;
            block17: {
                block18: {
                    input = new Input(is);
                    throwable = null;
                    object = kryo.readClassAndObject(input);
                    if (input == null) break block17;
                    if (throwable == null) break block18;
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block17;
                }
                input.close();
            }
            return (T)object;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (input != null) {
                            if (throwable != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                input.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    log.warn("Deserialize object failed. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
                    throwable = null;
                    return (T)throwable;
                }
            }
        }
        finally {
            KRYO_POOL.free((Object)kryo);
        }
    }
}

