/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.constants.JdbcType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.GeometryObject;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.common.model.SqlContext;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.loader.PrepareStatementValueSetter;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.NumberUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlUtils.class);
    public static final String FLOAT_REGEX = "(\\+|\\-)?\\d+\\.?\\d*";
    public static final String SUB_TIME_REGEX = "\\d{2} \\d{2}:\\d{2}:\\d{2}.(\\d{6}|\\d{9})";
    private static final Logger BAD_RECORD_LOGGER = LoggerFactory.getLogger((String)"BadRecordLogger");

    private SqlUtils() {
    }

    public static SqlContext translateInsertMultiValuesSqlContext(TableInfo tableInfo, List<Record> records) {
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"Input table info is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(records), (Object)"Input record list is null");
        boolean status = true;
        int valueCount = records.get(0).size();
        int recordCount = 0;
        ArrayList<Object> args = new ArrayList<Object>(valueCount * records.size());
        ArrayList<PrepareStatementValueSetter> psStmtSetters = new ArrayList<PrepareStatementValueSetter>(valueCount * records.size());
        block0: for (Record record : records) {
            if (!record.isValid()) {
                BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)tableInfo.toInsertSql(record), (Object)record.getBadCause());
                continue;
            }
            int valueSize = record.size();
            for (int logicPosition = 0; logicPosition < valueSize; ++logicPosition) {
                Integer offset = tableInfo.getPhysicOffset(logicPosition);
                if (offset == null) {
                    status = false;
                    BAD_RECORD_LOGGER.error("{}\nCause: No table column matches the logical offset {} of this record\n", (Object)tableInfo.toInsertSql(record), (Object)logicPosition);
                    continue block0;
                }
                String columnName = tableInfo.getColumnName(logicPosition);
                if (tableInfo.isVirtualColumn(columnName) || tableInfo.containsDbSequence(columnName)) continue;
                Object objValue = record.get(logicPosition);
                if (objValue instanceof GeometryObject) {
                    args.add(objValue);
                    psStmtSetters.add(tableInfo.getTypeHandler(columnName));
                    continue;
                }
                String value = objValue != null ? objValue.toString() : null;
                boolean isNullable = tableInfo.isNullable(columnName);
                String columnType = tableInfo.getColumnTypeName(columnName);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !JdbcType.isNullAndEmptyDistinguished(columnType)) {
                    value = null;
                }
                args.add(value);
                psStmtSetters.add(tableInfo.getTypeHandler(columnName));
            }
            ++recordCount;
        }
        ArrayList<List<Object>> batchArgs = new ArrayList<List<Object>>(1);
        batchArgs.add(args);
        String insert = tableInfo.cachedInsertIntoSqlStmt(records.get(0), recordCount);
        return new SqlContext(insert, recordCount, batchArgs, psStmtSetters, status);
    }

    public static SqlContext translateInsertMultiValuesSqlContext(TableInfo tableInfo, List<Record> records, List<String> fieldNameList) {
        if (fieldNameList == null) {
            return SqlUtils.translateInsertMultiValuesSqlContext(tableInfo, records);
        }
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"Input table info is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(records), (Object)"Input record list is null");
        boolean status = true;
        int valueCount = records.get(0).size();
        int recordCount = 0;
        ArrayList<Object> args = new ArrayList<Object>(valueCount * records.size());
        ArrayList<PrepareStatementValueSetter> psStmtSetters = new ArrayList<PrepareStatementValueSetter>(valueCount * records.size());
        Map<String, MapObject> columnIndexMapping = tableInfo.getColumnIndexMapping();
        for (Record record : records) {
            if (!record.isValid()) {
                BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)tableInfo.toInsertSql(record, fieldNameList), (Object)record.getBadCause());
                continue;
            }
            for (int i = 0; i < fieldNameList.size(); ++i) {
                String columnName = fieldNameList.get(i);
                if (!columnIndexMapping.containsKey(columnName) || tableInfo.isVirtualColumn(columnName) || tableInfo.containsDbSequence(columnName)) continue;
                Object objValue = record.get(i);
                if (objValue instanceof GeometryObject) {
                    args.add(objValue);
                    psStmtSetters.add(tableInfo.getTypeHandler(columnName));
                    continue;
                }
                String value = objValue != null ? objValue.toString() : null;
                boolean isNullable = tableInfo.isNullable(columnName);
                String columnType = tableInfo.getColumnTypeName(columnName);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !JdbcType.isNullAndEmptyDistinguished(columnType)) {
                    value = null;
                }
                args.add(value);
                psStmtSetters.add(tableInfo.getTypeHandler(columnName));
            }
            ++recordCount;
        }
        ArrayList<List<Object>> batchArgs = new ArrayList<List<Object>>(1);
        batchArgs.add(args);
        String insert = tableInfo.cachedInsertIntoSqlStmtWithPartialColumns(recordCount, fieldNameList);
        return new SqlContext(insert, recordCount, batchArgs, psStmtSetters, status);
    }

    public static List<SqlContext> translateInsertSingleValueSqlContext(TableInfo tableInfo, List<Record> records) {
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"Input table info is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(records), (Object)"Input record list is null");
        int valueCount = records.get(0).size();
        ArrayList<SqlContext> contexts = new ArrayList<SqlContext>();
        block0: for (Record record : records) {
            if (!record.isValid()) {
                BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)tableInfo.toInsertSql(record), (Object)record.getBadCause());
                continue;
            }
            ArrayList<List<Object>> batchArgs = new ArrayList<List<Object>>(1);
            valueCount = Math.max(valueCount, record.size());
            ArrayList<Object> values = new ArrayList<Object>(valueCount);
            ArrayList<PrepareStatementValueSetter> psStmtSetters = new ArrayList<PrepareStatementValueSetter>(valueCount);
            for (int logicPosition = 0; logicPosition < valueCount; ++logicPosition) {
                Integer offset = tableInfo.getPhysicOffset(logicPosition);
                if (offset == null) {
                    BAD_RECORD_LOGGER.error("{}\nCause: No table column matches the logical offset {} of this record\n", (Object)tableInfo.toInsertSql(record), (Object)logicPosition);
                    continue block0;
                }
                String columnName = tableInfo.getColumnName(logicPosition);
                if (tableInfo.isVirtualColumn(columnName) || tableInfo.containsDbSequence(columnName)) continue;
                Object objValue = record.get(logicPosition);
                if (objValue instanceof GeometryObject) {
                    values.add(objValue);
                    psStmtSetters.add(tableInfo.getTypeHandler(columnName));
                    continue;
                }
                String value = objValue != null ? objValue.toString() : null;
                boolean isNullable = tableInfo.isNullable(columnName);
                String columnType = tableInfo.getColumnTypeName(columnName);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !JdbcType.isNullAndEmptyDistinguished(columnType)) {
                    value = null;
                }
                values.add(value);
                psStmtSetters.add(tableInfo.getTypeHandler(columnName));
            }
            batchArgs.add(values);
            String insert = tableInfo.cachedInsertIntoSqlStmt(record, 1);
            contexts.add(new SqlContext(insert, 1, batchArgs, psStmtSetters, true));
        }
        return contexts;
    }

    public static List<SqlContext> translateInsertSingleValueSqlContext(TableInfo tableInfo, List<Record> records, List<String> fieldNameList) {
        if (fieldNameList == null) {
            return SqlUtils.translateInsertSingleValueSqlContext(tableInfo, records);
        }
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"Input table info is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(records), (Object)"Input record list is null");
        int valueCount = records.get(0).size();
        ArrayList<SqlContext> contexts = new ArrayList<SqlContext>();
        Map<String, MapObject> columnIndexMapping = tableInfo.getColumnIndexMapping();
        for (Record record : records) {
            if (!record.isValid()) {
                BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)tableInfo.toInsertSql(record), (Object)record.getBadCause());
                continue;
            }
            valueCount = Math.max(valueCount, record.size());
            ArrayList<Object> args = new ArrayList<Object>(valueCount);
            ArrayList<PrepareStatementValueSetter> psStmtSetters = new ArrayList<PrepareStatementValueSetter>(valueCount);
            for (int i = 0; i < fieldNameList.size(); ++i) {
                String columnName = fieldNameList.get(i);
                if (!columnIndexMapping.containsKey(columnName) || tableInfo.isVirtualColumn(columnName) || tableInfo.containsDbSequence(columnName)) continue;
                Object objValue = record.get(i);
                if (objValue instanceof GeometryObject) {
                    args.add(objValue);
                    psStmtSetters.add(tableInfo.getTypeHandler(columnName));
                    continue;
                }
                String value = objValue != null ? objValue.toString() : null;
                boolean isNullable = tableInfo.isNullable(columnName);
                String columnType = tableInfo.getColumnTypeName(columnName);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !JdbcType.isNullAndEmptyDistinguished(columnType)) {
                    value = null;
                }
                args.add(value);
                psStmtSetters.add(tableInfo.getTypeHandler(columnName));
            }
            ArrayList<List<Object>> batchArgs = new ArrayList<List<Object>>(1);
            batchArgs.add(args);
            String insert = tableInfo.cachedInsertIntoSqlStmtWithPartialColumns(1, fieldNameList);
            contexts.add(new SqlContext(insert, 1, batchArgs, psStmtSetters, true));
        }
        return contexts;
    }

    public static SqlContext translateInsertBatchValueSqlContext(TableInfo tableInfo, List<Record> records) {
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"Input table info is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(records), (Object)"Input record list is null");
        int valueCount = records.get(0).size();
        int recordCount = records.size();
        ArrayList<List<Object>> batchArgs = new ArrayList<List<Object>>(recordCount);
        ArrayList batchPsStmtSetters = new ArrayList(recordCount);
        boolean status = true;
        block0: for (Record record : records) {
            if (!record.isValid()) {
                status = false;
                BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)tableInfo.toInsertSql(record), (Object)record.getBadCause());
                continue;
            }
            valueCount = Math.max(valueCount, record.size());
            ArrayList<Object> values = new ArrayList<Object>(valueCount);
            ArrayList psStmtSetters = new ArrayList(valueCount);
            for (int logicPosition = 0; logicPosition < valueCount; ++logicPosition) {
                Integer offset = tableInfo.getPhysicOffset(logicPosition);
                if (offset == null) {
                    status = false;
                    BAD_RECORD_LOGGER.error("{}\nCause: No table column matches the logical offset {} of this record\n", (Object)tableInfo.toInsertSql(record), (Object)logicPosition);
                    continue block0;
                }
                String columnName = tableInfo.getColumnName(logicPosition);
                if (tableInfo.isVirtualColumn(columnName) || tableInfo.containsDbSequence(columnName)) continue;
                Object objValue = record.get(logicPosition);
                if (objValue instanceof GeometryObject) {
                    values.add(objValue);
                    psStmtSetters.add(tableInfo.getTypeHandler(columnName));
                    continue;
                }
                String value = objValue != null ? objValue.toString() : null;
                boolean isNullable = tableInfo.isNullable(columnName);
                String columnType = tableInfo.getColumnTypeName(columnName);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !JdbcType.isNullAndEmptyDistinguished(columnType)) {
                    value = null;
                }
                values.add(value);
                psStmtSetters.add(tableInfo.getTypeHandler(columnName));
            }
            batchArgs.add(values);
            batchPsStmtSetters.add(psStmtSetters);
        }
        String insert = tableInfo.cachedInsertIntoSqlStmt(valueCount, 1);
        return new SqlContext(insert, 1, batchArgs, (List)batchPsStmtSetters.get(0), status);
    }

    public static SqlContext translateInsertBatchValueSqlContext(TableInfo tableInfo, List<Record> records, List<String> fieldNameList) {
        if (fieldNameList == null) {
            return SqlUtils.translateInsertBatchValueSqlContext(tableInfo, records);
        }
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"Input table info is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(records), (Object)"Input record list is null");
        int valueCount = records.get(0).size();
        int recordCount = records.size();
        ArrayList<List<Object>> batchArgs = new ArrayList<List<Object>>(recordCount);
        ArrayList batchPsStmtSetters = new ArrayList(recordCount);
        boolean status = true;
        Map<String, MapObject> columnIndexMapping = tableInfo.getColumnIndexMapping();
        for (Record record : records) {
            if (!record.isValid()) {
                status = false;
                BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)tableInfo.toInsertSql(record), (Object)record.getBadCause());
                continue;
            }
            valueCount = Math.max(valueCount, record.size());
            ArrayList<Object> values = new ArrayList<Object>(valueCount);
            ArrayList psStmtSetters = new ArrayList(valueCount);
            for (int i = 0; i < fieldNameList.size(); ++i) {
                String columnName = fieldNameList.get(i);
                if (!columnIndexMapping.containsKey(columnName) || tableInfo.isVirtualColumn(columnName) || tableInfo.containsDbSequence(columnName)) continue;
                Object objValue = record.get(i);
                if (objValue instanceof GeometryObject) {
                    values.add(objValue);
                    psStmtSetters.add(tableInfo.getTypeHandler(columnName));
                    continue;
                }
                String value = objValue != null ? objValue.toString() : null;
                boolean isNullable = tableInfo.isNullable(columnName);
                String columnType = tableInfo.getColumnTypeName(columnName);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !JdbcType.isNullAndEmptyDistinguished(columnType)) {
                    value = null;
                }
                values.add(value);
                psStmtSetters.add(tableInfo.getTypeHandler(columnName));
            }
            batchArgs.add(values);
            batchPsStmtSetters.add(psStmtSetters);
        }
        String insert = tableInfo.cachedInsertIntoSqlStmt(records.get(0), 1);
        return new SqlContext(insert, 1, batchArgs, (List)batchPsStmtSetters.get(0), status);
    }

    public static List<SqlContext> translateMergeIntoSingleStatement(TableInfo tableInfo, List<Record> records) {
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"Input table info is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(records), (Object)"Input record list is null");
        int valueCount = records.get(0).size();
        ArrayList<SqlContext> contexts = new ArrayList<SqlContext>();
        block0: for (Record record : records) {
            if (!record.isValid()) {
                BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)tableInfo.toInsertSql(record), (Object)record.getBadCause());
                continue;
            }
            valueCount = Math.max(valueCount, record.size());
            ArrayList<Object> values = new ArrayList<Object>(valueCount);
            ArrayList<PrepareStatementValueSetter> psStmtSetters = new ArrayList<PrepareStatementValueSetter>(valueCount);
            String sql = tableInfo.cachedMergeIntoSqlStmt(valueCount);
            for (int logicPosition = 0; logicPosition < valueCount; ++logicPosition) {
                Integer offset = tableInfo.getPhysicOffset(logicPosition);
                if (offset == null) {
                    BAD_RECORD_LOGGER.error("{}\nCause: No table column matches the logical offset {} of this record\n", (Object)tableInfo.toInsertSql(record), (Object)logicPosition);
                    continue block0;
                }
                String columnName = tableInfo.getColumnName(logicPosition);
                if (tableInfo.isVirtualColumn(columnName) || tableInfo.containsDbSequence(columnName)) continue;
                Object objValue = record.get(logicPosition);
                if (objValue instanceof GeometryObject) {
                    values.add(objValue);
                    psStmtSetters.add(tableInfo.getTypeHandler(columnName));
                    continue;
                }
                String value = objValue != null ? objValue.toString() : null;
                boolean isNullable = tableInfo.isNullable(columnName);
                String columnType = tableInfo.getColumnTypeName(columnName);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !JdbcType.isNullAndEmptyDistinguished(columnType)) {
                    value = null;
                }
                values.add(value);
                psStmtSetters.add(tableInfo.getTypeHandler(columnName));
            }
            ArrayList<List<Object>> batchArgs = new ArrayList<List<Object>>(1);
            batchArgs.add(values);
            contexts.add(new SqlContext(sql, 1, batchArgs, psStmtSetters, true));
        }
        return contexts;
    }

    public static List<SqlContext> translateMergeIntoSingleStatement(TableInfo tableInfo, List<Record> records, List<String> fieldNameList) {
        if (CollectionUtils.isEmpty(fieldNameList)) {
            return SqlUtils.translateMergeIntoSingleStatement(tableInfo, records);
        }
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"Input table info is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(records), (Object)"Input record list is null");
        int valueCount = records.get(0).size();
        ArrayList<SqlContext> contexts = new ArrayList<SqlContext>();
        Map<String, MapObject> columnIndexMapping = tableInfo.getColumnIndexMapping();
        String sql = tableInfo.cachedMergeIntoSqlStmt(fieldNameList);
        for (Record record : records) {
            if (!record.isValid()) {
                BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)tableInfo.toInsertSql(record, fieldNameList), (Object)record.getBadCause());
                continue;
            }
            valueCount = Math.max(valueCount, record.size());
            ArrayList<Object> args = new ArrayList<Object>(valueCount);
            ArrayList<PrepareStatementValueSetter> psStmtSetters = new ArrayList<PrepareStatementValueSetter>(valueCount);
            for (int i = 0; i < fieldNameList.size(); ++i) {
                String columnName = fieldNameList.get(i);
                if (!columnIndexMapping.containsKey(columnName) || tableInfo.isVirtualColumn(columnName) || tableInfo.containsDbSequence(columnName)) continue;
                Object objValue = record.get(i);
                if (objValue instanceof GeometryObject) {
                    args.add(objValue);
                    psStmtSetters.add(tableInfo.getTypeHandler(columnName));
                    continue;
                }
                String value = objValue != null ? objValue.toString() : null;
                boolean isNullable = tableInfo.isNullable(columnName);
                String columnType = tableInfo.getColumnTypeName(columnName);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !JdbcType.isNullAndEmptyDistinguished(columnType)) {
                    value = null;
                }
                args.add(value);
                psStmtSetters.add(tableInfo.getTypeHandler(columnName));
            }
            ArrayList<List<Object>> batchArgs = new ArrayList<List<Object>>(1);
            batchArgs.add(args);
            contexts.add(new SqlContext(sql, 1, batchArgs, psStmtSetters, true));
        }
        return contexts;
    }

    public static SqlContext translateDeleteSqlContext(TableInfo tableInfo, List<Record> records) {
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"Input table info is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(records), (Object)"Input record list is null");
        boolean status = true;
        int valueSize = records.get(0).size();
        int recordSize = records.size();
        List<String> primaryColumns = tableInfo.getPrimaryColumnNames();
        Map<String, List<String>> uniqueKeyMap = tableInfo.getUniqueKeyMap();
        ArrayList<String> args = new ArrayList<String>(recordSize);
        ArrayList<PrepareStatementValueSetter> psStmtSetters = new ArrayList<PrepareStatementValueSetter>(recordSize);
        boolean hasPrimaryKey = tableInfo.hasPrimaryKey();
        boolean hasUniqueKey = tableInfo.hasUniqueKey();
        StringBuilder delete = new StringBuilder(1024 * records.size());
        delete.append("DELETE FROM ").append(tableInfo.getSchemaTable()).append(" WHERE ");
        Iterator<Record> iterator = records.iterator();
        while (iterator.hasNext()) {
            Record record = iterator.next();
            try {
                delete.append("(");
                valueSize = Math.max(valueSize, record.size());
                ArrayList<String> values = new ArrayList<String>(valueSize);
                if (hasPrimaryKey) {
                    delete.append((CharSequence)SqlUtils.buildCondition(primaryColumns, values, psStmtSetters, tableInfo, record));
                }
                if (hasUniqueKey) {
                    if (hasPrimaryKey) {
                        delete.append(" OR ");
                    }
                    Iterator<Map.Entry<String, List<String>>> entries = uniqueKeyMap.entrySet().iterator();
                    while (entries.hasNext()) {
                        delete.append((CharSequence)SqlUtils.buildCondition(entries.next().getValue(), values, psStmtSetters, tableInfo, record));
                        if (!entries.hasNext()) continue;
                        delete.append(" OR ");
                    }
                }
                delete.append(")");
                if (iterator.hasNext()) {
                    delete.append(" OR ");
                }
                args.addAll(values);
            }
            catch (Exception ex) {
                status = false;
                log.error("Fatal Error: {}. See the bad record in \"ob-loader-dumper.bad\"", (Object)ExceptionUtils.getRootCauseMessage(ex));
                BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)tableInfo.toInsertSql(record), (Object)ex.getMessage());
            }
        }
        ArrayList<List<Object>> batchArgs = new ArrayList<List<Object>>(1);
        batchArgs.add(args);
        return new SqlContext(delete.toString(), records.size(), batchArgs, psStmtSetters, status);
    }

    private static StringBuilder buildCondition(List<String> keyColumns, List<String> values, List<PrepareStatementValueSetter> psStmtSetters, TableInfo tableInfo, Record record) {
        boolean useUnhex = tableInfo.isMySqlMode() && !tableInfo.isIgnoreUnhex();
        int capacity = keyColumns.stream().mapToInt(String::length).sum() + values.size() * 16;
        StringBuilder condition = new StringBuilder(capacity);
        condition.append("(");
        Iterator<String> iter = keyColumns.iterator();
        while (iter.hasNext()) {
            String columnName;
            String keyColumn = iter.next();
            Integer logicPosition = tableInfo.getLogicOffset(keyColumn);
            Integer offset = tableInfo.getPhysicOffset(logicPosition);
            if (offset == null || tableInfo.isVirtualColumn(columnName = tableInfo.getColumnName(logicPosition))) continue;
            condition.append(keyColumn);
            Object objValue = record.get(logicPosition);
            String value = objValue != null ? objValue.toString() : null;
            String columnType = tableInfo.getColumnTypeName(columnName);
            boolean isNullable = tableInfo.isNullable(columnName);
            if (isNullable && StringUtils.isEmpty(value) && !JdbcType.isNullAndEmptyDistinguished(columnType)) {
                value = null;
            }
            if (isNullable && "null".equalsIgnoreCase(value) && !JdbcType.isNullAndEmptyDistinguished(columnType)) {
                value = null;
            }
            if (value != null) {
                condition.append("=");
                if (useUnhex && JdbcType.isBinaryType(columnType)) {
                    condition.append("unhex(?)");
                } else {
                    condition.append("?");
                }
                values.add(value);
                psStmtSetters.add(tableInfo.getTypeHandler(columnName));
            } else {
                condition.append(" IS NULL");
            }
            if (!iter.hasNext()) continue;
            condition.append(" AND ");
        }
        return condition.append(")");
    }

    public static List<Record> parseStatement(Record record, TableInfo tableInfo) {
        try {
            SQLStatement statement = SQLUtils.parseSingleStatement((String)record.getOriginContent(), (String)tableInfo.getServer().name(), (SQLParserFeature[])new SQLParserFeature[0]);
            if (statement instanceof SQLInsertStatement) {
                List valuesClause = ((SQLInsertStatement)statement).getValuesList();
                ArrayList<Record> recordList = new ArrayList<Record>(valuesClause.size());
                boolean hasGeometryField = false;
                for (SQLInsertStatement.ValuesClause vc : valuesClause) {
                    int i = 0;
                    ArrayList<Object> colValues = new ArrayList<Object>(vc.getValues().size());
                    for (SQLExpr expr : vc.getValues()) {
                        Optional<GeometryObject> geometryObjectOptional;
                        String columnTypeName;
                        if (JdbcType.isMysqlGeometryType(columnTypeName = tableInfo.getColumnTypeName(i++)) && (geometryObjectOptional = SqlUtils.tryExtractGeometryWktWithSrid(tableInfo, expr)).isPresent()) {
                            GeometryObject geometryObject = geometryObjectOptional.get();
                            colValues.add(geometryObject);
                            hasGeometryField = true;
                            continue;
                        }
                        colValues.add(SqlUtils.extractValue(tableInfo, expr));
                    }
                    Record singleRecord = new Record(colValues);
                    if (hasGeometryField) {
                        singleRecord.setHasGeometryField(hasGeometryField);
                    }
                    recordList.add(singleRecord);
                }
                return recordList;
            }
            throw new UnsupportedOperationException("Unsupported statement: " + statement.getClass());
        }
        catch (Exception e) {
            record.setParsed(false);
            record.setBadCause(e.getMessage());
            return Lists.newArrayList((Object[])new Record[]{record});
        }
    }

    private static String extractValue(TableInfo tableInfo, SQLExpr expr) {
        if (expr instanceof SQLCharExpr) {
            return String.valueOf(((SQLCharExpr)expr).getValue());
        }
        if (expr instanceof SQLNullExpr) {
            return null;
        }
        if (expr instanceof SQLHexExpr) {
            return ((SQLHexExpr)expr).getHex();
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            String methodName = ((SQLMethodInvokeExpr)expr).getMethodName();
            if ("sdo_geometry".equalsIgnoreCase(methodName)) {
                return expr.toString();
            }
            StringBuilder sb = new StringBuilder(1024);
            List arguments = ((SQLMethodInvokeExpr)expr).getArguments();
            boolean needMethodName = false;
            Iterator iter = arguments.iterator();
            while (iter.hasNext()) {
                if (!tableInfo.isIgnoreUnhex() && ("unhex".equalsIgnoreCase(methodName) || "HEXTORAW".equalsIgnoreCase(methodName))) {
                    sb.append(SqlUtils.extractValue(tableInfo, (SQLExpr)iter.next()));
                } else {
                    if ("to_date".equalsIgnoreCase(methodName) || "to_timestamp".equalsIgnoreCase(methodName) || "to_timestamp_tz".equalsIgnoreCase(methodName)) {
                        sb.append(SqlUtils.extractValue(tableInfo, (SQLExpr)iter.next()));
                        break;
                    }
                    sb.append("'").append(SqlUtils.extractValue(tableInfo, (SQLExpr)iter.next())).append("'");
                    needMethodName = true;
                }
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            if (!needMethodName) {
                return sb.toString();
            }
            return methodName + "(" + sb + ")";
        }
        return String.valueOf(((SQLValuableExpr)expr).getValue());
    }

    private static Optional<GeometryObject> tryExtractGeometryWktWithSrid(TableInfo tableInfo, SQLExpr expr) {
        if (!(expr instanceof SQLMethodInvokeExpr)) {
            return Optional.empty();
        }
        String methodName = ((SQLMethodInvokeExpr)expr).getMethodName();
        if (!"ST_GEOMFROMTEXT".equalsIgnoreCase(methodName)) {
            return Optional.empty();
        }
        List arguments = ((SQLMethodInvokeExpr)expr).getArguments();
        assert (arguments.size() > 0 && arguments.size() <= 2);
        String wktText = SqlUtils.extractValue(tableInfo, (SQLExpr)arguments.get(0));
        String srid = arguments.size() == 2 ? SqlUtils.extractValue(tableInfo, (SQLExpr)arguments.get(1)) : null;
        return Optional.of(new GeometryObject(wktText, srid));
    }

    public static boolean isAlmostTheSame(String duplicate, String constraint) {
        String[] constraints;
        if (duplicate == null || constraint == null) {
            return false;
        }
        String[] duplicates = duplicate.split("-");
        if (duplicates.length != (constraints = constraint.split("-")).length) {
            return false;
        }
        for (int i = 0; i < duplicates.length; ++i) {
            String duplic = duplicates[i];
            String constr = constraints[i];
            if (i > 1 && duplic.matches(SUB_TIME_REGEX)) {
                String timeStr1 = duplicates[i - 2] + "-" + duplicates[i - 1] + "-" + duplic;
                String timeStr2 = constraints[i - 2] + "-" + constraints[i - 1] + "-" + constr;
                String format = constr.contains(":") ? Constants.DEFAULT_TIMESTAMP_PATTERN : Constants.DEFAULT_MYSQL_DATE_PATTERN;
                try {
                    Timestamp timestamp1 = Timestamp.valueOf(timeStr1);
                    Timestamp timestamp2 = new Timestamp(new SimpleDateFormat(format).parse(timeStr2).getTime());
                    if (timestamp1.equals(timestamp2)) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (duplic.matches(FLOAT_REGEX)) {
                duplic = NumberUtils.trimTailZero(duplic);
            }
            if (constr.matches(FLOAT_REGEX)) {
                constr = NumberUtils.trimTailZero(constr);
            }
            if (StringUtils.equals(duplic, constr)) continue;
            return false;
        }
        return true;
    }

    public static String buildExcludeCondition(Collection<String> excludeTables, ServerMode serverMode, String columnName) {
        String regexTableNames = excludeTables.stream().filter(e -> e.contains("*")).map(e -> "^" + e.replaceAll("\\*", ".*") + "$").collect(Collectors.joining("|"));
        String exactTableNames = excludeTables.stream().filter(e -> !e.contains("*")).map(e -> "'" + e + "'").collect(Collectors.joining(","));
        StringBuilder sb = new StringBuilder(256);
        if (StringUtils.isNotEmpty(regexTableNames)) {
            if (ServerMode.ORACLE.equals((Object)serverMode)) {
                sb.append("NOT regexp_like(").append(columnName).append(",").append("'").append(regexTableNames).append("'").append(")");
            } else {
                sb.append(columnName).append(" NOT regexp(").append("'").append(regexTableNames).append("'").append(")");
            }
            if (StringUtils.isNotEmpty(exactTableNames)) {
                sb.append(" AND ");
            }
        }
        return StringUtils.isBlank(exactTableNames) ? sb.toString() : sb.append(columnName).append(" NOT IN (").append(exactTableNames).append(")").toString();
    }

    public static String buildIncludeCondition(Collection<String> includeTables, ServerMode serverMode, String columnName) {
        String regexTableNames = includeTables.stream().filter(e -> e.contains("*")).map(e -> "^" + e.replaceAll("\\*", ".*") + "$").collect(Collectors.joining("|"));
        String exactTableNames = includeTables.stream().filter(e -> !e.contains("*")).map(e -> "'" + e + "'").collect(Collectors.joining(","));
        StringBuilder sb = new StringBuilder(256);
        sb.append("(");
        if (StringUtils.isNotEmpty(regexTableNames)) {
            if (ServerMode.ORACLE.equals((Object)serverMode)) {
                sb.append("regexp_like(").append(columnName).append(",").append("'").append(regexTableNames).append("'").append(")");
            } else {
                sb.append(columnName).append(" regexp(").append("'").append(regexTableNames).append("'").append(")");
            }
            if (StringUtils.isNotEmpty(exactTableNames)) {
                sb.append(" OR ");
            }
        }
        return StringUtils.isBlank(exactTableNames) ? sb.append(")").toString() : sb.append(columnName).append(" IN (").append(exactTableNames).append("))").toString();
    }

    public static String removeIncompatibleSnippet(String sql) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(sql), (Object)"sql is null");
        int len = sql.length();
        int tokenCount = 0;
        StringBuilder token = new StringBuilder(16);
        StringBuilder objectType = new StringBuilder(16);
        for (int i = 0; i < len; ++i) {
            char ch = sql.charAt(i);
            if (ch != ' ') {
                token.append(ch);
                continue;
            }
            if (token.length() <= 0) continue;
            if (++tokenCount == 1 && StringUtils.notEqualsIgnoreCase("create", token)) {
                return sql;
            }
            if (tokenCount > 5) {
                return sql;
            }
            if (StringUtils.equalsIgnoreCase("if", token)) {
                objectType.append(sql, 0, i - 2);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("exists", token)) {
                return objectType + sql.substring(i);
            }
            if (StringUtils.equalsIgnoreCase("replace", token)) {
                return "create" + sql.substring(i);
            }
            token.setLength(0);
        }
        return sql;
    }
}

