/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.io;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.io.InputStreamWrapper;
import com.obs.services.internal.io.InterruptableInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;

public class HttpMethodReleaseInputStream
extends InputStream
implements InputStreamWrapper {
    private static final ILogger interfaceLog = LoggerBuilder.getLogger("com.obs.services.internal.RestStorageService");
    private InputStream inputStream = null;
    private Response httpResponse = null;
    private boolean flag = false;
    private boolean comsumed = false;

    public HttpMethodReleaseInputStream(Response response) {
        this.httpResponse = response;
        try {
            this.inputStream = new InterruptableInputStream(response.body().byteStream());
        }
        catch (Exception e) {
            try {
                response.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = new ByteArrayInputStream(new byte[0]);
        }
    }

    public Response getHttpResponse() {
        return this.httpResponse;
    }

    protected void releaseConnection() throws IOException {
        if (!this.flag) {
            if (!this.comsumed && this.httpResponse != null) {
                this.httpResponse.close();
            }
            this.flag = true;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int read = this.inputStream.read();
            if (read == -1) {
                this.comsumed = true;
                if (!this.flag) {
                    this.releaseConnection();
                }
            }
            return read;
        }
        catch (IOException e) {
            try {
                this.releaseConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = this.inputStream.read(b, off, len);
            if (read == -1) {
                this.comsumed = true;
                if (!this.flag) {
                    this.releaseConnection();
                }
            }
            return read;
        }
        catch (IOException e) {
            try {
                this.releaseConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            try {
                this.releaseConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.flag) {
            this.releaseConnection();
        }
        this.inputStream.close();
    }

    protected void finalize() throws Throwable {
        if (!this.flag) {
            this.releaseConnection();
            if (interfaceLog.isWarnEnabled()) {
                interfaceLog.warn("Successfully released HttpMethod in finalize().");
            }
        }
        super.finalize();
    }

    @Override
    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }
}

