/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.lang.reflect.ParameterizedType;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public abstract class TypeBuilder<T> {
    private final Class<T> rawType;
    private final java.lang.reflect.Type[] actualTypeArguments;

    public TypeBuilder() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        java.lang.reflect.Type type = parameterizedType.getActualTypeArguments()[0];
        if (type instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)type;
            this.rawType = (Class)parameterizedType.getRawType();
            this.actualTypeArguments = parameterizedType.getActualTypeArguments();
        } else {
            this.rawType = (Class)type;
            this.actualTypeArguments = new java.lang.reflect.Type[0];
        }
    }

    public TypeBuilder(Type<?> ... types) {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        java.lang.reflect.Type type = parameterizedType.getActualTypeArguments()[0];
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException(type + " is not a parameterized type");
        }
        parameterizedType = (ParameterizedType)type;
        this.rawType = (Class)parameterizedType.getRawType();
        if (types.length != this.rawType.getTypeParameters().length) {
            throw new IllegalArgumentException("wrong number of type arguments; expected " + this.rawType.getTypeParameters().length + ", but received " + types.length);
        }
        this.actualTypeArguments = (java.lang.reflect.Type[])types.clone();
    }

    public final Type<T> build() {
        return TypeFactory.valueOf(this.rawType, this.actualTypeArguments);
    }
}

