/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClassHelper {
    private ClassHelper() {
    }

    public static <T> Class<?> findParameterClass(int paramNum, Class<? extends T> subclass, Class<? extends T> classWithParameter) {
        return ClassHelper.findParameterClasses(subclass, classWithParameter).get(paramNum);
    }

    public static <T> List<Class<?>> findParameterClasses(Class<? extends T> subclass, Class<? extends T> classWithParameter) {
        ArrayList parameterClasses = null;
        TypeVariable<Class<? extends T>>[] params = classWithParameter.getTypeParameters();
        if (params.length > 0) {
            parameterClasses = new ArrayList(params.length);
            HashMap varsPrevious = new HashMap(3);
            HashMap varsCurrent = new HashMap(3);
            Type parent = subclass;
            while ((parent = ClassHelper.getGenericSuperType(parent, classWithParameter)) != null) {
                if (parent instanceof ParameterizedType) {
                    ParameterizedType pa = (ParameterizedType)parent;
                    TypeVariable<Class<?>>[] pars = ClassHelper.getClass(pa.getRawType()).getTypeParameters();
                    int i = 0;
                    for (Type t : pa.getActualTypeArguments()) {
                        if (t instanceof TypeVariable) {
                            varsCurrent.put(pars[i++], varsPrevious.containsKey(t) ? (Class)varsPrevious.get(t) : null);
                            continue;
                        }
                        varsCurrent.put(pars[i++], ClassHelper.getClass(t));
                    }
                    parent = pa.getRawType();
                }
                varsPrevious.clear();
                varsPrevious.putAll(varsCurrent);
                varsCurrent.clear();
            }
            for (TypeVariable<Class<? extends T>> tv : params) {
                parameterClasses.add(varsPrevious.get(tv));
            }
        }
        return parameterClasses;
    }

    public static <T> Type getGenericSuperType(Class<? extends T> subclass, Class<? extends T> classWithParameter) {
        if (subclass.getSuperclass() != null && classWithParameter.isAssignableFrom(subclass.getSuperclass())) {
            return subclass.getGenericSuperclass();
        }
        int i = 0;
        for (Class<?> in : subclass.getInterfaces()) {
            if (classWithParameter.isAssignableFrom(in)) {
                return subclass.getGenericInterfaces()[i];
            }
            ++i;
        }
        return null;
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ClassHelper.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        if (type instanceof TypeVariable) {
            return null;
        }
        if (type instanceof WildcardType) {
            return null;
        }
        return null;
    }
}

