/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.EnumMap;
import java.util.TimeZone;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DateColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.io.filter.FilterContext;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.DateUtils;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.SchemaEvolution;
import org.apache.orc.impl.SerializationUtils;
import org.apache.orc.impl.TreeReaderFactory;
import org.apache.orc.impl.reader.StripePlanner;
import org.apache.orc.impl.reader.tree.TypeReader;
import org.threeten.extra.chrono.HybridChronology;

public class ConvertTreeReaderFactory
extends TreeReaderFactory {
    static final DateTimeFormatter DATE_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    static final DateTimeFormatter TIMESTAMP_FORMAT = new DateTimeFormatterBuilder().append(DATE_FORMAT).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    static final DateTimeFormatter INSTANT_TIMESTAMP_FORMAT = new DateTimeFormatterBuilder().append(TIMESTAMP_FORMAT).appendPattern(" VV").toFormatter();
    static final long MIN_EPOCH_SECONDS = Instant.MIN.getEpochSecond();
    static final long MAX_EPOCH_SECONDS = Instant.MAX.getEpochSecond();

    private static TypeReader createFromInteger(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
        switch (fileType.getCategory()) {
            case BOOLEAN: {
                return new TreeReaderFactory.BooleanTreeReader(columnId, context);
            }
            case BYTE: {
                return new TreeReaderFactory.ByteTreeReader(columnId, context);
            }
            case SHORT: {
                return new TreeReaderFactory.ShortTreeReader(columnId, context);
            }
            case INT: {
                return new TreeReaderFactory.IntTreeReader(columnId, context);
            }
            case LONG: {
                return new TreeReaderFactory.LongTreeReader(columnId, context);
            }
        }
        throw new RuntimeException("Unexpected type kind " + fileType);
    }

    static Instant timestampToInstant(TimestampColumnVector vector, int element) {
        return Instant.ofEpochSecond(Math.floorDiv(vector.time[element], 1000L), vector.nanos[element]);
    }

    static Instant decimalToInstant(DecimalColumnVector vector, int element, HiveDecimalWritable value) {
        HiveDecimalWritable writable = vector.vector[element];
        long seconds = writable.longValue();
        if (seconds < MIN_EPOCH_SECONDS || seconds > MAX_EPOCH_SECONDS) {
            return null;
        }
        value.set(writable);
        value.mutateFractionPortion();
        value.mutateScaleByPowerOfTen(9);
        int nanos = (int)value.longValue();
        return Instant.ofEpochSecond(seconds, nanos);
    }

    private static TypeReader createBooleanConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                if (fileType.getCategory() == readerType.getCategory()) {
                    throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
                }
                return new AnyIntegerFromAnyIntegerTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DoubleFromAnyIntegerTreeReader(columnId, fileType, context);
            }
            case DECIMAL: {
                return new DecimalFromAnyIntegerTreeReader(columnId, fileType, context);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromBooleanTreeReader(columnId, fileType, readerType, context);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new TimestampFromAnyIntegerTreeReader(columnId, fileType, context, readerType.getCategory() == TypeDescription.Category.TIMESTAMP_INSTANT);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TypeReader createAnyIntegerConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                if (fileType.getCategory() == readerType.getCategory()) {
                    throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
                }
                return new AnyIntegerFromAnyIntegerTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DoubleFromAnyIntegerTreeReader(columnId, fileType, context);
            }
            case DECIMAL: {
                return new DecimalFromAnyIntegerTreeReader(columnId, fileType, context);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromAnyIntegerTreeReader(columnId, fileType, readerType, context);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new TimestampFromAnyIntegerTreeReader(columnId, fileType, context, readerType.getCategory() == TypeDescription.Category.TIMESTAMP_INSTANT);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TypeReader createDoubleConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromDoubleTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: {
                return new FloatFromDoubleTreeReader(columnId, context);
            }
            case DOUBLE: {
                return new TreeReaderFactory.FloatTreeReader(columnId, context);
            }
            case DECIMAL: {
                return new DecimalFromDoubleTreeReader(columnId, fileType, readerType, context);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromDoubleTreeReader(columnId, fileType, readerType, context);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new TimestampFromDoubleTreeReader(columnId, fileType, readerType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TypeReader createDecimalConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromDecimalTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DoubleFromDecimalTreeReader(columnId, fileType, context);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromDecimalTreeReader(columnId, fileType, readerType, context);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new TimestampFromDecimalTreeReader(columnId, fileType, context, readerType.getCategory() == TypeDescription.Category.TIMESTAMP_INSTANT);
            }
            case DECIMAL: {
                return new DecimalFromDecimalTreeReader(columnId, fileType, readerType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TypeReader createStringConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DoubleFromStringGroupTreeReader(columnId, fileType, context);
            }
            case DECIMAL: {
                return new DecimalFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case BINARY: {
                return new TreeReaderFactory.BinaryTreeReader(columnId, context);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new TimestampFromStringGroupTreeReader(columnId, fileType, context, readerType.getCategory() == TypeDescription.Category.TIMESTAMP_INSTANT);
            }
            case DATE: {
                return new DateFromStringGroupTreeReader(columnId, fileType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TypeReader createTimestampConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        boolean isInstant = fileType.getCategory() == TypeDescription.Category.TIMESTAMP_INSTANT;
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromTimestampTreeReader(columnId, readerType, context, isInstant);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DoubleFromTimestampTreeReader(columnId, context, isInstant);
            }
            case DECIMAL: {
                return new DecimalFromTimestampTreeReader(columnId, context, isInstant);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromTimestampTreeReader(columnId, readerType, context, isInstant);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new TreeReaderFactory.TimestampTreeReader(columnId, context, isInstant);
            }
            case DATE: {
                return new DateFromTimestampTreeReader(columnId, context, isInstant);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TypeReader createDateConvertTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromDateTreeReader(columnId, readerType, context);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new TimestampFromDateTreeReader(columnId, readerType, context);
            }
            case DATE: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TypeReader createBinaryConvertTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromBinaryTreeReader(columnId, readerType, context);
            }
            case BINARY: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    public static TypeReader createConvertTreeReader(TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        SchemaEvolution evolution = context.getSchemaEvolution();
        TypeDescription fileType = evolution.getFileType(readerType.getId());
        int columnId = fileType.getId();
        switch (fileType.getCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return ConvertTreeReaderFactory.createAnyIntegerConvertTreeReader(columnId, fileType, readerType, context);
            }
            case BOOLEAN: {
                return ConvertTreeReaderFactory.createBooleanConvertTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: 
            case DOUBLE: {
                return ConvertTreeReaderFactory.createDoubleConvertTreeReader(columnId, fileType, readerType, context);
            }
            case DECIMAL: {
                return ConvertTreeReaderFactory.createDecimalConvertTreeReader(columnId, fileType, readerType, context);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return ConvertTreeReaderFactory.createStringConvertTreeReader(columnId, fileType, readerType, context);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return ConvertTreeReaderFactory.createTimestampConvertTreeReader(columnId, fileType, readerType, context);
            }
            case DATE: {
                return ConvertTreeReaderFactory.createDateConvertTreeReader(columnId, readerType, context);
            }
            case BINARY: {
                return ConvertTreeReaderFactory.createBinaryConvertTreeReader(columnId, readerType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)fileType.getCategory()));
    }

    public static boolean canConvert(TypeDescription fileType, TypeDescription readerType) {
        TypeDescription.Category readerTypeCategory = readerType.getCategory();
        switch (readerTypeCategory) {
            case STRUCT: 
            case LIST: 
            case MAP: 
            case UNION: {
                return false;
            }
        }
        switch (fileType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                switch (readerType.getCategory()) {
                    case BINARY: 
                    case DATE: {
                        return false;
                    }
                }
                return true;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                switch (readerType.getCategory()) {
                    default: 
                }
                return true;
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                switch (readerType.getCategory()) {
                    case BINARY: {
                        return false;
                    }
                }
                return true;
            }
            case DATE: {
                switch (readerType.getCategory()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DECIMAL: 
                    case BINARY: {
                        return false;
                    }
                }
                return true;
            }
            case BINARY: {
                switch (readerType.getCategory()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DECIMAL: 
                    case TIMESTAMP: 
                    case TIMESTAMP_INSTANT: {
                        return false;
                    }
                }
                return true;
            }
            case STRUCT: 
            case LIST: 
            case MAP: 
            case UNION: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)fileType.getCategory()));
    }

    public static class DateFromTimestampTreeReader
    extends ConvertTreeReader {
        private TimestampColumnVector timestampColVector;
        private LongColumnVector longColVector;
        private final ZoneId local;
        private final boolean useProlepticGregorian;

        DateFromTimestampTreeReader(int columnId, TreeReaderFactory.Context context, boolean instantType) throws IOException {
            super(columnId, new TreeReaderFactory.TimestampTreeReader(columnId, context, instantType), context);
            boolean useUtc = instantType || context.getUseUTCTimestamp();
            this.local = useUtc ? ZoneId.of("UTC") : ZoneId.systemDefault();
            this.useProlepticGregorian = context.useProlepticGregorian();
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            LocalDate day = LocalDate.from(Instant.ofEpochSecond(this.timestampColVector.time[elementNum] / 1000L, this.timestampColVector.nanos[elementNum]).atZone(this.local));
            this.longColVector.vector[elementNum] = day.toEpochDay();
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector(batchSize);
                this.longColVector = (LongColumnVector)previousVector;
                if (this.useProlepticGregorian && !(this.longColVector instanceof DateColumnVector)) {
                    throw new IllegalArgumentException("Can't use LongColumnVector with proleptic Gregorian dates.");
                }
            } else {
                this.timestampColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.timestampColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.timestampColVector, (ColumnVector)this.longColVector, batchSize);
            if (this.longColVector instanceof DateColumnVector) {
                ((DateColumnVector)this.longColVector).changeCalendar(this.useProlepticGregorian, false);
            }
        }
    }

    public static class DateFromStringGroupTreeReader
    extends ConvertTreeReader {
        private BytesColumnVector bytesColVector;
        private LongColumnVector longColVector;
        private DateColumnVector dateColumnVector;
        private final boolean useProlepticGregorian;

        DateFromStringGroupTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, DateFromStringGroupTreeReader.getStringGroupTreeReader(columnId, fileType, context), context);
            this.useProlepticGregorian = context.useProlepticGregorian();
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            String stringValue = SerializationUtils.bytesVectorToString(this.bytesColVector, elementNum);
            Integer dateValue = DateUtils.parseDate(stringValue, this.useProlepticGregorian);
            if (dateValue != null) {
                this.longColVector.vector[elementNum] = dateValue.intValue();
            } else {
                this.longColVector.noNulls = false;
                this.longColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector(batchSize);
                this.longColVector = (LongColumnVector)previousVector;
                if (this.longColVector instanceof DateColumnVector) {
                    this.dateColumnVector = (DateColumnVector)this.longColVector;
                } else {
                    this.dateColumnVector = null;
                    if (this.useProlepticGregorian) {
                        throw new IllegalArgumentException("Can't use LongColumnVector with proleptic Gregorian dates.");
                    }
                }
            } else {
                this.bytesColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.bytesColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.bytesColVector, (ColumnVector)this.longColVector, batchSize);
            if (this.dateColumnVector != null) {
                this.dateColumnVector.changeCalendar(this.useProlepticGregorian, false);
            }
        }
    }

    public static class TimestampFromDateTreeReader
    extends ConvertTreeReader {
        private DateColumnVector longColVector;
        private TimestampColumnVector timestampColVector;
        private final boolean useUtc;
        private final TimeZone local = TimeZone.getDefault();
        private final boolean useProlepticGregorian;

        TimestampFromDateTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, new TreeReaderFactory.DateTreeReader(columnId, context), context);
            this.useUtc = readerType.getCategory() == TypeDescription.Category.TIMESTAMP_INSTANT || context.getUseUTCTimestamp();
            this.useProlepticGregorian = context.useProlepticGregorian();
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long days = this.longColVector.vector[elementNum];
            long millis = days * 24L * 60L * 60L * 1000L;
            this.timestampColVector.time[elementNum] = this.useUtc ? millis : SerializationUtils.convertFromUtc(this.local, millis);
            this.timestampColVector.nanos[elementNum] = 0;
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new DateColumnVector(batchSize);
                this.timestampColVector = (TimestampColumnVector)previousVector;
            } else {
                this.longColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.longColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.longColVector, (ColumnVector)this.timestampColVector, batchSize);
            this.timestampColVector.changeCalendar(this.useProlepticGregorian, false);
        }
    }

    public static class TimestampFromStringGroupTreeReader
    extends ConvertTreeReader {
        private BytesColumnVector bytesColVector;
        private TimestampColumnVector timestampColVector;
        private final DateTimeFormatter formatter;
        private final boolean useProlepticGregorian;

        TimestampFromStringGroupTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context, boolean isInstant) throws IOException {
            super(columnId, TimestampFromStringGroupTreeReader.getStringGroupTreeReader(columnId, fileType, context), context);
            AbstractChronology chronology;
            this.useProlepticGregorian = context.useProlepticGregorian();
            AbstractChronology abstractChronology = chronology = this.useProlepticGregorian ? IsoChronology.INSTANCE : HybridChronology.INSTANCE;
            this.formatter = isInstant ? INSTANT_TIMESTAMP_FORMAT.withChronology(chronology) : TIMESTAMP_FORMAT.withZone(context.getUseUTCTimestamp() ? ZoneId.of("UTC") : ZoneId.systemDefault()).withChronology(chronology);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String str = SerializationUtils.bytesVectorToString(this.bytesColVector, elementNum);
            try {
                Instant instant = Instant.from(this.formatter.parse(str));
                this.timestampColVector.time[elementNum] = instant.toEpochMilli();
                this.timestampColVector.nanos[elementNum] = instant.getNano();
            }
            catch (DateTimeParseException e) {
                this.timestampColVector.noNulls = false;
                this.timestampColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector(batchSize);
                this.timestampColVector = (TimestampColumnVector)previousVector;
            } else {
                this.bytesColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.bytesColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.bytesColVector, (ColumnVector)this.timestampColVector, batchSize);
            this.timestampColVector.changeCalendar(this.useProlepticGregorian, false);
        }
    }

    public static class TimestampFromDecimalTreeReader
    extends ConvertTreeReader {
        private final int precision;
        private final int scale;
        private DecimalColumnVector decimalColVector;
        private TimestampColumnVector timestampColVector;
        private final boolean useUtc;
        private final TimeZone local;
        private final boolean useProlepticGregorian;
        private final boolean fileUsedProlepticGregorian;
        private final HiveDecimalWritable value;

        TimestampFromDecimalTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context, boolean isInstant) throws IOException {
            super(columnId, new TreeReaderFactory.DecimalTreeReader(columnId, fileType.getPrecision(), fileType.getScale(), context), context);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.useUtc = isInstant || context.getUseUTCTimestamp();
            this.local = TimeZone.getDefault();
            this.useProlepticGregorian = context.useProlepticGregorian();
            this.fileUsedProlepticGregorian = context.fileUsedProlepticGregorian();
            this.value = new HiveDecimalWritable();
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            Instant t = ConvertTreeReaderFactory.decimalToInstant(this.decimalColVector, elementNum, this.value);
            if (t == null) {
                this.timestampColVector.noNulls = false;
                this.timestampColVector.isNull[elementNum] = true;
            } else if (!this.useUtc) {
                long millis = t.toEpochMilli();
                this.timestampColVector.time[elementNum] = SerializationUtils.convertFromUtc(this.local, millis);
                this.timestampColVector.nanos[elementNum] = t.getNano();
            } else {
                this.timestampColVector.time[elementNum] = t.toEpochMilli();
                this.timestampColVector.nanos[elementNum] = t.getNano();
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(batchSize, this.precision, this.scale);
                this.timestampColVector = (TimestampColumnVector)previousVector;
            } else {
                this.decimalColVector.ensureSize(batchSize, false);
            }
            this.timestampColVector.changeCalendar(this.fileUsedProlepticGregorian, false);
            this.fromReader.nextVector((ColumnVector)this.decimalColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.decimalColVector, (ColumnVector)this.timestampColVector, batchSize);
            this.timestampColVector.changeCalendar(this.useProlepticGregorian, true);
        }
    }

    public static class TimestampFromDoubleTreeReader
    extends ConvertTreeReader {
        private DoubleColumnVector doubleColVector;
        private TimestampColumnVector timestampColVector;
        private final boolean useUtc;
        private final TimeZone local;
        private final boolean useProlepticGregorian;
        private final boolean fileUsedProlepticGregorian;

        TimestampFromDoubleTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, fileType.getCategory() == TypeDescription.Category.DOUBLE ? new TreeReaderFactory.DoubleTreeReader(columnId, context) : new TreeReaderFactory.FloatTreeReader(columnId, context), context);
            this.useUtc = readerType.getCategory() == TypeDescription.Category.TIMESTAMP_INSTANT || context.getUseUTCTimestamp();
            this.local = TimeZone.getDefault();
            this.useProlepticGregorian = context.useProlepticGregorian();
            this.fileUsedProlepticGregorian = context.fileUsedProlepticGregorian();
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            double seconds = this.doubleColVector.vector[elementNum];
            if (!this.useUtc) {
                seconds = SerializationUtils.convertFromUtc(this.local, seconds);
            }
            double doubleMillis = seconds * 1000.0;
            long millis = Math.round(doubleMillis);
            if (doubleMillis > 9.223372036854776E18 || doubleMillis < -9.223372036854776E18 || millis >= 0L != doubleMillis >= 0.0) {
                this.timestampColVector.time[elementNum] = 0L;
                this.timestampColVector.nanos[elementNum] = 0;
                this.timestampColVector.isNull[elementNum] = true;
                this.timestampColVector.noNulls = false;
            } else {
                this.timestampColVector.time[elementNum] = millis;
                this.timestampColVector.nanos[elementNum] = (int)Math.floorMod(millis, 1000L) * 1000000;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector(batchSize);
                this.timestampColVector = (TimestampColumnVector)previousVector;
            } else {
                this.doubleColVector.ensureSize(batchSize, false);
            }
            this.timestampColVector.changeCalendar(this.fileUsedProlepticGregorian, false);
            this.fromReader.nextVector((ColumnVector)this.doubleColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.doubleColVector, (ColumnVector)this.timestampColVector, batchSize);
            this.timestampColVector.changeCalendar(this.useProlepticGregorian, true);
        }
    }

    public static class TimestampFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private LongColumnVector longColVector;
        private TimestampColumnVector timestampColVector;
        private final boolean useUtc;
        private final TimeZone local;
        private final boolean fileUsedProlepticGregorian;
        private final boolean useProlepticGregorian;

        TimestampFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context, boolean isInstant) throws IOException {
            super(columnId, ConvertTreeReaderFactory.createFromInteger(columnId, fileType, context), context);
            this.useUtc = isInstant || context.getUseUTCTimestamp();
            this.local = TimeZone.getDefault();
            this.fileUsedProlepticGregorian = context.fileUsedProlepticGregorian();
            this.useProlepticGregorian = context.useProlepticGregorian();
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long millis = this.longColVector.vector[elementNum] * 1000L;
            this.timestampColVector.time[elementNum] = this.useUtc ? millis : SerializationUtils.convertFromUtc(this.local, millis);
            this.timestampColVector.nanos[elementNum] = 0;
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector(batchSize);
                this.timestampColVector = (TimestampColumnVector)previousVector;
            } else {
                this.longColVector.ensureSize(batchSize, false);
            }
            this.timestampColVector.changeCalendar(this.fileUsedProlepticGregorian, false);
            this.fromReader.nextVector((ColumnVector)this.longColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.longColVector, (ColumnVector)this.timestampColVector, batchSize);
            this.timestampColVector.changeCalendar(this.useProlepticGregorian, true);
        }
    }

    public static class StringGroupFromBinaryTreeReader
    extends ConvertTreeReader {
        private final TypeDescription readerType;
        private BytesColumnVector inBytesColVector;
        private BytesColumnVector outBytesColVector;

        StringGroupFromBinaryTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, new TreeReaderFactory.BinaryTreeReader(columnId, context), context);
            this.readerType = readerType;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            byte[] bytes = this.inBytesColVector.vector[elementNum];
            int start = this.inBytesColVector.start[elementNum];
            int length = this.inBytesColVector.length[elementNum];
            byte[] string = length == 0 ? ArrayUtils.EMPTY_BYTE_ARRAY : new byte[3 * length - 1];
            for (int p = 0; p < string.length; p += 2) {
                int num;
                int digit;
                if (p != 0) {
                    string[p++] = 32;
                }
                string[p] = (byte)(digit + ((digit = (num = 0xFF & bytes[start++]) / 16) < 10 ? 48 : 87));
                digit = num % 16;
                string[p + 1] = (byte)(digit + (digit < 10 ? 48 : 87));
            }
            this.assignStringGroupVectorEntry(this.outBytesColVector, elementNum, this.readerType, string, 0, string.length);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.inBytesColVector == null) {
                this.inBytesColVector = new BytesColumnVector(batchSize);
                this.outBytesColVector = (BytesColumnVector)previousVector;
            } else {
                this.inBytesColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.inBytesColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.inBytesColVector, (ColumnVector)this.outBytesColVector, batchSize);
        }
    }

    public static class StringGroupFromStringGroupTreeReader
    extends ConvertTreeReader {
        private final TypeDescription readerType;

        StringGroupFromStringGroupTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, StringGroupFromStringGroupTreeReader.getStringGroupTreeReader(columnId, fileType, context), context);
            this.readerType = readerType;
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            block5: {
                BytesColumnVector resultColVector;
                block4: {
                    this.fromReader.nextVector(previousVector, isNull, batchSize, filterContext, readPhase);
                    resultColVector = (BytesColumnVector)previousVector;
                    if (!resultColVector.isRepeating) break block4;
                    if (!resultColVector.noNulls && resultColVector.isNull[0]) break block5;
                    this.convertStringGroupVectorElement(resultColVector, 0, this.readerType);
                    break block5;
                }
                if (resultColVector.noNulls) {
                    for (int i = 0; i < batchSize; ++i) {
                        this.convertStringGroupVectorElement(resultColVector, i, this.readerType);
                    }
                } else {
                    for (int i = 0; i < batchSize; ++i) {
                        if (resultColVector.isNull[i]) continue;
                        this.convertStringGroupVectorElement(resultColVector, i, this.readerType);
                    }
                }
            }
        }
    }

    public static class StringGroupFromDateTreeReader
    extends ConvertTreeReader {
        private final TypeDescription readerType;
        private DateColumnVector longColVector;
        private BytesColumnVector bytesColVector;
        private final boolean useProlepticGregorian;

        StringGroupFromDateTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, new TreeReaderFactory.DateTreeReader(columnId, context), context);
            this.readerType = readerType;
            this.useProlepticGregorian = context.useProlepticGregorian();
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            String dateStr = DateUtils.printDate((int)this.longColVector.vector[elementNum], this.useProlepticGregorian);
            byte[] bytes = dateStr.getBytes(StandardCharsets.UTF_8);
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new DateColumnVector(batchSize);
                this.bytesColVector = (BytesColumnVector)previousVector;
            } else {
                this.longColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.longColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.longColVector, (ColumnVector)this.bytesColVector, batchSize);
        }
    }

    public static class StringGroupFromTimestampTreeReader
    extends ConvertTreeReader {
        private final TypeDescription readerType;
        private final ZoneId local;
        private final DateTimeFormatter formatter;
        private TimestampColumnVector timestampColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromTimestampTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context, boolean instantType) throws IOException {
            super(columnId, new TreeReaderFactory.TimestampTreeReader(columnId, context, instantType), context);
            this.readerType = readerType;
            this.local = context.getUseUTCTimestamp() ? ZoneId.of("UTC") : ZoneId.systemDefault();
            AbstractChronology chronology = context.useProlepticGregorian() ? IsoChronology.INSTANCE : HybridChronology.INSTANCE;
            this.formatter = (instantType ? INSTANT_TIMESTAMP_FORMAT : TIMESTAMP_FORMAT).withChronology(chronology);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = ConvertTreeReaderFactory.timestampToInstant(this.timestampColVector, elementNum).atZone(this.local).format(this.formatter);
            byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector(batchSize);
                this.bytesColVector = (BytesColumnVector)previousVector;
            } else {
                this.timestampColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.timestampColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.timestampColVector, (ColumnVector)this.bytesColVector, batchSize);
        }
    }

    public static class StringGroupFromDecimalTreeReader
    extends ConvertTreeReader {
        private int precision;
        private int scale;
        private final TypeDescription readerType;
        private DecimalColumnVector decimalColVector;
        private BytesColumnVector bytesColVector;
        private byte[] scratchBuffer;

        StringGroupFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, new TreeReaderFactory.DecimalTreeReader(columnId, fileType.getPrecision(), fileType.getScale(), context), context);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.readerType = readerType;
            this.scratchBuffer = new byte[79];
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            HiveDecimalWritable decWritable = this.decimalColVector.vector[elementNum];
            int byteIndex = decWritable.toBytes(this.scratchBuffer);
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, this.scratchBuffer, byteIndex, 79 - byteIndex);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(batchSize, this.precision, this.scale);
                this.bytesColVector = (BytesColumnVector)previousVector;
            } else {
                this.decimalColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.decimalColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.decimalColVector, (ColumnVector)this.bytesColVector, batchSize);
        }
    }

    public static class StringGroupFromDoubleTreeReader
    extends ConvertTreeReader {
        private final TypeDescription readerType;
        private DoubleColumnVector doubleColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromDoubleTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, fileType.getCategory() == TypeDescription.Category.DOUBLE ? new TreeReaderFactory.DoubleTreeReader(columnId, context) : new TreeReaderFactory.FloatTreeReader(columnId, context), context);
            this.readerType = readerType;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            double doubleValue = this.doubleColVector.vector[elementNum];
            if (!Double.isNaN(doubleValue)) {
                String string = Double.toString(doubleValue);
                byte[] bytes = string.getBytes(StandardCharsets.US_ASCII);
                this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
            } else {
                this.bytesColVector.noNulls = false;
                this.bytesColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector(batchSize);
                this.bytesColVector = (BytesColumnVector)previousVector;
            } else {
                this.doubleColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.doubleColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.doubleColVector, (ColumnVector)this.bytesColVector, batchSize);
        }
    }

    public static class StringGroupFromBooleanTreeReader
    extends StringGroupFromAnyIntegerTreeReader {
        private static final byte[] TRUE_BYTES = "TRUE".getBytes(StandardCharsets.US_ASCII);
        private static final byte[] FALSE_BYTES = "FALSE".getBytes(StandardCharsets.US_ASCII);

        StringGroupFromBooleanTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, fileType, readerType, context);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            byte[] bytes = this.longColVector.vector[elementNum] != 0L ? TRUE_BYTES : FALSE_BYTES;
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }
    }

    public static class StringGroupFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        protected final TypeDescription readerType;
        protected LongColumnVector longColVector;
        protected BytesColumnVector bytesColVector;

        StringGroupFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, ConvertTreeReaderFactory.createFromInteger(columnId, fileType, context), context);
            this.readerType = readerType;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            byte[] bytes = Long.toString(this.longColVector.vector[elementNum]).getBytes(StandardCharsets.UTF_8);
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector(batchSize);
                this.bytesColVector = (BytesColumnVector)previousVector;
            } else {
                this.longColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.longColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.longColVector, (ColumnVector)this.bytesColVector, batchSize);
        }
    }

    public static class DecimalFromDecimalTreeReader
    extends ConvertTreeReader {
        private DecimalColumnVector fileDecimalColVector;
        private int filePrecision;
        private int fileScale;
        private ColumnVector decimalColVector;

        DecimalFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, new TreeReaderFactory.DecimalTreeReader(columnId, fileType.getPrecision(), fileType.getScale(), context), context);
            this.filePrecision = fileType.getPrecision();
            this.fileScale = fileType.getScale();
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            if (this.decimalColVector instanceof Decimal64ColumnVector) {
                ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, this.fileDecimalColVector.vector[elementNum]);
            } else {
                ((DecimalColumnVector)this.decimalColVector).set(elementNum, this.fileDecimalColVector.vector[elementNum]);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.fileDecimalColVector == null) {
                this.fileDecimalColVector = new DecimalColumnVector(batchSize, this.filePrecision, this.fileScale);
                this.decimalColVector = previousVector;
            } else {
                this.fileDecimalColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.fileDecimalColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.fileDecimalColVector, this.decimalColVector, batchSize);
        }
    }

    public static class DecimalFromTimestampTreeReader
    extends ConvertTreeReader {
        private TimestampColumnVector timestampColVector;
        private ColumnVector decimalColVector;

        DecimalFromTimestampTreeReader(int columnId, TreeReaderFactory.Context context, boolean instantType) throws IOException {
            super(columnId, new TreeReaderFactory.TimestampTreeReader(columnId, context, instantType), context);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            long seconds = Math.floorDiv(this.timestampColVector.time[elementNum], 1000L);
            long nanos = this.timestampColVector.nanos[elementNum];
            if (seconds < 0L && nanos > 0L) {
                ++seconds;
                nanos = 1000000000L - nanos;
            }
            BigDecimal secondsBd = new BigDecimal(seconds);
            BigDecimal nanosBd = new BigDecimal(nanos).movePointLeft(9);
            BigDecimal resultBd = seconds >= 0L ? secondsBd.add(nanosBd) : secondsBd.subtract(nanosBd);
            HiveDecimal value = HiveDecimal.create((BigDecimal)resultBd);
            if (value != null) {
                if (this.decimalColVector instanceof Decimal64ColumnVector) {
                    ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, value);
                } else {
                    ((DecimalColumnVector)this.decimalColVector).set(elementNum, value);
                }
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector(batchSize);
                this.decimalColVector = previousVector;
            } else {
                this.timestampColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.timestampColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.timestampColVector, this.decimalColVector, batchSize);
        }
    }

    public static class DecimalFromStringGroupTreeReader
    extends ConvertTreeReader {
        private BytesColumnVector bytesColVector;
        private ColumnVector decimalColVector;

        DecimalFromStringGroupTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, DecimalFromStringGroupTreeReader.getStringGroupTreeReader(columnId, fileType, context), context);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = SerializationUtils.bytesVectorToString(this.bytesColVector, elementNum);
            HiveDecimal value = this.parseDecimalFromString(string);
            if (value != null) {
                if (this.decimalColVector instanceof Decimal64ColumnVector) {
                    ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, value);
                } else {
                    ((DecimalColumnVector)this.decimalColVector).set(elementNum, value);
                }
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector(batchSize);
                this.decimalColVector = previousVector;
            } else {
                this.bytesColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.bytesColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.bytesColVector, this.decimalColVector, batchSize);
        }
    }

    public static class DecimalFromDoubleTreeReader
    extends ConvertTreeReader {
        private DoubleColumnVector doubleColVector;
        private ColumnVector decimalColVector;

        DecimalFromDoubleTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, fileType.getCategory() == TypeDescription.Category.DOUBLE ? new TreeReaderFactory.DoubleTreeReader(columnId, context) : new TreeReaderFactory.FloatTreeReader(columnId, context), context);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            HiveDecimal value = HiveDecimal.create((String)Double.toString(this.doubleColVector.vector[elementNum]));
            if (value != null) {
                if (this.decimalColVector instanceof Decimal64ColumnVector) {
                    ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, value);
                } else {
                    ((DecimalColumnVector)this.decimalColVector).set(elementNum, value);
                }
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector(batchSize);
                this.decimalColVector = previousVector;
            } else {
                this.doubleColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.doubleColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.doubleColVector, this.decimalColVector, batchSize);
        }
    }

    public static class DecimalFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private LongColumnVector longColVector;
        private ColumnVector decimalColVector;
        private final HiveDecimalWritable value = new HiveDecimalWritable();

        DecimalFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, ConvertTreeReaderFactory.createFromInteger(columnId, fileType, context), context);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long longValue = this.longColVector.vector[elementNum];
            this.value.setFromLong(longValue);
            if (this.decimalColVector instanceof Decimal64ColumnVector) {
                ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, this.value);
            } else {
                ((DecimalColumnVector)this.decimalColVector).set(elementNum, this.value);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector(batchSize);
                this.decimalColVector = previousVector;
            } else {
                this.longColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.longColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.longColVector, this.decimalColVector, batchSize);
        }
    }

    public static class FloatFromDoubleTreeReader
    extends ConvertTreeReader {
        FloatFromDoubleTreeReader(int columnId, TreeReaderFactory.Context context) throws IOException {
            super(columnId, new TreeReaderFactory.DoubleTreeReader(columnId, context), context);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            this.fromReader.nextVector(previousVector, isNull, batchSize, filterContext, readPhase);
            DoubleColumnVector vector = (DoubleColumnVector)previousVector;
            if (previousVector.isRepeating) {
                vector.vector[0] = (float)vector.vector[0];
            } else {
                for (int i = 0; i < batchSize; ++i) {
                    vector.vector[i] = (float)vector.vector[i];
                }
            }
        }
    }

    public static class DoubleFromTimestampTreeReader
    extends ConvertTreeReader {
        private TimestampColumnVector timestampColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromTimestampTreeReader(int columnId, TreeReaderFactory.Context context, boolean instantType) throws IOException {
            super(columnId, new TreeReaderFactory.TimestampTreeReader(columnId, context, instantType), context);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            Timestamp ts = this.timestampColVector.asScratchTimestamp(elementNum);
            double result = Math.floorDiv(ts.getTime(), 1000L);
            int nano = ts.getNanos();
            if (nano != 0) {
                result += (double)nano / 1.0E9;
            }
            this.doubleColVector.vector[elementNum] = result;
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector(batchSize);
                this.doubleColVector = (DoubleColumnVector)previousVector;
            } else {
                this.timestampColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.timestampColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.timestampColVector, (ColumnVector)this.doubleColVector, batchSize);
        }
    }

    public static class DoubleFromStringGroupTreeReader
    extends ConvertTreeReader {
        private BytesColumnVector bytesColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromStringGroupTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, DoubleFromStringGroupTreeReader.getStringGroupTreeReader(columnId, fileType, context), context);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = SerializationUtils.bytesVectorToString(this.bytesColVector, elementNum);
            double doubleValue = this.parseDoubleFromString(string);
            if (!this.getIsParseError()) {
                this.doubleColVector.vector[elementNum] = doubleValue;
            } else {
                this.doubleColVector.noNulls = false;
                this.doubleColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector(batchSize);
                this.doubleColVector = (DoubleColumnVector)previousVector;
            } else {
                this.bytesColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.bytesColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.bytesColVector, (ColumnVector)this.doubleColVector, batchSize);
        }
    }

    public static class DoubleFromDecimalTreeReader
    extends ConvertTreeReader {
        private final int precision;
        private final int scale;
        private DecimalColumnVector decimalColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromDecimalTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, new TreeReaderFactory.DecimalTreeReader(columnId, fileType.getPrecision(), fileType.getScale(), context), context);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.doubleColVector.vector[elementNum] = this.decimalColVector.vector[elementNum].doubleValue();
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(batchSize, this.precision, this.scale);
                this.doubleColVector = (DoubleColumnVector)previousVector;
            } else {
                this.decimalColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.decimalColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.decimalColVector, (ColumnVector)this.doubleColVector, batchSize);
        }
    }

    public static class DoubleFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private LongColumnVector longColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, ConvertTreeReaderFactory.createFromInteger(columnId, fileType, context), context);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            double doubleValue = this.longColVector.vector[elementNum];
            if (!Double.isNaN(doubleValue)) {
                this.doubleColVector.vector[elementNum] = doubleValue;
            } else {
                this.doubleColVector.vector[elementNum] = Double.NaN;
                this.doubleColVector.noNulls = false;
                this.doubleColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector(batchSize);
                this.doubleColVector = (DoubleColumnVector)previousVector;
            } else {
                this.longColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.longColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.longColVector, (ColumnVector)this.doubleColVector, batchSize);
        }
    }

    public static class AnyIntegerFromTimestampTreeReader
    extends ConvertTreeReader {
        private final TypeDescription readerType;
        private TimestampColumnVector timestampColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromTimestampTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context, boolean instantType) throws IOException {
            super(columnId, new TreeReaderFactory.TimestampTreeReader(columnId, context, instantType), context);
            this.readerType = readerType;
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long millis = this.timestampColVector.asScratchTimestamp(elementNum).getTime();
            long longValue = Math.floorDiv(millis, 1000L);
            this.downCastAnyInteger(this.longColVector, elementNum, longValue, this.readerType);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector(batchSize);
                this.longColVector = (LongColumnVector)previousVector;
            } else {
                this.timestampColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.timestampColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.timestampColVector, (ColumnVector)this.longColVector, batchSize);
        }
    }

    public static class AnyIntegerFromStringGroupTreeReader
    extends ConvertTreeReader {
        private final TypeDescription readerType;
        private BytesColumnVector bytesColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromStringGroupTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, AnyIntegerFromStringGroupTreeReader.getStringGroupTreeReader(columnId, fileType, context), context);
            this.readerType = readerType;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = SerializationUtils.bytesVectorToString(this.bytesColVector, elementNum);
            long longValue = this.parseLongFromString(string);
            if (!this.getIsParseError()) {
                this.downCastAnyInteger(this.longColVector, elementNum, longValue, this.readerType);
            } else {
                this.longColVector.noNulls = false;
                this.longColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector(batchSize);
                this.longColVector = (LongColumnVector)previousVector;
            } else {
                this.bytesColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.bytesColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.bytesColVector, (ColumnVector)this.longColVector, batchSize);
        }
    }

    public static class AnyIntegerFromDecimalTreeReader
    extends ConvertTreeReader {
        private final int precision;
        private final int scale;
        private final TypeDescription readerType;
        private DecimalColumnVector decimalColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, new TreeReaderFactory.DecimalTreeReader(columnId, fileType.getPrecision(), fileType.getScale(), context), context);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.readerType = readerType;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            boolean isInRange;
            HiveDecimalWritable decWritable = this.decimalColVector.vector[elementNum];
            long[] vector = this.longColVector.vector;
            TypeDescription.Category readerCategory = this.readerType.getCategory();
            switch (readerCategory) {
                case BOOLEAN: {
                    vector[elementNum] = decWritable.signum() == 0 ? 0L : 1L;
                    return;
                }
                case BYTE: {
                    isInRange = decWritable.isByte();
                    break;
                }
                case SHORT: {
                    isInRange = decWritable.isShort();
                    break;
                }
                case INT: {
                    isInRange = decWritable.isInt();
                    break;
                }
                case LONG: {
                    isInRange = decWritable.isLong();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + readerCategory.name());
                }
            }
            if (!isInRange) {
                this.longColVector.isNull[elementNum] = true;
                this.longColVector.noNulls = false;
            } else {
                switch (readerCategory) {
                    case BYTE: {
                        vector[elementNum] = decWritable.byteValue();
                        break;
                    }
                    case SHORT: {
                        vector[elementNum] = decWritable.shortValue();
                        break;
                    }
                    case INT: {
                        vector[elementNum] = decWritable.intValue();
                        break;
                    }
                    case LONG: {
                        vector[elementNum] = decWritable.longValue();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected type kind " + readerCategory.name());
                    }
                }
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(batchSize, this.precision, this.scale);
                this.longColVector = (LongColumnVector)previousVector;
            } else {
                this.decimalColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.decimalColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.decimalColVector, (ColumnVector)this.longColVector, batchSize);
        }
    }

    public static class AnyIntegerFromDoubleTreeReader
    extends ConvertTreeReader {
        private final TypeDescription readerType;
        private DoubleColumnVector doubleColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromDoubleTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, fileType.getCategory() == TypeDescription.Category.DOUBLE ? new TreeReaderFactory.DoubleTreeReader(columnId, context) : new TreeReaderFactory.FloatTreeReader(columnId, context), context);
            this.readerType = readerType;
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            double doubleValue = this.doubleColVector.vector[elementNum];
            if (!this.doubleCanFitInLong(doubleValue)) {
                this.longColVector.isNull[elementNum] = true;
                this.longColVector.noNulls = false;
            } else {
                this.downCastAnyInteger(this.longColVector, elementNum, (long)doubleValue, this.readerType);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector(batchSize);
                this.longColVector = (LongColumnVector)previousVector;
            } else {
                this.doubleColVector.ensureSize(batchSize, false);
            }
            this.fromReader.nextVector((ColumnVector)this.doubleColVector, isNull, batchSize, filterContext, readPhase);
            this.convertVector((ColumnVector)this.doubleColVector, (ColumnVector)this.longColVector, batchSize);
        }
    }

    public static class AnyIntegerFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private final TypeDescription readerType;
        private final boolean downCastNeeded;

        AnyIntegerFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId, ConvertTreeReaderFactory.createFromInteger(columnId, fileType, context), context);
            this.readerType = readerType;
            this.downCastNeeded = this.integerDownCastNeeded(fileType, readerType);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize, FilterContext filterContext, TypeReader.ReadPhase readPhase) throws IOException {
            block4: {
                LongColumnVector resultColVector;
                block5: {
                    this.fromReader.nextVector(previousVector, isNull, batchSize, filterContext, readPhase);
                    resultColVector = (LongColumnVector)previousVector;
                    if (!this.downCastNeeded) break block4;
                    if (!resultColVector.isRepeating) break block5;
                    if (!resultColVector.noNulls && resultColVector.isNull[0]) break block4;
                    this.downCastAnyInteger(resultColVector, 0, this.readerType);
                    break block4;
                }
                if (resultColVector.noNulls) {
                    for (int i = 0; i < batchSize; ++i) {
                        this.downCastAnyInteger(resultColVector, i, this.readerType);
                    }
                } else {
                    for (int i = 0; i < batchSize; ++i) {
                        if (resultColVector.isNull[i]) continue;
                        this.downCastAnyInteger(resultColVector, i, this.readerType);
                    }
                }
            }
        }
    }

    public static class ConvertTreeReader
    extends TreeReaderFactory.TreeReader {
        TypeReader fromReader;
        private static EnumMap<TypeDescription.Category, Integer> numericTypes = new EnumMap(TypeDescription.Category.class);
        private boolean isParseError;
        private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
        private static final double MAX_LONG_AS_DOUBLE_PLUS_ONE = 9.223372036854776E18;

        ConvertTreeReader(int columnId, TypeReader fromReader, TreeReaderFactory.Context context) throws IOException {
            super(columnId, context);
            this.fromReader = fromReader;
        }

        private static void registerNumericType(TypeDescription.Category kind, int level) {
            numericTypes.put(kind, level);
        }

        static TreeReaderFactory.TreeReader getStringGroupTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            switch (fileType.getCategory()) {
                case STRING: {
                    return new TreeReaderFactory.StringTreeReader(columnId, context);
                }
                case CHAR: {
                    return new TreeReaderFactory.CharTreeReader(columnId, fileType.getMaxLength(), context);
                }
                case VARCHAR: {
                    return new TreeReaderFactory.VarcharTreeReader(columnId, fileType.getMaxLength(), context);
                }
            }
            throw new RuntimeException("Unexpected type kind " + fileType.getCategory().name());
        }

        protected void assignStringGroupVectorEntry(BytesColumnVector bytesColVector, int elementNum, TypeDescription readerType, byte[] bytes) {
            this.assignStringGroupVectorEntry(bytesColVector, elementNum, readerType, bytes, 0, bytes.length);
        }

        protected void assignStringGroupVectorEntry(BytesColumnVector bytesColVector, int elementNum, TypeDescription readerType, byte[] bytes, int start, int length) {
            switch (readerType.getCategory()) {
                case STRING: {
                    bytesColVector.setVal(elementNum, bytes, start, length);
                    break;
                }
                case CHAR: {
                    int charAdjustedDownLen = StringExpr.rightTrimAndTruncate((byte[])bytes, (int)start, (int)length, (int)readerType.getMaxLength());
                    bytesColVector.setVal(elementNum, bytes, start, charAdjustedDownLen);
                    break;
                }
                case VARCHAR: {
                    int varcharAdjustedDownLen = StringExpr.truncate((byte[])bytes, (int)start, (int)length, (int)readerType.getMaxLength());
                    bytesColVector.setVal(elementNum, bytes, start, varcharAdjustedDownLen);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + readerType.getCategory().name());
                }
            }
        }

        protected void convertStringGroupVectorElement(BytesColumnVector bytesColVector, int elementNum, TypeDescription readerType) {
            switch (readerType.getCategory()) {
                case STRING: {
                    break;
                }
                case CHAR: {
                    int charLength = bytesColVector.length[elementNum];
                    int charAdjustedDownLen = StringExpr.rightTrimAndTruncate((byte[])bytesColVector.vector[elementNum], (int)bytesColVector.start[elementNum], (int)charLength, (int)readerType.getMaxLength());
                    if (charAdjustedDownLen >= charLength) break;
                    bytesColVector.length[elementNum] = charAdjustedDownLen;
                    break;
                }
                case VARCHAR: {
                    int varcharLength = bytesColVector.length[elementNum];
                    int varcharAdjustedDownLen = StringExpr.truncate((byte[])bytesColVector.vector[elementNum], (int)bytesColVector.start[elementNum], (int)varcharLength, (int)readerType.getMaxLength());
                    if (varcharAdjustedDownLen >= varcharLength) break;
                    bytesColVector.length[elementNum] = varcharAdjustedDownLen;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + readerType.getCategory().name());
                }
            }
        }

        protected boolean getIsParseError() {
            return this.isParseError;
        }

        protected long parseLongFromString(String string) {
            try {
                long longValue = Long.parseLong(string);
                this.isParseError = false;
                return longValue;
            }
            catch (NumberFormatException e) {
                this.isParseError = true;
                return 0L;
            }
        }

        protected float parseFloatFromString(String string) {
            try {
                float floatValue = Float.parseFloat(string);
                this.isParseError = false;
                return floatValue;
            }
            catch (NumberFormatException e) {
                this.isParseError = true;
                return Float.NaN;
            }
        }

        protected double parseDoubleFromString(String string) {
            try {
                double value = Double.parseDouble(string);
                this.isParseError = false;
                return value;
            }
            catch (NumberFormatException e) {
                this.isParseError = true;
                return Double.NaN;
            }
        }

        protected HiveDecimal parseDecimalFromString(String string) {
            try {
                HiveDecimal value = HiveDecimal.create((String)string);
                return value;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public boolean doubleCanFitInLong(double doubleValue) {
            return -9.223372036854776E18 - doubleValue < 1.0 && doubleValue < 9.223372036854776E18;
        }

        @Override
        public void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            this.fromReader.checkEncoding(encoding);
        }

        @Override
        public void startStripe(StripePlanner planner, TypeReader.ReadPhase readPhase) throws IOException {
            this.fromReader.startStripe(planner, readPhase);
        }

        @Override
        public void seek(PositionProvider[] index, TypeReader.ReadPhase readPhase) throws IOException {
            this.fromReader.seek(index, readPhase);
        }

        @Override
        public void seek(PositionProvider index, TypeReader.ReadPhase readPhase) throws IOException {
            this.fromReader.seek(index, readPhase);
        }

        @Override
        public void skipRows(long items, TypeReader.ReadPhase readPhase) throws IOException {
            this.fromReader.skipRows(items, readPhase);
        }

        public void setConvertVectorElement(int elementNum) throws IOException {
            throw new RuntimeException("Expected this method to be overridden");
        }

        public void convertVector(ColumnVector fromColVector, ColumnVector resultColVector, int batchSize) throws IOException {
            resultColVector.reset();
            if (fromColVector.isRepeating) {
                resultColVector.isRepeating = true;
                if (fromColVector.noNulls || !fromColVector.isNull[0]) {
                    this.setConvertVectorElement(0);
                } else {
                    resultColVector.noNulls = false;
                    resultColVector.isNull[0] = true;
                }
            } else if (fromColVector.noNulls) {
                for (int i = 0; i < batchSize; ++i) {
                    this.setConvertVectorElement(i);
                }
            } else {
                for (int i = 0; i < batchSize; ++i) {
                    if (!fromColVector.isNull[i]) {
                        this.setConvertVectorElement(i);
                        continue;
                    }
                    resultColVector.noNulls = false;
                    resultColVector.isNull[i] = true;
                }
            }
        }

        public void downCastAnyInteger(LongColumnVector longColVector, int elementNum, TypeDescription readerType) {
            this.downCastAnyInteger(longColVector, elementNum, longColVector.vector[elementNum], readerType);
        }

        public void downCastAnyInteger(LongColumnVector longColVector, int elementNum, long inputLong, TypeDescription readerType) {
            long outputLong;
            long[] vector = longColVector.vector;
            TypeDescription.Category readerCategory = readerType.getCategory();
            switch (readerCategory) {
                case BOOLEAN: {
                    vector[elementNum] = inputLong == 0L ? 0L : 1L;
                    return;
                }
                case BYTE: {
                    outputLong = (byte)inputLong;
                    break;
                }
                case SHORT: {
                    outputLong = (short)inputLong;
                    break;
                }
                case INT: {
                    outputLong = (int)inputLong;
                    break;
                }
                case LONG: {
                    vector[elementNum] = inputLong;
                    return;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + readerCategory.name());
                }
            }
            if (outputLong != inputLong) {
                longColVector.isNull[elementNum] = true;
                longColVector.noNulls = false;
            } else {
                vector[elementNum] = outputLong;
            }
        }

        protected boolean integerDownCastNeeded(TypeDescription fileType, TypeDescription readerType) {
            Integer fileLevel = numericTypes.get((Object)fileType.getCategory());
            Integer schemaLevel = numericTypes.get((Object)readerType.getCategory());
            return schemaLevel < fileLevel;
        }

        static {
            ConvertTreeReader.registerNumericType(TypeDescription.Category.BOOLEAN, 1);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.BYTE, 2);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.SHORT, 3);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.INT, 4);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.LONG, 5);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.FLOAT, 6);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.DOUBLE, 7);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.DECIMAL, 8);
        }
    }
}

