/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.common.collect;

import java.util.Collection;
import java.util.Iterator;

public class BaseOperator {
    static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new IllegalArgumentException("The arg is null");
        }
        return reference;
    }

    static int saturatedCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    static int computeArrayListCapacity(int arraySize) {
        BaseOperator.checkNonnegative(arraySize, "arraySize");
        return BaseOperator.saturatedCast(5L + (long)arraySize + (long)(arraySize / 10));
    }

    static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        BaseOperator.checkNotNull(addTo);
        BaseOperator.checkNotNull(iterator);
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return wasModified;
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        if (elementsToAdd instanceof Collection) {
            Collection<? extends T> c = BaseOperator.cast(elementsToAdd);
            return addTo.addAll(c);
        }
        return BaseOperator.addAll(addTo, BaseOperator.checkNotNull(elementsToAdd).iterator());
    }

    static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }
}

